<?php

/**
 *    Zenbership
 *    http://www.zenbership.com/
 *    (c) 2012, Castlamp.
 *
 *    Purpose: User management page:
 *    -> Update Account
 *
 *    WARNING!
 *    DO NOT EDIT THIS FILE!
 *    To change the calendar's
 *    apperance, please edit the
 *    program templates from the
 *    "Integration" section of the
 *    admin control panel.
 *
 */
// Load the basics
require "../admin/sd-system/config.php";
// Check a user's session
$session = new session;
$ses     = $session->check_session();
if ($ses['error'] == '1') {
    $session->reject('login', $ses['ecode']);
    exit;
} else {
    // Member
    $user   = new user;
    $member = $user->get_user($ses['member_id']);
    /**
     * Pagination
     */
    $add_get = array();
    $filters = array(
        'ppSD_event_rsvps.user_id' => array('scope' => 'AND', 'value' => $ses['member_id'], 'eq' => 'eq'),
    );
    $join    = array(
        'table'    => 'ppSD_events',
        'on'       => 'id',
        'table_id' => 'event_id'
    );
    if (!empty($_GET['organize'])) {
        if ($_GET['organize'] == 'date_rl') {
            $_GET['order'] = 'ppSD_events.starts';
            $_GET['dir']   = 'ASC';
        } else {
            $_GET['order'] = 'ppSD_events.starts';
            $_GET['dir']   = 'DESC';
        }
        $add_get['organize'] = $_GET['organize'];
    }
    if (empty($_GET['organize'])) {
        $_GET['organize'] = '';
    }
    if (empty($_GET['order'])) {
        $_GET['order'] = 'ppSD_events.starts';
    }
    if (empty($_GET['dir'])) {
        $_GET['dir'] = 'ASC';
    }
    if (empty($_GET['display'])) {
        $_GET['display'] = '24';
    }
    $paginate  = new pagination('ppSD_event_rsvps', 'manage/events.php', $add_get, $_GET, $filters, $join, '');
    $event     = new event;
    $formatted = '';
    $STH       = $db->run_query($paginate->{'query'});
    while ($row = $STH->fetch()) {
        $eventdata = $event->get_event($row['event_id']);
        $rsvpdata  = $event->get_rsvp($row['id']);
        $changes   = array(
            'rsvp'  => $rsvpdata,
            'event' => $eventdata['data'],
        );
        $formatted .= new template('manage_event_rsvps_entry', $changes, '0');
        //pa($order);
    }
    // Billing History
    //pa($pagination);
    // Template
    $changes = array(
        'cards'      => $formatted,
        'pagination' => $paginate->{'rendered_pages'}
    );
    $wrapper = new template('manage_event_rsvps', $changes, '1');
    echo $wrapper;
    exit;
}

