/**
 *    Auto-complete feature
 *    Copyright (c) 2013. All Rights Reserved.
 *
 * This is the "chuncky" of the feature.
 * search_box_id    = Gets value and positions UL of options.
 * populate_on_return    = ID of element to populate when a result is selected from fucntion autocomplete_select
 * return_field        = The field that is being populated into the hidden div, usually the ID. This is what goes into the DB.
 * display_field    = The field that is displayed in the "fake" field. Usually a name or username.
 * table_to_search    = MySQL table to search
 * fields_to_search    = CSV list of cols in the MySQL table that are being searched for value
 * permission        = Employee permission to check before proceeding to search
 *
 * CSS: Items are returned in a UL element with class "autocom"
 */

var theid;
var thehiddenid;
var appending;
var typingTimerAjax;

function autocom(search_box_id, return_field, display_field, table_to_search, fields_to_search, permission, append) {
    show_loading();

    clearTimeout(typingTimerAjax);

    typingTimerAjax = setTimeout(function() {
        doAutoCom(search_box_id, return_field, display_field, table_to_search, fields_to_search, permission, append);
        close_loading();
    }, 400);
}


function doAutoCom(search_box_id, return_field, display_field, table_to_search, fields_to_search, permission, append) {
    var value = $('#' + search_box_id).val();
    var length = value.length;
    var populate_on_return = search_box_id + "_id";
    theid = search_box_id;
    thehiddenid = populate_on_return;
    $('.autocom').remove();
    if (length > 1) {
        if (append == '1') {
            appending = '1';
            //var exp_list = value.split(',');
            //var len = exp_list.length;
            //var last = len - 1;
            //value = exp_list[last];
        }
        send_data = 'value=' + value + '&display_field=' + display_field + '&return_field=' + return_field + '&populate=' + populate_on_return + '&table=' + table_to_search + '&fields=' + fields_to_search + '&permission=' + permission;
        $.post('cp-includes/autocomplete.php', send_data, function (theResponse) {
            var returned = theResponse.split('+++');
            if (debug == 1) {
                console.log(theResponse);
            }
            if (returned['0'] == '1') {
                var results = parseInt(returned['1']);
                if (results > 0) {
                    var width = $('#' + search_box_id).innerWidth();
                    var height = $('#' + search_box_id).innerHeight();
                    var main_pos = $('#' + search_box_id).offset();
                    var top_put = main_pos.top + height;
                    var putcontent = '<ul class="autocom" style="z-index:110;position:absolute;left:' + main_pos.left + 'px;top:' + top_put + 'px;width:' + width + 'px;">' + returned['2'] + '</ul>';
                    $('body').append(putcontent);
                }
            } else {
                handle_error(returned['1']);
            }
        });
        return false;
    }
}
/**
 * Not quite as chuncky, but still good stuff
 * right here. This will actually select an
 * option returned from function autocomplete.
 */
function autocomplete_select(selected_value, display_field) {
    if (appending == '1') {
        // $('#' + theid).val($('#' + theid).val() + display_field + ', ');
        var width = $('#' + theid).width();
        var randomnumber = Math.floor(Math.random() * 11);
        var put = '<span title="Click to Remove" style="width:' + width + 'px;" class="atag" id="' + randomnumber + '" onclick="return closeDiv(\'' + randomnumber + '\',\'\',\'1\')">' + selected_value + '<input type="hidden" name="' + theid + '[]" value="' + selected_value + '" /></span>';
        $('#' + theid).after(put);
        $('#' + theid).val('');
    } else {
        $('#' + theid).addClass('savedAutocomplete');
        $('#' + theid).val(display_field);
        $('#' + thehiddenid).val(selected_value);
        $('#' + theid).focus();
    }
    $('.autocom').remove();
}