<?php

$error = false;
$scope = (! empty($_POST['scope'])) ? strtolower($_POST['scope']) : 'member';
$act = (! empty($_POST['act'])) ? strtolower($_POST['act']) : '';
$cid = (! empty($_POST['cid'])) ? $_POST['cid'] : '';

if (empty($cid) || empty($act)) {
    $error = true;
    $errorMsg = 'Criteria ID and/or action are required.';
}

$criteriaAction = new criteriaActions($scope);

if (! $criteriaAction->checkValidAction($act)) {
    $error = true;
    $errorMsg = 'Could not find action file.';
}

$criteriaAction->setCriteria($_POST['cid']);

$info = $criteriaAction->getInfo($act);

?>

<script type="text/javascript">
    $.ctrl('S', function () {
        return json_add('criteria_action_run', '<?php echo $act; ?>');
    });
</script>

<form action="" method="post" id="popupform" onsubmit="return json_add('criteria_action_run','<?php echo $act; ?>');">

    <div id="popupsave">
        <input type="submit" value="Run Action" class="save" />
        <input type="hidden" name="cid" value="<?php echo $cid; ?>" />
        <input type="hidden" name="scope" value="<?php echo $scope; ?>" />
    </div>

<h1>Criteria-Based Actions</h1>
<div class="popupbody fullForm">
    <p class="highlight">Criteria-based actions allow you to perform a standardized set of functions on a pre-set group of members of contacts who match existing criteria.</p>

<?php

if ($error) {
?>

    <div class="pad24">
        <h2>Error</h2>
        <p><?php echo $errorMsg; ?></p>
    </div>

<?php
} else {
?>

    <div class="col33l">
        <fieldset>
            <legend>Action Overview</legend>
            <div class="pad24">
                <b><?php
                    echo $info->name;
                    ?></b><br />
                <?php
                echo $info->description;
                ?>
            </div>
        </fieldset>
        <fieldset>
            <legend>Criteria Overview</legend>
            <div class="pad24">
                <?php
                echo $criteriaAction->criteria->readable;
                ?>
            </div>
        </fieldset>
    </div>
    <div class="col66r">
        <fieldset>
            <legend>Action Specifics</legend>
            <div class="pad24">
                <?php
                echo $criteriaAction->renderFields();
                ?>
            </div>
        </fieldset>
    </div>
    <div class="clear"></div>

<?php
}

?>

</div>
</form>