<?php



/**
 *
 *
 * Zenbership Membership Software
 * Copyright (C) 2013-2016 Castlamp, LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author      Castlamp
 * @link        http://www.castlamp.com/
 * @link        http://www.zenbership.com/
 * @copyright   (c) 2013-2016 Castlamp
 * @license     http://www.gnu.org/licenses/gpl-3.0.en.html
 * @project     Zenbership Membership Software
 */
if (empty($_POST['id'])) {
    $admin->show_popup_error('No conversion selected.');

} else {
    $contact = new contact;
    $details = $contact->get_conversion($_POST['id']);
    if (empty($details)) {
        $admin->show_popup_error('Conversion not found.');

    } else {
        ?>



        <div id="popupsave">

            <input type="button" value="View Contact"
                   onclick="return load_page('contact','view','<?php echo $details['contact_id']; ?>');"/>

            <?php

            if (!empty($details['user_id'])) {
                echo "<input type=\"button\" value=\"View Member\" onclick=\"return load_page('member','view','" . $details['user_id'] . "');\" />";

            }

            ?>

        </div>

        <h1>Conversion Details</h1>



        <div class="pad24t popupbody">


            <fieldset>

                <legend>Overview</legend>

                <div class="pad24t">

                    <dl>

                        <dt>Date</dt>

                        <dd><?php echo $details['date_show']; ?></dd>

                        <dt>Conversion Time</dt>

                        <dd><?php echo $details['time_to_convert']; ?></dd>

                        <dt>Converted By</dt>

                        <dd><?php $employee = $admin->get_employee('', $details['owner']);
                            echo $employee['username']; ?></dd>

                    </dl>

                    <div class="clear"></div>

                </div>

            </fieldset>


            <fieldset>

                <legend>Value</legend>

                <div class="pad24t">

                    <dl>

                        <dt>Expected Value</dt>

                        <dd><?php echo $details['estimated_formatted']; ?></dd>

                        <dt>Actual Value</dt>

                        <dd><?php echo $details['actual_formatted']; ?></dd>

                        <dt>Difference</dt>

                        <dd><?php echo $details['difference']; ?></dd>

                        <dt>Change</dt>

                        <dd><?php

                            if ($details['percent_change'] > 0) {
                                echo '<div class="positive">+' . $details['percent_change'] . '%</div>';

                            } else if ($details['percent_change'] < 0) {
                                echo '<div class="negative">-' . $details['percent_change'] . '%</div>';

                            } else {
                                echo '=';

                            }

                            ?></dd>

                    </dl>

                    <div class="clear"></div>

                </div>

            </fieldset>


        </div>

        <div class="clear"></div>



        </div>



    <?php

    }

}