<?php

/**
 * DATABASE MAINTENANCE AND CLEANING
 * This file is part of a cron job (index.php)
 * All necessary classes have been pre-loaded.
 *
 * Zenbership Membership Software
 * Copyright (C) 2013-2016 Castlamp, LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author      Castlamp
 * @link        http://www.castlamp.com/
 * @link        http://www.zenbership.com/
 * @copyright   (c) 2013-2016 Castlamp
 * @license     http://www.gnu.org/licenses/gpl-3.0.en.html
 * @project     Zenbership Membership Software
 */

// Clear temporary data.
$db->clear_temp_data();

// Mark memberships inactive.
$user = new user;
$user->check_inactive();


// Clean up some potential incorrect member IDs
// on orders
$cart = new cart;
$last_run = $db->get_option('cron_last_run');
$orders = $db->run_query("
    SELECT
        `id`,`member_id`,`member_type`
    FROM
        ppSD_cart_sessions
    WHERE
        `date_completed` >= '" . $db->mysql_clean($last_run) . "' AND
        `member_type`='member'
");
while ($row = $orders->fetch()) {
    if (! empty($row['member_id'])) {
        $find_user = $user->get_username($row['member_id']);
        if (empty($find_user)) {
            $updated = $cart->updateOrderUserType($row['id'], 'contact');
        }
    }
}


// Re-secure key folders.
secure_folder(PP_PATH . '/admin/sd-system/attachments');
secure_folder(PP_PATH . '/admin/sd-system/exports');

/**
 * Creates "off-limits" security for
 * folders that cannot be accessed from
 * a web browser.
 *
 * @param string $folder Path to folder.
 */
function secure_folder($folder)
{
    // .htaccess file
    $final_data = "# Generated by Zenbership.\n";
    $final_data .= "# IMPORTANT SECURITY FILE! DO NOT ALTER OR DELETE!\n";
    $final_data .= "# Zenbership: http://www.zenbership.com/\n";
    $final_data .= "AuthUserFile " . $folder . "/.htpasswd\n";
    $final_data .= "AuthName \"Content Off Limits\"\n";
    $final_data .= "AuthType Basic\n";
    $final_data .= "require valid-user";
    $htfile = $folder . "/.htaccess";
    if ($fh = fopen($htfile, 'w')) {
        fwrite($fh, $final_data);
        fclose($fh);
    }
    // .htpasswd file
    $content = md5(uniqid(rand(), true)) . ":" . crypt(md5(uniqid(rand(), true)) . md5(time() . rand(10000, 99999999))) . "\n";
    $htfile1 = $folder . "/.htpasswd";
    if ($fh = fopen($htfile1, 'w')) {
        fwrite($fh, $content);
        fclose($fh);
    }
}