/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as v,html as n,nothing as a}from"lit";import{property as m,customElement as $}from"lit/decorators.js";import{until as k}from"lit/directives/until.js";import{unsafeHTML as u}from"lit/directives/unsafe-html.js";import{classMap as C}from"lit/directives/class-map.js";import y from"@typo3/core/ajax/ajax-request.js";import h from"@typo3/backend/notification.js";import"@typo3/backend/element/spinner-element.js";import"@typo3/backend/element/icon-element.js";var b=function(l,e,o,t){var r=arguments.length,i=r<3?e:t===null?t=Object.getOwnPropertyDescriptor(e,o):t,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")i=Reflect.decorate(l,e,o,t);else for(var p=l.length-1;p>=0;p--)(d=l[p])&&(i=(r<3?d(i):r>3?d(e,o,i):d(e,o))||i);return r>3&&i&&Object.defineProperty(e,o,i),i},f,c;(function(l){l.cut="cut",l.copy="copy"})(c||(c={}));let s=f=class extends v{constructor(){super(...arguments),this.returnUrl="",this.table=""}static renderLoader(){return n`<div class="panel panel-default"><div class=panel-loader><typo3-backend-spinner size=small></typo3-backend-spinner></div></div>`}createRenderRoot(){return this}render(){return n`${k(this.renderPanel(),f.renderLoader())}`}renderPanel(){return new y(top.TYPO3.settings.Clipboard.moduleUrl).withQueryArguments({action:"getClipboardData"}).post({table:this.table}).then(async e=>{const o=await e.resolve();if(o.success===!0&&o.data){const t=o.data;return n`<div class="panel panel-default" data-clipboard-panel><div class=panel-heading>${t.labels.clipboard}</div><div class=table-fit><table class=table><tbody>${t.tabs.map(r=>this.renderTab(r,t))}</tbody></table></div></div>`}else return n`<div class="alert alert-danger">Clipboard data could not be fetched</div>`}).catch(()=>n`<div class="alert alert-danger">An error occurred while fetching clipboard data</div>`)}renderTab(e,o){return n`<tr><td colspan=2 class=nowrap><button type=button class="btn btn-link" aria-checked=${o.current===e.identifier} title=${e.description} data-action=setP @click=${t=>this.updateClipboard(t,{CB:{setP:e.identifier}})}>${o.current===e.identifier?n`<typo3-backend-icon identifier=actions-check-circle-alt size=small></typo3-backend-icon>${e.title} ${e.info}`:n`<typo3-backend-icon identifier=actions-circle size=small></typo3-backend-icon><span class=text-body-secondary> ${e.title} ${e.info} </span>`}</button></td><td class="col-control nowrap">${o.current!==e.identifier?a:n`<div class=btn-group><input type=radio class=btn-check id=clipboard-copymode-copy data-action=setCopyMode ?checked=${o.copyMode===c.copy} @click=${t=>this.updateClipboard(t,{CB:{setCopyMode:"1"}})}> <label class="btn btn-default btn-sm" for=clipboard-copymode-copy><typo3-backend-icon identifier=actions-edit-copy size=small></typo3-backend-icon>${o.labels.copyElements}</label> <input type=radio class=btn-check id=clipboard-copymode-move data-action=setCopyMode ?checked=${o.copyMode!==c.copy} @click=${t=>this.updateClipboard(t,{CB:{setCopyMode:"0"}})}> <label class="btn btn-default btn-sm" for=clipboard-copymode-move><typo3-backend-icon identifier=actions-cut size=small></typo3-backend-icon>${o.labels.moveElements}</label></div>${o.elementCount?n`<button type=button class="btn btn-default btn-sm" title=${o.labels.removeAll} data-action=removeAll @click=${t=>this.updateClipboard(t,{CB:{removeAll:e.identifier}})}><typo3-backend-icon identifier=actions-minus size=small></typo3-backend-icon>${o.labels.removeAll}</button>`:a}`}</td></tr>${o.current===e.identifier&&e.items?e.items.map(t=>this.renderTabItem(t,e.identifier,o)):a}`}renderTabItem(e,o,t){return n`<tr><td class="col-icon nowrap ${C({"ps-4":!e.identifier})}">${u(e.icon)}</td><td class=nowrap style=width:95%>${u(e.title)} ${o==="normal"?n`<strong>(${t.copyMode===c.copy?n`${t.labels.copy}`:n`${t.labels.cut}`})</strong>`:a} ${e.thumb?n`<div class=d-block>${u(e.thumb)}</div>`:a}</td><td class="col-control nowrap"><div class=btn-group>${e.infoDataDispatch?n`<button type=button class="btn btn-default btn-sm" data-dispatch-action=${e.infoDataDispatch.action} data-dispatch-args=${e.infoDataDispatch.args} title=${t.labels.info}><typo3-backend-icon identifier=actions-document-info size=small></typo3-backend-icon></button>`:a} ${e.identifier?n`<button type=button class="btn btn-default btn-sm" title=${t.labels.removeItem} data-action=remove @click=${r=>this.updateClipboard(r,{CB:{remove:e.identifier}})}><typo3-backend-icon identifier=actions-minus size=small></typo3-backend-icon>${t.labels.removeItem}</button>`:a}</div></td></tr>`}updateClipboard(e,o){e.preventDefault();const t=e.currentTarget;new y(top.TYPO3.settings.Clipboard.moduleUrl).post(o).then(async r=>{const i=await r.resolve();i.success===!0?(t.dataset.action&&t.dispatchEvent(new CustomEvent("typo3:clipboard:"+t.dataset.action,{detail:{payload:o,response:i},bubbles:!0,cancelable:!1})),this.reloadModule()):h.error("Clipboard data could not be updated")}).catch(()=>{h.error("An error occurred while updating clipboard data")})}reloadModule(){this.returnUrl?this.ownerDocument.location.href=this.returnUrl:this.ownerDocument.location.reload()}};b([m({type:String,attribute:"return-url"})],s.prototype,"returnUrl",void 0),b([m({type:String})],s.prototype,"table",void 0),s=f=b([$("typo3-backend-clipboard-panel")],s);export{s as ClipboardPanel};
