<?php

/**
 * Этот файл является частью программы "CRM Руководитель" - конструктор CRM систем для бизнеса
 * https://www.rukovoditel.net.ru/
 * 
 * CRM Руководитель - это свободное программное обеспечение, 
 * распространяемое на условиях GNU GPLv3 https://www.gnu.org/licenses/gpl-3.0.html
 * 
 * Автор и правообладатель программы: Харчишина Ольга Александровна (RU), Харчишин Сергей Васильевич (RU).
 * Государственная регистрация программы для ЭВМ: 2023664624
 * https://fips.ru/EGD/3b18c104-1db7-4f2d-83fb-2d38e1474ca3
 */

class items_redirects
{
    static function get_reports_choices($entities_id)
    {
        global $app_entities_cache;
        $choices = [];
        
        $entities_query = db_query("select id, name from app_entities where parent_id={$entities_id}");
        while($entities = db_fetch_array($entities_query))
        {        
            $reports_query = db_query("select g.id, g.name from app_ext_ganttchart g, app_entities e where e.id=g.entities_id and e.id={$entities['id']} order by g.name");
            while($v = db_fetch_array($reports_query))
            {
                $choices[$entities['name'] . ': ' . TEXT_EXT_GANTTCHART_REPORT]['ganttreport' . $v['id']] = $v['name'];
            }

            $reports_query = db_query("select k.id, k.name from app_ext_kanban k, app_entities e where e.id=k.entities_id and e.id={$entities['id']} order by k.name");
            while($v = db_fetch_array($reports_query))
            {
                $choices[$entities['name'] . ': ' . TEXT_EXT_KANBAN]['kanban' . $v['id']] = $v['name'];
            }

            $reports_query = db_query("select c.id, c.name from app_ext_calendar c, app_entities e where e.id=c.entities_id and e.id={$entities['id']} order by c.name");
            while($v = db_fetch_array($reports_query))
            {
                $choices[$entities['name'] . ': ' . TEXT_EXT_СALENDAR]['calendarreport' . $v['id']] = $v['name'];
            }                        
        }
        
        $reports_query = db_query("select c.id, c.name from app_ext_report_page c, app_entities e where e.id=c.entities_id and e.id={$entities_id} order by c.name",false);
        while($v = db_fetch_array($reports_query))
        {
            $choices[$app_entities_cache[$entities_id]['name'] . ': ' . TEXT_EXT_REPORT_DESIGNER]['report_page' . $v['id']] = $v['name'];
        }
        
        return $choices;
    }
    
    static function redirect_to_report($reports_type,$path)
    {
        global $app_user;
        
        $reports_id = str_replace(entities_menu::get_reports_types(), '', $reports_type);                
        
        switch(true)
        {
            case strstr($reports_type, 'report_page'):
                $reports_query = db_query("select id, name from app_ext_report_page where id='" . $reports_id . "' and is_active=1 and (find_in_set('" . $app_user['group_id'] . "',users_groups) or find_in_set('" . $app_user['id'] . "',assigned_to))");
                if($reports_info = db_fetch_array($reports_query))
                {
                    redirect_to('report_page/view', 'id=' . $reports_info['id'] . '&path=' . $path );
                }
                break;
            case strstr($reports_type, 'ganttreport'):
                if($app_user['group_id'] > 0)
                {
                    $reports_query = db_query("select g.id, g.name,g.entities_id from app_ext_ganttchart g, app_entities e, app_ext_ganttchart_access ga where g.id='" . $reports_id . "' and e.id=g.entities_id  and g.id=ga.ganttchart_id and ga.access_groups_id='" . db_input($app_user['group_id']) . "' order by name");
                }
                else
                {
                    $reports_query = db_query("select g.id, g.name,g.entities_id from app_ext_ganttchart g, app_entities e where g.id='" . $reports_id . "' and  e.id=g.entities_id order by g.name");
                }

                if($reports_info = db_fetch_array($reports_query))
                {
                    redirect_to('ext/ganttchart/dhtmlx', 'id=' . $reports_info['id'] . '&path=' . $path . '/' . $reports_info['entities_id']);
                }
                
                break;
            case strstr($reports_type, 'kanban'):
                if($app_user['group_id'] > 0)
                {
                    $reports_query = db_query("select c.id, c.name, c.entities_id from app_ext_kanban c, app_entities e where c.id='" . $reports_id . "' and e.id=c.entities_id and find_in_set(" . $app_user['group_id'] . ",c.users_groups) order by c.name");
                }
                else
                {
                    $reports_query = db_query("select c.id, c.name, c.entities_id from app_ext_kanban c, app_entities e where c.id='" . $reports_id . "' and e.id=c.entities_id order by c.name");
                }

                if($reports_info = db_fetch_array($reports_query))
                {
                    redirect_to('ext/kanban/view', 'id=' . $reports_info['id']. '&path=' . $path . '/' . $reports_info['entities_id']);
                }
                break;  
            case strstr($reports_type, 'calendarreport'):
                if($app_user['group_id'] > 0)
                {
                    $reports_query = db_query("select c.* from app_ext_calendar c, app_entities e, app_ext_calendar_access ca where c.id='" . $reports_id . "' and e.id=c.entities_id and c.id=ca.calendar_id and ca.access_groups_id='" . db_input($app_user['group_id']) . "' order by c.name");
                }
                else
                {
                    $reports_query = db_query("select c.* from app_ext_calendar c, app_entities e where c.id='" . $reports_id . "' and  e.id=c.entities_id order by c.name");
                }

                if($reports_info = db_fetch_array($reports_query))
                {
                    redirect_to('ext/calendar/report', 'id=' . $reports_info['id']. '&path=' . $path . '/' . $reports_info['entities_id']);                    
                }
                break;    
        }
        
        
    }
}