
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `qtoa188`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blobs`
--

CREATE TABLE `[[dbprefix]]blobs` (
  `blobid` bigint(20) unsigned NOT NULL,
  `format` varchar(20) CHARACTER SET ascii NOT NULL,
  `content` mediumblob,
  `filename` varchar(255) DEFAULT NULL,
  `userid` int(10) unsigned DEFAULT NULL,
  `cookieid` bigint(20) unsigned DEFAULT NULL,
  `createip` varbinary(16) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`blobid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache`
--

CREATE TABLE `[[dbprefix]]cache` (
  `type` char(8) CHARACTER SET ascii NOT NULL,
  `cacheid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content` mediumblob NOT NULL,
  `created` datetime NOT NULL,
  `lastread` datetime NOT NULL,
  PRIMARY KEY (`type`,`cacheid`),
  KEY `lastread` (`lastread`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `categoryid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(10) unsigned DEFAULT NULL,
  `title` varchar(80) NOT NULL,
  `tags` varchar(200) NOT NULL,
  `content` varchar(800) NOT NULL DEFAULT '',
  `qcount` int(10) unsigned NOT NULL DEFAULT '0',
  `position` smallint(5) unsigned NOT NULL,
  `backpath` varchar(804) NOT NULL DEFAULT '',
  PRIMARY KEY (`categoryid`),
  UNIQUE KEY `parentid` (`parentid`,`tags`),
  UNIQUE KEY `parentid_2` (`parentid`,`position`),
  KEY `backpath` (`backpath`(200))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categorymetas`
--

CREATE TABLE `[[dbprefix]]categorymetas` (
  `categoryid` int(10) unsigned NOT NULL,
  `title` varchar(40) NOT NULL,
  `content` varchar(8000) NOT NULL,
  PRIMARY KEY (`categoryid`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contentwords`
--

CREATE TABLE `[[dbprefix]]contentwords` (
  `postid` int(10) unsigned NOT NULL,
  `wordid` int(10) unsigned NOT NULL,
  `count` tinyint(3) unsigned NOT NULL,
  `type` enum('Q','A','C','NOTE') NOT NULL,
  `questionid` int(10) unsigned NOT NULL,
  KEY `postid` (`postid`),
  KEY `wordid` (`wordid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cookies`
--

CREATE TABLE `[[dbprefix]]cookies` (
  `cookieid` bigint(20) unsigned NOT NULL,
  `created` datetime NOT NULL,
  `createip` varbinary(16) NOT NULL,
  `written` datetime DEFAULT NULL,
  `writeip` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`cookieid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]iplimits`
--

CREATE TABLE `[[dbprefix]]iplimits` (
  `ip` varbinary(16) NOT NULL,
  `action` char(1) CHARACTER SET ascii NOT NULL,
  `period` int(10) unsigned NOT NULL,
  `count` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `ip` (`ip`,`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `messageid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('PUBLIC','PRIVATE') NOT NULL DEFAULT 'PRIVATE',
  `fromuserid` int(10) unsigned DEFAULT NULL,
  `touserid` int(10) unsigned DEFAULT NULL,
  `fromhidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tohidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `content` varchar(12000) NOT NULL,
  `format` varchar(20) CHARACTER SET ascii NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`messageid`),
  KEY `type` (`type`,`fromuserid`,`touserid`,`created`),
  KEY `touserid` (`touserid`,`type`,`created`),
  KEY `fromhidden` (`fromhidden`),
  KEY `tohidden` (`tohidden`),
  KEY `[[dbprefix]]messages_ibfk_1` (`fromuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]options`
--

CREATE TABLE `[[dbprefix]]options` (
  `title` varchar(40) NOT NULL,
  `content` varchar(12000) NOT NULL,
  PRIMARY KEY (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]options`
--

INSERT INTO `[[dbprefix]]options` VALUES
('block_bad_usernames', 'anonymous'),
('cache_userpointscount', '1'),
('confirm_user_emails', '1'),
('db_version', '67'),
('enabled_plugins', ''),
('event_logger_to_database', ''),
('event_logger_to_files', ''),
('feedback_email', '[[admin_email]]'),
('from_email', 'no-reply@[[domhost]]'),
('points_a_selected', '30'),
('points_a_voted_max_gain', '20'),
('points_a_voted_max_loss', '5'),
('points_base', '100'),
('points_c_voted_max_gain', '10'),
('points_c_voted_max_loss', '3'),
('points_multiple', '10'),
('points_per_a_voted', ''),
('points_per_a_voted_down', '2'),
('points_per_a_voted_up', '2'),
('points_per_c_voted_down', '0'),
('points_per_c_voted_up', '0'),
('points_per_q_voted', ''),
('points_per_q_voted_down', '1'),
('points_per_q_voted_up', '1'),
('points_post_a', '4'),
('points_post_q', '2'),
('points_q_voted_max_gain', '10'),
('points_q_voted_max_loss', '3'),
('points_select_a', '3'),
('points_vote_down_a', '1'),
('points_vote_down_q', '1'),
('points_vote_on_a', ''),
('points_vote_on_q', ''),
('points_vote_up_a', '1'),
('points_vote_up_q', '1'),
('register_notify_admin', ''),
('show_custom_welcome', '0'),
('show_notice_welcome', ''),
('site_language', ''),
('site_url', '[[softurl]]/'),
('smtp_active', ''),
('site_title', '[[site_name]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `pageid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL,
  `nav` char(1) CHARACTER SET ascii NOT NULL,
  `position` smallint(5) unsigned NOT NULL,
  `flags` tinyint(3) unsigned NOT NULL,
  `permit` tinyint(3) unsigned DEFAULT NULL,
  `tags` varchar(200) NOT NULL,
  `heading` varchar(800) DEFAULT NULL,
  `content` mediumtext,
  PRIMARY KEY (`pageid`),
  UNIQUE KEY `position` (`position`),
  KEY `tags` (`tags`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]postmetas`
--

CREATE TABLE `[[dbprefix]]postmetas` (
  `postid` int(10) unsigned NOT NULL,
  `title` varchar(40) NOT NULL,
  `content` varchar(8000) NOT NULL,
  PRIMARY KEY (`postid`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `postid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('Q','A','C','Q_HIDDEN','A_HIDDEN','C_HIDDEN','Q_QUEUED','A_QUEUED','C_QUEUED','NOTE') NOT NULL,
  `parentid` int(10) unsigned DEFAULT NULL,
  `categoryid` int(10) unsigned DEFAULT NULL,
  `catidpath1` int(10) unsigned DEFAULT NULL,
  `catidpath2` int(10) unsigned DEFAULT NULL,
  `catidpath3` int(10) unsigned DEFAULT NULL,
  `acount` smallint(5) unsigned NOT NULL DEFAULT '0',
  `amaxvote` smallint(5) unsigned NOT NULL DEFAULT '0',
  `selchildid` int(10) unsigned DEFAULT NULL,
  `closedbyid` int(10) unsigned DEFAULT NULL,
  `userid` int(10) unsigned DEFAULT NULL,
  `cookieid` bigint(20) unsigned DEFAULT NULL,
  `createip` varbinary(16) DEFAULT NULL,
  `lastuserid` int(10) unsigned DEFAULT NULL,
  `lastip` varbinary(16) DEFAULT NULL,
  `upvotes` smallint(5) unsigned NOT NULL DEFAULT '0',
  `downvotes` smallint(5) unsigned NOT NULL DEFAULT '0',
  `netvotes` smallint(6) NOT NULL DEFAULT '0',
  `lastviewip` varbinary(16) DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `hotness` float DEFAULT NULL,
  `flagcount` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `format` varchar(20) CHARACTER SET ascii NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `updated` datetime DEFAULT NULL,
  `updatetype` char(1) CHARACTER SET ascii DEFAULT NULL,
  `title` varchar(800) DEFAULT NULL,
  `content` varchar(12000) DEFAULT NULL,
  `tags` varchar(800) DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  `notify` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`postid`),
  KEY `type` (`type`,`created`),
  KEY `type_2` (`type`,`acount`,`created`),
  KEY `type_4` (`type`,`netvotes`,`created`),
  KEY `type_5` (`type`,`views`,`created`),
  KEY `type_6` (`type`,`hotness`),
  KEY `type_7` (`type`,`amaxvote`,`created`),
  KEY `parentid` (`parentid`,`type`),
  KEY `userid` (`userid`,`type`,`created`),
  KEY `selchildid` (`selchildid`,`type`,`created`),
  KEY `closedbyid` (`closedbyid`),
  KEY `catidpath1` (`catidpath1`,`type`,`created`),
  KEY `catidpath2` (`catidpath2`,`type`,`created`),
  KEY `catidpath3` (`catidpath3`,`type`,`created`),
  KEY `categoryid` (`categoryid`,`type`,`created`),
  KEY `createip` (`createip`,`created`),
  KEY `updated` (`updated`,`type`),
  KEY `flagcount` (`flagcount`,`created`,`type`),
  KEY `catidpath1_2` (`catidpath1`,`updated`,`type`),
  KEY `catidpath2_2` (`catidpath2`,`updated`,`type`),
  KEY `catidpath3_2` (`catidpath3`,`updated`,`type`),
  KEY `categoryid_2` (`categoryid`,`updated`,`type`),
  KEY `lastuserid` (`lastuserid`,`updated`,`type`),
  KEY `lastip` (`lastip`,`updated`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posttags`
--

CREATE TABLE `[[dbprefix]]posttags` (
  `postid` int(10) unsigned NOT NULL,
  `wordid` int(10) unsigned NOT NULL,
  `postcreated` datetime NOT NULL,
  KEY `postid` (`postid`),
  KEY `wordid` (`wordid`,`postcreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sharedevents`
--

CREATE TABLE `[[dbprefix]]sharedevents` (
  `entitytype` char(1) CHARACTER SET ascii NOT NULL,
  `entityid` int(10) unsigned NOT NULL,
  `questionid` int(10) unsigned NOT NULL,
  `lastpostid` int(10) unsigned NOT NULL,
  `updatetype` char(1) CHARACTER SET ascii DEFAULT NULL,
  `lastuserid` int(10) unsigned DEFAULT NULL,
  `updated` datetime NOT NULL,
  KEY `entitytype` (`entitytype`,`entityid`,`updated`),
  KEY `questionid` (`questionid`,`entitytype`,`entityid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tagmetas`
--

CREATE TABLE `[[dbprefix]]tagmetas` (
  `tag` varchar(80) NOT NULL,
  `title` varchar(40) NOT NULL,
  `content` varchar(8000) NOT NULL,
  PRIMARY KEY (`tag`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tagwords`
--

CREATE TABLE `[[dbprefix]]tagwords` (
  `postid` int(10) unsigned NOT NULL,
  `wordid` int(10) unsigned NOT NULL,
  KEY `postid` (`postid`),
  KEY `wordid` (`wordid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]titlewords`
--

CREATE TABLE `[[dbprefix]]titlewords` (
  `postid` int(10) unsigned NOT NULL,
  `wordid` int(10) unsigned NOT NULL,
  KEY `postid` (`postid`),
  KEY `wordid` (`wordid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userevents`
--

CREATE TABLE `[[dbprefix]]userevents` (
  `userid` int(10) unsigned NOT NULL,
  `entitytype` char(1) CHARACTER SET ascii NOT NULL,
  `entityid` int(10) unsigned NOT NULL,
  `questionid` int(10) unsigned NOT NULL,
  `lastpostid` int(10) unsigned NOT NULL,
  `updatetype` char(1) CHARACTER SET ascii DEFAULT NULL,
  `lastuserid` int(10) unsigned DEFAULT NULL,
  `updated` datetime NOT NULL,
  KEY `userid` (`userid`,`updated`),
  KEY `questionid` (`questionid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userfavorites`
--

CREATE TABLE `[[dbprefix]]userfavorites` (
  `userid` int(10) unsigned NOT NULL,
  `entitytype` char(1) CHARACTER SET ascii NOT NULL,
  `entityid` int(10) unsigned NOT NULL,
  `nouserevents` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`userid`,`entitytype`,`entityid`),
  KEY `userid` (`userid`,`nouserevents`),
  KEY `entitytype` (`entitytype`,`entityid`,`nouserevents`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userfields`
--

CREATE TABLE `[[dbprefix]]userfields` (
  `fieldid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(40) NOT NULL,
  `content` varchar(40) DEFAULT NULL,
  `position` smallint(5) unsigned NOT NULL,
  `flags` tinyint(3) unsigned NOT NULL,
  `permit` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`fieldid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]userfields`
--

INSERT INTO `[[dbprefix]]userfields` VALUES
(1, 'name', NULL, 1, 0, 150),
(2, 'location', NULL, 2, 0, 150),
(3, 'website', NULL, 3, 2, 150),
(4, 'about', NULL, 4, 1, 150);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userlevels`
--

CREATE TABLE `[[dbprefix]]userlevels` (
  `userid` int(10) unsigned NOT NULL,
  `entitytype` char(1) CHARACTER SET ascii NOT NULL,
  `entityid` int(10) unsigned NOT NULL,
  `level` tinyint(3) unsigned DEFAULT NULL,
  UNIQUE KEY `userid` (`userid`,`entitytype`,`entityid`),
  KEY `entitytype` (`entitytype`,`entityid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userlimits`
--

CREATE TABLE `[[dbprefix]]userlimits` (
  `userid` int(10) unsigned NOT NULL,
  `action` char(1) CHARACTER SET ascii NOT NULL,
  `period` int(10) unsigned NOT NULL,
  `count` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `userid` (`userid`,`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userlogins`
--

CREATE TABLE `[[dbprefix]]userlogins` (
  `userid` int(10) unsigned NOT NULL,
  `source` varchar(16) CHARACTER SET ascii NOT NULL,
  `identifier` varbinary(1024) NOT NULL,
  `identifiermd5` binary(16) NOT NULL,
  KEY `source` (`source`,`identifiermd5`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usermetas`
--

CREATE TABLE `[[dbprefix]]usermetas` (
  `userid` int(10) unsigned NOT NULL,
  `title` varchar(40) NOT NULL,
  `content` varchar(8000) NOT NULL,
  PRIMARY KEY (`userid`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usernotices`
--

CREATE TABLE `[[dbprefix]]usernotices` (
  `noticeid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `content` varchar(12000) NOT NULL,
  `format` varchar(20) CHARACTER SET ascii NOT NULL,
  `tags` varchar(200) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`noticeid`),
  KEY `userid` (`userid`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userpoints`
--

CREATE TABLE `[[dbprefix]]userpoints` (
  `userid` int(10) unsigned NOT NULL,
  `points` int(11) NOT NULL DEFAULT '0',
  `qposts` mediumint(9) NOT NULL DEFAULT '0',
  `aposts` mediumint(9) NOT NULL DEFAULT '0',
  `cposts` mediumint(9) NOT NULL DEFAULT '0',
  `aselects` mediumint(9) NOT NULL DEFAULT '0',
  `aselecteds` mediumint(9) NOT NULL DEFAULT '0',
  `qupvotes` mediumint(9) NOT NULL DEFAULT '0',
  `qdownvotes` mediumint(9) NOT NULL DEFAULT '0',
  `aupvotes` mediumint(9) NOT NULL DEFAULT '0',
  `adownvotes` mediumint(9) NOT NULL DEFAULT '0',
  `cupvotes` mediumint(9) NOT NULL DEFAULT '0',
  `cdownvotes` mediumint(9) NOT NULL DEFAULT '0',
  `qvoteds` int(11) NOT NULL DEFAULT '0',
  `avoteds` int(11) NOT NULL DEFAULT '0',
  `cvoteds` int(11) NOT NULL DEFAULT '0',
  `upvoteds` int(11) NOT NULL DEFAULT '0',
  `downvoteds` int(11) NOT NULL DEFAULT '0',
  `bonus` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `points` (`points`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]userpoints`
--

INSERT INTO `[[dbprefix]]userpoints` VALUES
(1, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userprofile`
--

CREATE TABLE `[[dbprefix]]userprofile` (
  `userid` int(10) unsigned NOT NULL,
  `title` varchar(40) NOT NULL,
  `content` varchar(8000) NOT NULL,
  UNIQUE KEY `userid` (`userid`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `userid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `createip` varbinary(16) NOT NULL,
  `email` varchar(80) NOT NULL,
  `handle` varchar(20) NOT NULL,
  `avatarblobid` bigint(20) unsigned DEFAULT NULL,
  `avatarwidth` smallint(5) unsigned DEFAULT NULL,
  `avatarheight` smallint(5) unsigned DEFAULT NULL,
  `passsalt` binary(16) DEFAULT NULL,
  `passcheck` binary(20) DEFAULT NULL,
  `passhash` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `loggedin` datetime NOT NULL,
  `loginip` varbinary(16) NOT NULL,
  `written` datetime DEFAULT NULL,
  `writeip` varbinary(16) DEFAULT NULL,
  `emailcode` char(8) CHARACTER SET ascii NOT NULL DEFAULT '',
  `sessioncode` char(8) CHARACTER SET ascii NOT NULL DEFAULT '',
  `sessionsource` varchar(16) CHARACTER SET ascii DEFAULT '',
  `flags` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wallposts` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `email` (`email`),
  KEY `handle` (`handle`),
  KEY `level` (`level`),
  KEY `created` (`created`,`level`,`flags`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[regtime]]', UNHEX('[[longip]]'), '[[admin_email]]', '[[admin_username]]', NULL, NULL, NULL, NULL, '[[salt]]', '[[admin_pass]]', 120, '[[regtime]]', UNHEX('[[longip]]'), NULL, NULL, '', '[[sessioncode]]', NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]uservotes`
--

CREATE TABLE `[[dbprefix]]uservotes` (
  `postid` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `vote` tinyint(4) NOT NULL,
  `flag` tinyint(4) NOT NULL,
  `votecreated` datetime DEFAULT NULL,
  `voteupdated` datetime DEFAULT NULL,
  UNIQUE KEY `userid` (`userid`,`postid`),
  KEY `postid` (`postid`),
  KEY `voted` (`votecreated`,`voteupdated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]widgets`
--

CREATE TABLE `[[dbprefix]]widgets` (
  `widgetid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `place` char(2) CHARACTER SET ascii NOT NULL,
  `position` smallint(5) unsigned NOT NULL,
  `tags` varchar(800) CHARACTER SET ascii NOT NULL,
  `title` varchar(80) NOT NULL,
  PRIMARY KEY (`widgetid`),
  UNIQUE KEY `position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]words`
--

CREATE TABLE `[[dbprefix]]words` (
  `wordid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(80) NOT NULL,
  `titlecount` int(10) unsigned NOT NULL DEFAULT '0',
  `contentcount` int(10) unsigned NOT NULL DEFAULT '0',
  `tagwordcount` int(10) unsigned NOT NULL DEFAULT '0',
  `tagcount` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wordid`),
  KEY `word` (`word`),
  KEY `tagcount` (`tagcount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]categorymetas`
--
ALTER TABLE `[[dbprefix]]categorymetas`
  ADD CONSTRAINT `[[dbprefix]]categorymetas_ibfk_1` FOREIGN KEY (`categoryid`) REFERENCES `[[dbprefix]]categories` (`categoryid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]contentwords`
--
ALTER TABLE `[[dbprefix]]contentwords`
  ADD CONSTRAINT `[[dbprefix]]contentwords_ibfk_1` FOREIGN KEY (`postid`) REFERENCES `[[dbprefix]]posts` (`postid`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]contentwords_ibfk_2` FOREIGN KEY (`wordid`) REFERENCES `[[dbprefix]]words` (`wordid`);

--
-- Constraints for table `[[dbprefix]]messages`
--
ALTER TABLE `[[dbprefix]]messages`
  ADD CONSTRAINT `[[dbprefix]]messages_ibfk_1` FOREIGN KEY (`fromuserid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]messages_ibfk_2` FOREIGN KEY (`touserid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]postmetas`
--
ALTER TABLE `[[dbprefix]]postmetas`
  ADD CONSTRAINT `[[dbprefix]]postmetas_ibfk_1` FOREIGN KEY (`postid`) REFERENCES `[[dbprefix]]posts` (`postid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]posts`
--
ALTER TABLE `[[dbprefix]]posts`
  ADD CONSTRAINT `[[dbprefix]]posts_ibfk_2` FOREIGN KEY (`parentid`) REFERENCES `[[dbprefix]]posts` (`postid`),
  ADD CONSTRAINT `[[dbprefix]]posts_ibfk_3` FOREIGN KEY (`categoryid`) REFERENCES `[[dbprefix]]categories` (`categoryid`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]posts_ibfk_4` FOREIGN KEY (`closedbyid`) REFERENCES `[[dbprefix]]posts` (`postid`),
  ADD CONSTRAINT `[[dbprefix]]posts_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]posttags`
--
ALTER TABLE `[[dbprefix]]posttags`
  ADD CONSTRAINT `[[dbprefix]]posttags_ibfk_1` FOREIGN KEY (`postid`) REFERENCES `[[dbprefix]]posts` (`postid`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]posttags_ibfk_2` FOREIGN KEY (`wordid`) REFERENCES `[[dbprefix]]words` (`wordid`);

--
-- Constraints for table `[[dbprefix]]tagwords`
--
ALTER TABLE `[[dbprefix]]tagwords`
  ADD CONSTRAINT `[[dbprefix]]tagwords_ibfk_1` FOREIGN KEY (`postid`) REFERENCES `[[dbprefix]]posts` (`postid`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tagwords_ibfk_2` FOREIGN KEY (`wordid`) REFERENCES `[[dbprefix]]words` (`wordid`);

--
-- Constraints for table `[[dbprefix]]titlewords`
--
ALTER TABLE `[[dbprefix]]titlewords`
  ADD CONSTRAINT `[[dbprefix]]titlewords_ibfk_1` FOREIGN KEY (`postid`) REFERENCES `[[dbprefix]]posts` (`postid`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]titlewords_ibfk_2` FOREIGN KEY (`wordid`) REFERENCES `[[dbprefix]]words` (`wordid`);

--
-- Constraints for table `[[dbprefix]]userevents`
--
ALTER TABLE `[[dbprefix]]userevents`
  ADD CONSTRAINT `[[dbprefix]]userevents_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]userfavorites`
--
ALTER TABLE `[[dbprefix]]userfavorites`
  ADD CONSTRAINT `[[dbprefix]]userfavorites_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]userlevels`
--
ALTER TABLE `[[dbprefix]]userlevels`
  ADD CONSTRAINT `[[dbprefix]]userlevels_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]userlimits`
--
ALTER TABLE `[[dbprefix]]userlimits`
  ADD CONSTRAINT `[[dbprefix]]userlimits_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]userlogins`
--
ALTER TABLE `[[dbprefix]]userlogins`
  ADD CONSTRAINT `[[dbprefix]]userlogins_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]usermetas`
--
ALTER TABLE `[[dbprefix]]usermetas`
  ADD CONSTRAINT `[[dbprefix]]usermetas_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]usernotices`
--
ALTER TABLE `[[dbprefix]]usernotices`
  ADD CONSTRAINT `[[dbprefix]]usernotices_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]userprofile`
--
ALTER TABLE `[[dbprefix]]userprofile`
  ADD CONSTRAINT `[[dbprefix]]userprofile_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]uservotes`
--
ALTER TABLE `[[dbprefix]]uservotes`
  ADD CONSTRAINT `[[dbprefix]]uservotes_ibfk_1` FOREIGN KEY (`postid`) REFERENCES `[[dbprefix]]posts` (`postid`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]uservotes_ibfk_2` FOREIGN KEY (`userid`) REFERENCES `[[dbprefix]]users` (`userid`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
