<?php
/*
**  This is a template file for a subscriptions order page.
**
**
**  Customize it as you wish, then save the file as 'templates/subscriptions.php' !!
** 
**
** 	All subscription info is available in $subscriptions array;
** 	The current subscription is also placed in a $current_subscription array;
**	Posts with the name 'set_subscription' will change the subscription id of the user
**
*/

echo "<h2>". _SUBSCRIPTIONS ."</h2>";
echo "<p>"._YOU_HAVE.": <strong>". $current_subscription['Name'] ."</strong>.</p>";

echo "<div id='subscriptions-holder'>";
foreach ($subscriptions as $sub) {
	echo "<div class='subscription'>";
		echo "<h3>{$sub['Name']}</h3>";

		# Do we have a Description value set?		
		if(!empty($sub['Description'])){
			echo "<p class='description'>{$sub['Description']}</p>";
		}

		# Do we have a Price value set?
		if(!empty($sub['Display Price'])){
			echo "<p class='price'>&euro; {$sub['Display Price']} / ". _MONTH ."</p>";
		}

		# Change subcription
		if(!empty($current_subscription) && $current_subscription['Name'] == $sub['Name']){
			echo "<div class='commit-install block' style='text-align:center;padding:6px;'>";
				echo "<a href='#commit' style='display:inline;'>". _SUBSCRIBED ."</a>";
			echo "</div>";
		} else {
			echo "<form method='POST'><div class='commit-install'>";
				# Posts with the name set_subscription will change the subscription id of the user
				echo "<input type='hidden' name='set_subscription' value='{$sub['id']}' />";
				echo "<input type='submit' value='Subscribe' />";
			echo "</div></form>";
		}


		echo "<div class='report-list' style='clear:both;text-align:center;padding:4px;'>";
			echo "<a href='#commit'>Show / Hide Reports</a>";
		echo "</div>";
		echo "<ul class='subscription-reports report-list-hidden'>";
		if (isset($sub['reports'])) {
			foreach($sub['reports'] as $label){
				echo "<li>". constant($label) ."</li>";
			}
		}
		echo "</ul>";

	echo "</div>";
}
echo "</div>";
?>
<script type='text/javascript'>
$(".commit-install input[type='submit']").on("click", function(){
	if(confirm("<?php echo _CONFIRM_SUBSCRIPTION; ?>")){
		// Okay go ahead and post..
	} else {
		/// Stop the procces!
		return false;
	}
});

$(".report-list").on("click", function(){
	$(this).next("ul").toggleClass("report-list-hidden");
});
</script>