<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report lets you make split test of your pages and gives you an overview of wich one works the best.
*/

$reports["_ZENCART_TOP_PRODUCTS"] = Array(
	"ClassName" => "ZenCartTopProducts",
	"Category" => "_ZENCART",
	"icon" => "images/icons/32x32/zencart.png",
	"Options" => "daterangeField,displaymode,limit",
	"Filename" => "zencart_top_products",
	"Distribution" => "Premium",
	"Order" => 11,
	"ReportVersion" => 1.1,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class ZenCartTopProducts extends Report {
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "ID");
		$this->columnDefinitions[] = array("Label" => _PRODUCT);
		$this->columnDefinitions[] = array("Label" => _SALES);
		$this->columnDefinitions[] = array("Label" => _ORDERS,"bchart" => true);
		$this->columnDefinitions[] = array("Label" => _PAGEVIEWS);
		$this->columnDefinitions[] = array("Label" => _VIEWS_PER_SALE);

		if(empty($this->order_status)) { $this->order_status = 0; }
		if(empty($this->order_status_name)) { $this->order_status_name = _ALL_STATUSSES; }
		
		$this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.zenCartConnect", "");
	}
	
	function DefineQuery() {
		global $db;
		if ($this->order_status != '0') {
			$sql = " AND o.orders_status = ". $db->Quote($this->order_status);
		} else {
			$sql = "";
		}
		
		if (!empty($this->from)) {
			$sql .= " AND DATE(o.date_purchased) >= '" . date('Y-m-d', $this->from) . "'";
		}

		if (!empty($this->to)) {
			$sql .= " AND DATE(o.date_purchased) <= '" . date('Y-m-d', $this->to) . "'";
		}
		
		$query = "SELECT op.products_id,op.`products_name`,  
				FORMAT(SUM((SELECT value FROM {$this->tableprefix}orders_total WHERE o.orders_id = orders_id AND class = 'ot_subtotal')),2) AS turnover,
				SUM(op.products_quantity) AS sold, 
				SUM(pd.products_viewed) AS views, 
				(SUM(pd.products_viewed) / SUM(op.products_quantity)) AS views_per_sale,
				o.currency as curr
			FROM
				{$this->tableprefix}products_description AS pd, {$this->tableprefix}orders_products AS op, `{$this->tableprefix}orders` AS o, `{$this->tableprefix}orders_status` AS os
			WHERE
				pd.products_id = op.products_id AND op.orders_id = o.orders_id AND o.orders_status = os.orders_status_id {$sql}
			GROUP BY op.products_id
			ORDER BY sold DESC
			LIMIT {$this->limit};";
		
		return $query;
	}
	
	function GetReportData() {
		$connection = $this->checkExternalConnection("zenCartConnect");
		if($connection == false){ echoNotice($this->SettingsButton()._CONNECTION_TO_DATABASE_FAILED); exit();  }
		$query = $this->DefineQuery();
		
		$result = mysql_query($query,$connection);
		$currency  = "";
		$data = array();
		while($row = mysql_fetch_array($result)) {
			$currency = $row["curr"];
			$data[] = $row;
		}
		
		$this->addlabel .= _ORDER_STATUS.": {$this->order_status_name}";
		$this->addlabel .= " | Currency: {$currency}";
		
		
		return $data;
	}
	
	function DisplayCustomForm() {
		global $session;
		$connection = $this->checkExternalConnection("zenCartConnect");

		echo "<div class='form-group'>";

		if($connection != false){
			$query = "SELECT DISTINCT(orders_status_id) AS status_id, `orders_status_name` AS status_name FROM `{$this->tableprefix}orders_status` ORDER BY `orders_status_name` ASC";
			
			$result = mysql_query($query, $connection);
			
			echo "<label for='order_status'>"._ORDER_STATUS."</label>";
			echo "<input type='hidden' id='order_status_name' name='order_status_name' value='{$this->order_status_name}'>";
			
			echo "<select id='order_status' name='order_status' class='form-control'>";
				echo "<option value='0'>"._ALL_STATUSSES."</option>";
			while($row = mysql_fetch_assoc($result)) {
				if($row['status_id'] == $this->order_status) {
					$selected = ' selected ';
				} else {
					$selected = '';
				}
				echo "<option {$selected} value='{$row['status_id']}'>{$row['status_name']}</option>";
			}
			echo "</select>";
			
			echo "<script type='text/javascript'>";
				echo "$('#order_status').change(function() {
					$('#order_status_name').attr('value', $(this).find('option[value=\"' + $(this).val() + '\"]').html());
				});";
			echo "</script>";
		}
		
		if($session->canEditProfiles()) {			
			echo "<a data-title='"._VIEW_ZENCART_CONF."'' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels=_ZENCART_TOP_PRODUCTS&action=welcome' class='optionlink open_iframe_window'>". _VIEW_ZENCART_CONF ."</a>";
		}
		echo "</div>";
	}
	
	function DefineReport() {
		$this->externDbConnectForm("zenCartConnect");
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}