<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays a overview of your top keywords
*/
$reports["_VISITOR_INFOGRAPHIC"] = Array(
	"ClassName" => "VisitorInfographic", 
	"Category" => "_INFOGRAPHICS", 
	"icon" => "images/icons/32x32/trendsoverview.png",
	"Options" => "daterangeField,profileselector",
	"Filename" => "visitor_infographic",
	"Distribution" => "Standard",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"hidden" => true,
	"EmailAlerts" => false,
	"Update" => false
);

class VisitorInfographic extends Report {
	var $ndays;
	
	function UpdateStats($from = '', $to = '',$print = 2) {
  		return false;
 	}

	function Settings(){
		$reports;

		if(date("ymd",time()) == date("ymd",$this->to)){
			$this->to = $this->to - 86400;
		}
	
		$this->from = mktime(0,0,0,date("m",$this->to),date("d",$this->to)-6,date("Y",$this->to));
		$this->limit = 10;
		
		$calc = round(($this->to - $this->from) / 86400);
		$this->ndays = $calc;
	}
	
	function DisplayReport() {
		global $reports;
		$this->ReportHeader();

		$required_reports = array(
			"_TREND_ANALYSIS",
			"_TOTAL_DURATION",
			"_VISIT_DURATION",
			"_TOP_COUNTRIES_CITIES",
			"_VISITORS_PER_DAY",
			"_NEW_VS_RETURNING"
		);

		$missing = "";
		foreach($required_reports as $c) {
			if(empty($reports[$c])){
				$missing .= "- ". constant($c) ." -";
			}
		}
		if(!empty($missing) && CheckForSubscriptionsUsage()){
			echoNotice(_MISSING_TO_SEE_COMPLETE_REPORT. ":<br/>$missing<br/><a class='subscription_report' style='cursor:pointer;'>"._OPEN_SUBSCRIPTION_DIALOG."</a>","margin:10px; text-align:center;");
		}
		
		$averages = $this->AvgVisitorsBlockData();		
		$data = array();
			
		if(empty($reports["_TREND_ANALYSIS"])){
			$trenddata = array();
		} else {
			$ta = new $reports["_TREND_ANALYSIS"]["ClassName"]();
			$ta->label = _TREND_ANALYSIS;
			$ta->sourcetype = "page";
			$ta->from = $this->from;
			$ta->to = $this->to;
			$trenddata = $ta->GetReportData();		
			$trenddata = $ta->ConvertData($trenddata);
		}

		# Total Duration
		if(!empty($reports["_TOTAL_DURATION"])){
			$td = new $reports["_TOTAL_DURATION"]["ClassName"]();
			$td->label = _TOTAL_DURATION;
			$td->displaymode = "pie";
			$td->from = $this->from;
			$td->to = $this->to;	
			$totdur = $td->GetReportData();
			$td->legendlabelstring = "'<span style=\"float:left;\">%t</span> <span style=\"float:right;\">  %v </span>'"; 
			$td->legendstyle['container'] = "width: 95%; float: left; margin: 15px 0px 0px 0px;";
			$td->legendstyle['legend'] = "width: 100%; display: block; clear: both;"; 
		}
		
		# Visit Duration
		if(!empty($reports["_VISIT_DURATION"])){
			$vd = new $reports["_VISIT_DURATION"]["ClassName"]();
			$vd->label = _VISIT_DURATION;
			$vd->displaymode = "pie";
			$vd->from = $this->from;
			$vd->to = $this->to;	
			$visitdur = $vd->GetReportData();
			$vd->legendlabelstring = "'<span style=\"float:left;\">%t</span> <span style=\"float:right;\">  %v </span>'";
			$vd->legendstyle['container'] = "width: 95%; float: left; margin: 15px 0px 0px 0px;";
			$vd->legendstyle['legend'] = "width: 100%; display: block; clear: both;"; 
		}

		# Visit Duration
		if(empty($reports["_TOP_COUNTRIES_CITIES"])){
			$countrylist = array();
		} else {
			$map = new $reports["_TOP_COUNTRIES_CITIES"]["ClassName"]();
			$map->label = _TOP_COUNTRIES_CITIES;
			$map->from = $this->from;
			$map->limit = 100;	
			$map->to = $this->to;	
			$mapdata = $map->GetReportData();
			foreach($mapdata as $k => $v){
				$mapdata[$k][3] = number_format(($mapdata[$k][2] / $mapdata[$k][1]),2); 
			}
			$countrylist = $this->CountryListData($mapdata,8);
		}
		?>
		<div class="infograph-wrapper visitor-infograph-wrapper">
			<div class="infograph-row">
				<div class="visitor-block">				
					<div class="average-visitors">
						<h1><?php echo $averages["vpd"]; ?></h1>
						<p><?php echo _AVG_VISITORS; ?><br><?php echo _PER_DAY; ?></p>
					</div>
					<div class="returning-new">				
						<div class="rotated">
							<span><strong><?php echo $averages["returning"]; ?>%</strong> <?php echo _RETURNING; ?><br><strong><?php echo $averages["new"]; ?>%</strong> <?php echo _NEW; ?></span>
						</div>						
					</div>
					<div style="clear:both;"></div>
					<div class="average-visitors-trend">
						<h1><font color="<?php echo $averages["trend"]["color"]; ?>"><?php echo "{$averages["trend"]["data"]}"; ?></font></h1>
						<p>
							<?php echo _COMPARED_TO_LAST_WEEK; ?>
						</p>
					</div>
					<div class="returning-new">				
						<div class="">
							<span>
								<?php echo $averages["trendsmile"]; ?>
								<?php echo $averages["trendarrow"]; ?>
							</span>
						</div>
					</div>
				</div>
				<div class="trend-block">
					<h1><?php echo _VISITOR_TREND; ?></h1>
					<div class="infograph-graph">
						<?php if(!empty($ta)){
							$ta->MultiChart($trenddata);
						} ?>
					</div>
				</div>
			</div>
			<div class="infograph-row">
				<div class="visitor-block2">
					<h1><?php echo _AVERAGE_OVER_SEVEN_DAYS; ?> (<?php echo _COMPARED_TO_LAST_WEEK; ?>)</h1>
					<table>
						<tr>
							<td><img src="images/infographics/page_icon.png" class="infograph-icon"></td>
							<td><?php echo _VISITS_PER_UNIQUE; ?>: </td>
							<td style="padding:0 10px;"><?php echo $averages["visitspervisitor"]["now"]; ?></td>
							<td style="padding:0 10px;"><font color="<?php echo $averages["visitspervisitor"]["color"]; ?>">
								<?php echo "(". round($averages["visitspervisitor"]["now"] - $averages["visitspervisitor"]["prev"]) .")"; ?>
							</font></td>
						</tr>
						<tr>
							<td><img src="images/infographics/people_icon.png" class="infograph-icon"></td>
							<td><?php echo _VISITS_PER_UNIQUE; ?>: </td>
							<td style="padding:0 10px;"><?php echo $averages["pageviewspervisitors"]["now"]; ?></td>
							<td style="padding:0 10px;"><font color="<?php echo $averages["pageviewspervisitors"]["color"]; ?>">
								<?php echo "(". round($averages["pageviewspervisitors"]["now"] - $averages["pageviewspervisitors"]["prev"]) .")"; ?>
							</font></td>
						</tr>	
					</table>
				</div>
			</div>
			<div class="infograph-row">
				<div class="divider">
					<div class="divider1"></div>
					<div class="divider2"><h1><?php echo _COUNTRIES; ?></h1></div>
					<div class="divider3"></div>
				</div>
			</div>
			<div class="infograph-row">
				<div class="countries">
					<div class="countries-left">
						<div class="infograph-map"><?php if(!empty($map)){ $map->WorldMap($mapdata,251,"#FFFFFF"); } ?></div>
					</div>
					<div class="countries-right">
						<table>
							<tr>
								<td><?php echo _COUNTRY; ?></td>
								<td><?php echo _AVERAGE_VISITS; ?></td>
							</tr>
							<?php
							foreach($countrylist as $c){
								echo "<tr><td class='country-name'>{$c[0]}</td><td class='country-value'>{$c[1]}</td></tr>";
							}
							?>
						</table>
					</div>
				</div>
			</div>
			<div class="infograph-row">
				<div class="divider">
					<div class="divider1"></div>
					<div class="divider2"><h1><?php echo _TIME_ON_SITE; ?></h1></div>
					<div class="divider3"></div>
				</div>
			</div>
			<div class="infograph-row">
				<div class="duration">
					<div class="visit-duration">
						<h2><?php echo _VISIT_DURATION; ?></h2>
						<div class="infograph-pie"><?php if(!empty($vd)){ $vd->pieChart($visitdur,"south"); } ?></div>
					</div>
					<div class="total-duration">
						<h2><?php echo _TOTAL_DURATION; ?></h2>
						<div class="infograph-pie"><?php 
							if(!empty($reports["_TOTAL_DURATION"])){
								$td->pieChart($totdur,"south"); 
							} else if (CheckForSubscriptionsUsage()) {
								# Report is not in this subscription
							} else if (LOGAHOLIC_BASE_EDITION == "cPanel Edition") {
								echoNotice("The "._TOTAL_DURATION." report is not available in your <a target=_blank href='http://www.logaholic.com/'>Logaholic</a> version. Visit <a target=_blank href='http://www.logaholic.com/'>www.logaholic.com</a> to check out our full featured editions!","position:absolute; width:240px;margin-top: 70px;margin-left: 50px;border: 1px solid #0078AE;");
								echo "<img style='margin-left: -40px;' src='images/infographics/totalduration_info_buy.png' />";
							} else {
								echoNotice("The "._TOTAL_DURATION." report is not available in your <a target=_blank href='http://www.logaholic.com/'>Logaholic</a> yet. Visit <a target=_blank href='http://store.logaholic.com/'>store.logaholic.com</a> to get it!","position:absolute; width:240px;margin-top: 70px;margin-left: 50px;border: 1px solid #0078AE;");
								echo "<img style='margin-left: -40px;' src='images/infographics/totalduration_info_buy.png' />";
							}
						?></div>
					</div>
				</div>
				<div style="clear:both;"></div>
			</div>
		</div>
		<?php
	}
	
	function CountryListData($mapdata,$countryLimit = 5){
		global $cnames;
		# Top 5 countrys
		$i = 0;
		$countrys = array();
		foreach($mapdata as $key => $row) {
			if($i >= $countryLimit){
				break;
			}
			$countryname = @$cnames[$row[0]];
			$ccode = strtolower($row[0]);
			$image= "<img hspace=3 width=14  height=11 src=\"images/flags/{$ccode}.png\" border=0 alt=\"{$ccode}\">";
			$countrys[$key][0] = $image." ".$countryname;
			$countrys[$key][1] = $row[1];
			$countrys[$key][2] = $row[2];
			$countrys[$key][3] = $row[3];
			$i ++;
		}
	
		return $countrys;
	}
	
	function AvgVisitorsBlockData(){
		global $reports;
		$returndata = array();
		
		# Average Visitors Per Day
		if(empty($reports["_VISITORS_PER_DAY"])){
			# report not found..
			$data = array();
		} else {
			$vpd = new $reports["_VISITORS_PER_DAY"]["ClassName"]();
			$vpd->label = _VISITORS_PER_DAY;
			$vpd->from = $this->from - (86400 * 7);
			$vpd->period = "days";
			$vpd->to = $this->to;	
			$data = $vpd->GetReportData();
		}

		$pageviews = 0;
		$prepageviews = 0;
		$visits = 0;
		$previsits = 0;
		$visitors = 0;
		$previsitors = 0;
		$i = 0;
		
		$ppu = 0;
		$prevppu = 0;
		
		foreach($data as $set){
			if($i < 7){
				$previsitors = $previsitors + $set[1];
				$prepageviews = $prepageviews + $set[2];
				$prevppu = $prevppu + $set[3];
				$previsits = $previsits + $set[4];
			} else {
				$visitors = $visitors + $set[1];
				$pageviews = $pageviews + $set[2];
				$ppu = $ppu + $set[3];
				$visits = $visits + $set[4];
			}
			$i ++;
		}
		
		$days = $this->ndays;
		$diff = round( ($visitors/$days) - ($previsitors/$days) );
		$returndata["trend"]["color"] = ($diff < 0) ? "red" : "green";
		$returndata["trend"]["data"] = $diff;
		
		if($returndata["trend"]["color"] == "red"){
			$returndata["trendarrow"] = "<img src='images/infographics/arrow_red.png' class='infograph-arrow' />";
			$returndata["trendsmile"] = "<img class='infograph-smiley' src='images/icons/smilleys/smilley_39.png' />";
		} else {
			$returndata["trendarrow"] = "<img src='images/infographics/arrow_green.png' class='infograph-arrow' />";
			$returndata["trendsmile"] = "<img class='infograph-smiley' src='images/icons/smilleys/smilley_01.png' />";
		}
		
		$returndata["vpd"] = round($visitors / $this->ndays);
		$returndata["visitspervisitor"]["prev"] =($previsitors == 0)?  0 : number_format(($previsits / $previsitors),2);
		$returndata["visitspervisitor"]["now"] = ($visitors == 0)?  0 : number_format(($visits / $visitors),2);
		$returndata["visitspervisitor"]["color"] = (($returndata["visitspervisitor"]["now"] - $returndata["visitspervisitor"]["prev"] ) < 0) ? "red" : "green";
		
		$ppu = number_format($ppu / $days,2);
		$prevppu = number_format($prevppu / $days,2);
		
		$returndata["pageviewspervisitors"]["prev"] = $prevppu;
		$returndata["pageviewspervisitors"]["now"] = $ppu;
		$returndata["pageviewspervisitors"]["color"] = (($returndata["pageviewspervisitors"]["now"] - $returndata["pageviewspervisitors"]["prev"]) < 0) ? "red" : "green";
		
		# New VS Returning
		if(empty($reports["_NEW_VS_RETURNING"])){
			# report not found..
			$data = array();
		} else {
			$newret = New $reports["_NEW_VS_RETURNING"]["ClassName"]();
			$newret->label = _NEW_VS_RETURNING;
			$newret->from = $this->from;
			$newret->period = "days";
			$newret->to = $this->to;	
			$data = $newret->GetReportData();
		}
		$ret = 0;
		foreach($data as $set){
			# Returning
			$r = str_replace("%","",$set[2]);
			$ret = $ret + $r;
		}
		
		$returndata["returning"] = round($ret / $this->ndays);
		$returndata["new"] = 100 - $returndata["returning"];
		return $returndata;
	}
}
?>