<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 

$reports["_TOTAL_DURATION_PER_DAY"] = Array(
	"ClassName" => "TotalDurationPerDay", 
	"Category" => "_VISITOR_TRENDS", 
	"icon" => "images/icons/32x32/totalduration.png",
	"Options" => "daterangeField,profileselector,human",
	"Filename" => "total_duration_per_day",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"canAggregate" => false
);

class TotalDurationPerDay extends Report {

	function Settings() {

		if(empty($this->displaySetting)){
			$this->displaySetting = "chart";
		}

		//define output modes that are not available
		if($this->displaySetting == "chart" ){
			$this->remove_outputmodes = array("xml","csv","mail");
		}
		
		# Always set date
		if($this->displaySetting == "chart" ){
			$this->columnDefinitions[] = array("Label" => "_DATE");
			$this->columnDefinitions[] = array("Label" => "_TIME_SPENT");
			$this->columnDefinitions[] = array("Label" => "_VISITORS");
			$this->columnDefinitions[] = array("Label" => "_AVERAGE_DURATION_IN_MINUTES");
			$this->columnDefinitions[] = array("Label" => "_VISIT_SHARE");			
			$this->addlabel .= "- " . _GROUPED_PER_DAY;
		} else {
			$this->columnDefinitions[] = array("Label" => "_DATE");
			$this->columnDefinitions[] = array("Label" => "_WEIGHTED_AVG");
			$this->addlabel .= "- " . _WEIGHTED_AVG_PER_DAY;
		}
		$this->chartoptions = array("stacked_graph_style" => "expand", "stacked_showcontrols" => true, "showlegend" => true);
	}

	function DisplayCustomForm(){
		echo "<div class='form-group'><label>&nbsp;</label>";

			echo "<select id='displaySetting' name='displaySetting' class='report_option_field form-control'>";
				if( $this->displaySetting == "chart"){ $sel = "selected='selected'"; } else { $sel = ''; }
				echo "<option $sel value='chart'>";
					echo _DISPAY_TIME_GROUPS_PER_DAY;
				echo "</option>";

				if($this->displaySetting == "table"){ $sel = "selected='selected'"; } else { $sel = ''; }
				echo "<option $sel value='table'>";
					echo _DISPAY_AVG_TIME_PER_DAY;
				echo "</option>";
			echo "</select>";
		echo "</div>";
	}

	function GetReportData() {
		if($this->displaySetting == "chart" ){
			return $this->TotalStackedData();
		} else {
			return $this->TotalTableAvgData();
		}
	}

	function DisplayReport(){
		$data = $this->GetReportData();	

		if($this->displaySetting == "chart" ){
			$this->reportHeader();
			$this->StackedAreaChart($data , 1 , 0 , 1);
		} else {	
			$this->Table($data);
		}
	}

	function TotalStackedData(){
		$report = new TotalDuration();
		$report->createDataFiles($this->from,$this->to);
		$data = $report->getTrendDataFromFiles($report->dataFiles($this->from,$this->to));
		//dump($data);

		$conv = array();
		# the key info is a label so change that to the normal value
		foreach ($data as $date => $rows) {
			$stamp = mktime(12,0,0,substr($date,4,-2),substr($date,6,7),substr($date,0,4));
			

			if(!empty($this->outputmode) && $this->outputmode == "csv"){
				$date = trim( date(implode($this->profile->dateFormat),$stamp) );
			} else {
				$date = date("d F Y", $stamp); 
			}

			$conv[$date] = $rows;
			foreach ($rows as $k => $v) {
				$conv[$date][$k][0] = constant(trim($v[0]));
				$conv[$date][$k][4] = $conv[$date][$k][4] - 1; # minus 1 because the sorting starts at 1...
			}
		}

		//dump($conv);
		return $conv;
	}

	function TotalTableAvgData(){
		$report = new TotalDuration();
		$report->createDataFiles($this->from,$this->to);
		$data = $report->getTrendDataFromFiles($report->dataFiles($this->from,$this->to));
		
		$result = array();

		$i = 0;
		# the key info is a label so change that to the normal value
		foreach ($data as $date => $rows) {
			$stamp = mktime(12,0,0,substr($date,4,-2),substr($date,6,7),substr($date,0,4));
			$date = trim( date(implode($this->profile->dateFormat),$stamp) );

			
			$total_visitors = 0;
			$weight = 0;

			foreach ($rows as $k => $v) {
				# avg dur per min
				$avg  = ($v[1] == 0) ? 0 : ($v[2] / $v[1]) / 60;
				
				$weight += number_format( ($avg * $v[1]) , 2 );
				$total_visitors += $v[1];
			}

			if($total_visitors > 0){
				$weighted_avg = number_format( ($weight / $total_visitors) , 2 );
			} else{
				$weighted_avg = 0;
			}

			$result[$i][0] = $date;
			$result[$i][1] = $weighted_avg;
			
			$i++;
		}

		return $result;
	}
}
?>
