<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the most active crawlers
*/
$reports["_MOST_ACTIVE_CRAWLERS"] = Array(
	"ClassName" => "MostActiveCrawlers", 
	"Category" => "_TRAFFIC", 
	"icon" => "images/icons/32x32/mostactivecrawlers.png",
	"Options" => "daterangeField,profileselector,displaymode,search,limit,columnSelector",
	"Filename" => "most_active_crawlers",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class MostActiveCrawlers extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => _USER_AGENT);
		$this->columnDefinitions[] = array("Label" => _REQUESTS);
		$this->columnDefinitions[] = array("Label" => _COUNTRY);
		$this->columnDefinitions[] = array("Label" => _MEGABYTES);
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._USER_AGENT_DEFINITION.'<li>'._REQUESTS_BOTS_DEFINITION.'<li>'._COUNTRY_DEFINITION.'<li>'._MEGABYTES_DEFINITION.'</ul><div class=\'indentbody\'>'._CRAWLERS_EXPLANATION.'</div>';
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;
	}
	
	function DefineQuery() {	
		global $db;
		
		$query = "SELECT ua.name AS useragent, count(*) AS hits, a.country, (sum(a.bytes * 1.00) / 1024.0) / 1024.0 AS mb FROM {$this->profile->tablename_crawl} AS a INNER JOIN {$this->profile->tablename_useragents} as ua ON a.useragentid = ua.id WHERE a.timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND a.crawl=1 GROUP BY ua.name ORDER BY hits DESC";	
		//echoNotice($query);
		return $query;
	}
}
?>
