<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the used os versions
*/
$reports["_MOBILE_OS_VERSIONS"] = Array(
	"ClassName" => "MobileOSVersions", 
	"Category" => "_CLIENT_SYSTEM", 
	"icon" => "images/icons/32x32/os_versions.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
	"Filename" => "mobile_os_versions",
	"Distribution" => "Premium",
	"Order" => 10,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class MobileOSVersions extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		
		$this->columnDefinitions[] = array("Label" => "_OPERATING_SYSTEM");
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
	}
	
	function DefineQuery() {
		global $db;
		$query = "SELECT IF(ua.os_version='','Unknown',ua.os_version) AS os_name, COUNT(DISTINCT a.sessionid) AS visits, COUNT(DISTINCT a.visitorid) AS visitors, ua.os FROM {$this->profile->tablename} AS a, {$this->profile->tablename_useragents} as ua WHERE a.useragentid = ua.id AND  a.timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND ua.is_mobile = 1 GROUP BY os_version ";
		$query .= "ORDER BY visits DESC";
		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
