<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
 
$reports["_INTERCOM_CONVERSATIONS"] = Array(
 	
  "ClassName" => "IntercomConversations", 
  "Category" => "_INTERCOM", 
  "Options" => "daterangeField,displaymode",
  "Distribution" => "Premium",
  "EmailAlerts" => false,
  "Update" => false,
  "Filename" => "intercom_conversations"
 
); 

 
class IntercomConversations extends Report {

    function Settings() {
        $this->DisplayModes = "table,barchart,linechart";
        $this->DefaultDisplay = "linechart";
        $this->columnDefinitions[] = array("Label" => "_DATE");
        $this->columnDefinitions[] = array("Label" => "Conversations");
        $this->help = "This will show the new conversations per day for intercom.";
        $old_api_id = $this->profile->GetOtherSettings("IntercomApiId", "");
        $old_api_key = $this->profile->GetOtherSettings("IntercomApiKey", "");
        if(isset($this->ApiKey) && $this->ApiKey != $old_api_key) {
           $this->profile->SetOtherSettings("IntercomApiKey", $this->ApiKey);
        } else {
            $this->ApiKey = $old_api_key;
            
        }
        if(isset($this->ApiID) && $this->ApiID != $old_api_id){
            $this->profile->SetOtherSettings("IntercomApiId", $this->ApiID);
        } else {
            $this->ApiID = $old_api_id;
        }

    }
    function curl_download($Url){
 
    // OK cool - then let's create a new cURL resource handle
    $ch = curl_init();
 
    // Now set some options (most are optional)
 
    // Set URL to download
    curl_setopt($ch, CURLOPT_URL, $Url);
 

    curl_setopt($ch, CURLOPT_USERPWD, $this->ApiID . ":" . $this->ApiKey);
    // Include header in result? (0 = yes, 1 = no)
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        ));
 
    // Should cURL return or print out the data? (true = return, false = print)
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
 
    // Timeout in seconds
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
 
    // Download the given URL, and return output_add_rewrite_var(name, value)
    $output = curl_exec($ch);
 
    // Close the cURL resource, and free system resources
    curl_close($ch);


    return($output);

    }   
    function DisplayCustomForm(){
        $form = "<div class='form-group'>" .
                "<label for='author'>API Key:</label>
                <input type='text' name='ApiKey'
                value='".@$this->ApiKey."' class='report_option_field form-control' /> " .
                "</div>" .
                "<div class='form-group'>" .
                "<label for='author'>API ID:</label>
                <input type='text' name='ApiID'
                value='".@$this->ApiID."' class='report_option_field form-control' />" .
                "</div>"; 
                 
        return $form;
    } 
    function GetReportData(){
        

        $r = $this->curl_download("https://api.intercom.io/conversations");
        $data = json_decode($r, true);


        if($data['type'] == 'error.list'){
            foreach($data['errors'] as $k => $v) {
                echoWarning("Intercom Error ({$v['code']}) : {$v['message']}");
            }
            return array();
        }

        if(empty($data)){
            return array();
        }

        $import = array();

        foreach($data['conversations'] as $key => $user) {
            $ts = date('Y-m-d', $user['created_at']);
            if(empty($import[$ts])){
                $import[$ts] = 1;
            }
            else{
                $import[$ts] ++;
            }
        }

        $totalpages = $data['pages']['total_pages'];
        if($totalpages > 1){
            for ($i=2; $i <= $totalpages; $i++) { 
                $r = $this->curl_download("https://api.intercom.io/conversations?page=$i");
                $data = json_decode($r, true);

                foreach($data['conversations'] as $key => $user) {
                    $ts = date('Y-m-d', $user['created_at']);
                    if(empty($import[$ts])){
                        $import[$ts] = 1;
                    }
                    else{
                        $import[$ts] ++;
                    }
                }
            }
        }

        ksort($import);

        $firsttime = (key($import));
        end($import);
        $lasttime = (key($import));

        $firsttime = explode('-', $firsttime);
        $firsttime = mktime(0, 0, 0, $firsttime[1], $firsttime[2], $firsttime[0]);

        $lasttime = explode('-', $lasttime);
        $lasttime = mktime(0, 0, 0, $lasttime[1], $lasttime[2], $lasttime[0]); 

        $time = $firsttime;

        while($time < $lasttime){
            $cdate =  date('Y-m-d', $time);
            if(empty($import[$cdate])) {
                $import[$cdate] = 0;
            }
            $time = mktime(0, 0, 0, date("m", $time), date("d", $time)+1, date("Y", $time));

        }
        
        $data = array();
        ksort($import);
        $i = 0;

        foreach($import as $date => $users){
            $date = explode('-', $date);
            $date = mktime(0, 0, 0, $date[1], $date[2], $date[0]);  
            $data[$i][0] = date(implode($this->profile->dateFormat), $date);
            $data[$i][1] = $users;
            $i++;
        }
        return $data;
        
    }  
    function DisplayReport(){
        // is cURL installed yet?
        if (!function_exists('curl_init')){
            echoWarning('Sorry cURL is not installed!');
            return false;
        }

        if (empty($this->ApiID) || empty($this->ApiKey)) {
            echoNotice($this->SettingsButton(). "The ID field or the Key field is empty. <br><br> for more information: check <a href='https://developers.intercom.io/page/getting-started' target='_blank'>the documentation</a>. ");
            return false;
        }else{
                parent::DisplayReport();
        }    
    }    
}
?>