<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the spoken languages of your facebook friends
*/

$reports["_FACEBOOK_LANGUAGE"] = Array(
    "ClassName" => "FacebookPageLanguage", 
    "Category" => "_FACEBOOK", 
    "icon" => "images/icons/32x32/fb_language.png",
	"Options" => "daterangeField,displaymode,limit",
	"Filename" => "facebook_page_language",
	"Distribution" => "Premium",
	"Order" => 17,
	"ReportVersion" => 4.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
);

class FacebookPageLanguage extends FacebookCore {
	
	function Settings() {
		parent::Settings();
		$this->DisplayModes = "pie,areachart";
		$this->DefaultDisplay = "areachart";
		if(empty($this->displaymode)){
			$this->displaymode = $this->DefaultDisplay;
		}
		$this->addlabel = _FACEBOOK_LANGUAGE_ADDLABEL;
		$this->help = _FACEBOOK_LANGUAGE_HELP;
		$this->metric = "lang";
	}	
    
	function DisplayPie(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data.values === undefined){
				console.log("No data");
				return;
			}			

			var graph_data = [];

			var lnames = <?php echo json_encode(LanguageNames()); ?>;			
			
			var max = data.values.length - 1;
			data = data.values[max].value;

			var i = 0;
			$.each(data, function(k,v){
				k = k.replace("_","-");

				if(!lnames[k]){
					var name = k;
				} else {
					var name = lnames[k];
				}
				
				graph_data[i] = [name,v];
				i++;
			});
			$("#"+container_id).attr("data", JSON.stringify(graph_data) );

			lg.Pie(container_id);
		}
		</script><?php
	}

	function DisplayGraph(){
		global $cnames;
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id, result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			
			var data = result.data;
			if(!data || data.values === undefined){
				console.log("No data");
				return;
			}	

			var limit = <?php echo $this->limit; ?>;
			var lnames = <?php echo json_encode(LanguageNames()); ?>;	

			var dataSet = {};
			var graph_data = [];
			var columns = [];
			var totalColumns = 0;
			var columnsCheck = {};
			var xticks = [];

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];

				xticks.push(d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time)));

				var ii = 0;

				$.each(row.value, function(a,b){
					if(ii >= limit){
						return;
					}
					ii ++;

					a = a.replace("_","-");

					if(!lnames[a]){
						var name = a;
					} else {
						var name = lnames[a];
					}

					if(dataSet[name] == undefined){
						dataSet[name] = {
							key : name,
							values : []
						}
						columns.push({ "Label" : name });
					}			

					dataSet[name].values.push( [i , parseInt(b)] );

					columnsCheck[i] = 0;

					if(totalColumns < dataSet[name].values.length){
						totalColumns = dataSet[name].values.length;
					}			
				});

			}

			function LookForDate(date , values){
				var c = false;
				$.each(values, function(k,v){
					if(parseInt(v[0]) == parseInt(date) ){
						c = v[1];
						return;
					}
				});
				return c;
			}

			$.each(dataSet, function(k,v){
				// we are missing columns for this record
				if(v.values.length < totalColumns){
					// lets check all the columns
					var n = [];
					$.each(columnsCheck, function(a,b){
						var c = LookForDate(a, v.values);
						if(c === false){
							n.push([parseInt(a), 0]);
						} else {
							n.push([parseInt(a), c]);
						}
					});
					v.values = n;
				}
				graph_data.push(v);
			});

			$("#"+container_id).attr("data-ticks", JSON.stringify(xticks));
			$("#"+container_id).attr("data-coldefs", JSON.stringify(columns));
			
			$("#"+container_id).attr("data-chartoptions", JSON.stringify({
				"stacked_graph_style" : "stream", "stacked_showcontrols" : true, "showlegend" : false
			}));

			$("#"+container_id).attr("data-chart", JSON.stringify(graph_data) );

			lg.StackedAreaChart(container_id);
		}
		</script><?php
	}
}
?>