<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the error report
*/
$reports["_EXIT_RATE"] = Array(
	"ClassName" => "ExitRate", 
	"Category" => "_PROBLEMS", 
	"icon" => "images/icons/32x32/bouncerate.png",
	"Options" => "daterangeField,profileselector,displaymode",
	"Filename" => "exit_rate",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.1,
	"EmailAlerts" => true,
	"Update" => false,
	"canAggregate" => false
);

class ExitRate extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array( "Label" => _DESCRIPTION);		
		$this->columnDefinitions[] = array( "Label" => "_AVERAGE_PER_DAY");		
		
		$this->help = _EXIT_RATE_DESC;
		$this->dataCollectType = "days";
		$this->displayTotalRow = false;
		$this->sparktype = 'pie';
		
		if(!empty($this->page)){
			$this->addlabel = "<span class='hidden-xs'>". _PAGE .": </span>". $this->page;
			$this->fileNameExpension = ".".urlencode($this->page);
		}
		if(empty($this->page)){
			$this->page="/";
		}
	}
	
	function GetDataFromDb() {
		global $db;
		$data = array();
		
		//zero fill the array
		$data[0][0] = "Visitors that stayed";
		$data[0][1] = 0;
		
		$data[1][0] = "Visitors left";
		$data[1][1] = 0;

		$data[2][0] = "Total Visitors";
		$data[2][1] = 0;
		
		$data[3][0] = "Exit rate";
		$data[3][1] = 0;
		
		# Do this when there is a page set in the options
		$pageid = getID($this->page,'urls');
		if (empty($pageid)) {
			return $data;
		}
		
		# clean up temp table
		$db->Execute("drop temporary table if exists goodtimes"); 
		
		# get the visitorid and timestamp of the request we're interested in 
		$db->Execute("CREATE TEMPORARY TABLE goodtimes select visitorid,timestamp from {$this->profile->tablename} where url=".$pageid." and timestamp >=". $db->Quote($this->from) ." and timestamp <=". $db->Quote($this->to));
		
		# first get total number of visitors to page
		$query = "select count(distinct visitorid) from goodtimes";
		$result = $db->Execute($query); 
		$total_visits = $result->FetchRow();
		$total_visits = $total_visits[0];    
		if ($total_visits < 1) {
			return $data;
		}
		
		# count how many visitors have hits beyond the timestamp we just found
		$query = "select count(distinct a.visitorid) from {$this->profile->tablename} as a, goodtimes as b where b.visitorid=a.visitorid and a.timestamp > b.timestamp and a.timestamp <= ". $db->Quote($this->to);
		$result = $db->Execute($query); 
		$stay_visits = $result->FetchRow();
		$stay_visits = $stay_visits[0];
		
		$bounce_visits = $total_visits - $stay_visits;
		$bounce_rate = $bounce_visits / $total_visits * 100;
		
		// set the actual values
		$data = array();					
		$data[0][0] = "Visitors that stayed";
		$data[0][1] = $stay_visits;
		
		$data[1][0] = "Visitors left";
		$data[1][1] = $bounce_visits;

		$data[2][0] = "Total Visitors";
		$data[2][1] = $total_visits;
		
		$data[3][0] = "Exit rate";
		$data[3][1] = number_format($bounce_rate,0);
		
		# clean up temp table
		$db->Execute("drop temporary table goodtimes"); 

		return $data;      
	}
	
	function GetReportData() {
				
		$data = parent::GetReportData();
		$dat = array();
		
		$range = $this->to - $this->from;
		$days = round($range / 86400);
		if($days <= 0){ $days = 1; }		
		
		
		# WARNING the keys in the data array are shafted because they are sorted on value key : 0 = Bounce rate, 1 = Total Visitors etc alphabetic...
		if ($this->displaymode == 'pie') {			
			$dat[0][0] = _VISITORS_STAYED;
			$dat[0][1] = number_format(round( ($data[3][1] / $days)) );
			
			$dat[1][0] = _VISITORS_LEFT . " (". _BOUNCE_RATE .")";
			$dat[1][1] = number_format(round( ($data[2][1] / $days)) );
		} else {

			$dat[0][0] = _VISITORS_STAYED;
			$dat[0][1] = number_format(round( ($data[3][1] / $days)) );
			
			$dat[1][0] = _VISITORS_LEFT;
			$dat[1][1] = number_format(round( ($data[2][1] / $days)) );
			
			$dat[2][0] = _TOTAL;
			$dat[2][1] = number_format(round( ($data[1][1] / $days)) );
			
			$dat[3][0] = _BOUNCE_RATE;
			$dat[3][1] = number_format(($data[0][1] / $days),2) . "%";
			
			
		}
		
		return $dat;
	}

	function DisplayReport() {

		if(empty($this->page)){
			echoNotice($this->SettingsButton(). _PLEASE_PROVIED_A_PAGE);
			return;			
		} else {
			parent::DisplayReport();
		}
	}
	
	function DisplayCustomForm() {
		
		echo "<div class='form-group'>";
		echo "<label for='page'>"._PAGE.":</label>";
		echo "<input class='report_option_field form-control' type='text' name='page' value='".@$this->page."' onkeyup=\"popupActionMenu(event, this.value+'@'+this.name+'@'+'page', 'forminput');\" onclick=\"popupActionMenu(event, this.value+'@'+this.name+'@'+'page', 'forminput');\" />";
		echo "</div>";
	}
	
	function DisplaySparkline() {
		$this->displaymode = 'pie';
		$data = $this->GetReportData();
		$postfix = $data[1][1] / ( $data[1][1]+ $data[0][1]) * 100;
		$postfix = number_format($postfix,0)."%";
        $this->Sparkline($data,$this->sparktype,_BOUNCE_RATE,$postfix);
    }
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>