<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays all traffic by hour
*/

$reports["_ALL_TRAFFIC_BY_MINUTE"] = Array(
	"ClassName" => "AllTrafficByMinute", 
	"Category" => "_TRAFFIC", 
	"icon" => "images/icons/32x32/alltrafficbyhour.png",
	"Options" => "daterangeField,profileselector,trafficsource,columnSelector,displaymode",
	"Filename" => "all_traffic_by_minute",
	"Distribution" => "Premium",
	"Order" => 4,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
);

class AllTrafficByMinute extends Report {
	
	function Settings() {
		$this->DisplayModes = "table,linechart,barchart";
		$this->DefaultDisplay = "linechart";
		if(!isset($this->displaymode)){
			$this->displaymode = "table";
		}
		
		$this->columnDefinitions[] = array("Label" => "_MINUTE_SHORT");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_IPS");

		$this->columnDefinitions[] = array("Label" => "_TOTAL_PAGES");
		$this->columnDefinitions[] = array("Label" => "_VIEWED_PAGES");
		$this->columnDefinitions[] = array("Label" => "_CRAWLED_PERC");
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_IP");
		
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._UNIQUE_IP_DEFINITION.'</li><li>'._TOTAL_PAGES_DEFINITION.'</li><li>'._VIEWED_PAGES_DEFINITION.'</li><li>'._CRAWLED_PERC_DEFINITION.'</li><li>'._PAGES_PER_IP_DEFINITION.'</li></ul>';
		$this->limit = 1440;
		$this->sort = false;
	}
	
	function DefineQuery() {
		global $db;
		$query  = "SELECT FROM_UNIXTIME(timestamp, '%d-%b-%Y %H:%i') AS days, COUNT(DISTINCT visitorid) AS visitors, COUNT(*) as requests, (COUNT(*) - SUM(IF(crawl='0','0',1))) AS viewed, (SUM(IF(crawl='0','0',1)) / (COUNT(*) * 1.00)*100) AS crawled, (COUNT(*) / (COUNT(DISTINCT visitorid) * 1.00)) AS ppu FROM ".$this->profile->tablename_merge." WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." GROUP BY days ORDER BY timestamp";

		return $query;
	}
	function DisplayReport() {
		if (($this->to - $this->from) > (2 * 86400)) {
			echoWarning(_ALL_TRAFFIC_BY_MINUTE_ROW_WARNING);
			echoNotice("Date range has been automatically shortened to the maximum of 2 days");
			$this->from = $this->to - (2 * 86400);
		}
		parent::DisplayReport();

	}
	
	function DisplayCustomForm(){
			echoWarning(_ALL_TRAFFIC_BY_MINUTE_ROW_WARNING,"margin-right:25px;clear:both;");
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){	
		# this report has a low priority
		return false;
	}
}
?>