<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 

# Do some check if we have accesscontrol defined
if(empty($accessControl)){
	$accessControl = array();
}

if(!isset($accessControl['IncludeFile']) && !isset($accessControl['StreamFile']) ){
	if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
		die('{ "Status" : "Error" , "Message" : "Invalid Request." }');
	}
}

include_once 'common.inc.php';

AccessControl($accessControl);

function AccessControl($control){
	global $session;

	# Do we need to check if the user must be logged in ?
	if(!isset($control['NoLoginRequired'])){
		# Are we logged in ?
		if($session->logged_in == 0){
			if(isset($control['IncludeFile'])){
				die('<script>window.location.href = "login.php"</script>');
			} else {
				die('{ "Status" : "Error" , "Message" : "You are not logged in." }');
			}
		}
	}

	if(!empty($control['Admin'])){
		# check if we are not admin
		if (!$session->isAdmin()) {
			die('{ "Status" : "Error" , "Message" : "You are not allowed to view this page." }');
		}
	}

	if(!empty($control['ProfileRequired'])){
		# check if we are not an admin
		if (!$session->isAdmin()) {			
			# if we have a profile, check if this user may access it (this check is also performed in siteprofile) 
			# but we are going to check this here on multiple levels just in case
			
			if (isset($conf) && isset($editconf)) {
				# this situation should not occur to begin with
				die('{ "Status" : "Errror" , "Message" : "Access denied." }');
			}
			
			if (isset($conf)) {
				$checkprofile = $conf;
			}
			
			if (isset($editconf)) {
				$checkprofile = $editconf;
			}
			
			if (isset($profile->profilename)) {
				# if the profileobject already exists somewhow, this is the one we will check
				$checkprofile = $profile->profilename;
			}			
			
			if (isset($checkprofile)) {
				if ($session->canAddProfiles() && $checkprofile=="newcnf") {
					# user is allowd to create a new profile, so let them pass
				} else if(!in_array($checkprofile, $session->user_profiles) && !$session->allProfiles ){
					die('{ "Status" : "Error" , "Message" : "Access denied." }');
				}
			}
		}
	}	
		
}
?>