
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `logaholic716`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lgstatus`
--

CREATE TABLE `[[dbprefix]]lgstatus` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `code` int(5) NOT NULL DEFAULT '0',
  `descr` varchar(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]lgstatus`
--

INSERT INTO `[[dbprefix]]lgstatus` VALUES
(1, 100, 'Continue'),
(2, 101, 'Switching Protocols'),
(3, 102, 'Processing'),
(4, 200, 'OK'),
(5, 201, 'Created'),
(6, 202, 'Accepted'),
(7, 203, 'Non-Authoritative Information'),
(8, 204, 'No Content'),
(9, 205, 'Reset Content'),
(10, 206, 'Partial Content'),
(11, 207, 'Multi-Status'),
(12, 300, 'Multiple Choices'),
(13, 301, 'Moved Permanently (redirect)'),
(14, 302, 'Moved Temporarily (redirect)'),
(15, 303, 'See Other'),
(16, 304, 'Not Modified'),
(17, 305, 'Use Proxy'),
(18, 307, 'Temporary Redirect'),
(19, 400, 'Bad Request'),
(20, 401, 'Authorization Required'),
(21, 402, 'Payment Required'),
(22, 403, 'Forbidden'),
(23, 404, 'Not Found'),
(24, 405, 'Method Not Allowed'),
(25, 406, 'Not Acceptable'),
(26, 407, 'Proxy Authentication Required'),
(27, 408, 'Request Time-out'),
(28, 409, 'Conflict'),
(29, 410, 'Gone'),
(30, 411, 'Length Required'),
(31, 412, 'Precondition Failed'),
(32, 413, 'Request Entity Too Large'),
(33, 414, 'Request-URI Too Large'),
(34, 415, 'Unsupported Media Type'),
(35, 416, 'Requested Range Not Satisfiable'),
(36, 417, 'Expectation Failed'),
(37, 422, 'Unprocessable Entity'),
(38, 423, 'Locked'),
(39, 424, 'Failed Dependency'),
(40, 425, 'No code'),
(41, 426, 'Upgrade Required'),
(42, 500, 'Internal Server Error'),
(43, 501, 'Method Not Implemented'),
(44, 502, 'Bad Gateway'),
(45, 503, 'Service Temporarily Unavailable'),
(46, 504, 'Gateway Time-out'),
(47, 505, 'HTTP Version Not Supported'),
(48, 506, 'Variant Also Negotiates'),
(49, 507, 'Insufficient Storage'),
(50, 510, 'Not Extended');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notes`
--

CREATE TABLE `[[dbprefix]]notes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `profile` varchar(75) NOT NULL DEFAULT '0',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `note` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `profile` (`profile`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_logaholic_GlobalSettings`
--

CREATE TABLE `[[dbprefix]]_logaholic_GlobalSettings` (
  `Name` varchar(255) NOT NULL,
  `Profile` varchar(50) DEFAULT NULL,
  `Value` mediumtext,
  PRIMARY KEY (`Name`),
  KEY `_logaholic_GlobalSettings_Profile` (`Profile`,`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_logaholic_GlobalSettings`
--

INSERT INTO `[[dbprefix]]_logaholic_GlobalSettings` VALUES
('DB_MetadataVersion', '', '2.47'),
('DB_UserDataVersion', '', '2.21'),
('UserAuthenticationType', '', 'logaholic'),
('datamanagersettings', '', '0'),
('datamanagerStorageSize', '', '5000'),
('profileDateFormat', '', '{"format1":"d","seperator1":" ","format2":"M","seperator2":" ","format3":"Y","seperator3":" ","format4":""}'),
('datamanagerDirectory', '', '[[softpath]]/data/'),
('UserAuthenticationType_Var', '', ''),
('upload_dir', '', '[[softdatadir]]/');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_logaholic_goals`
--

CREATE TABLE `[[dbprefix]]_logaholic_goals` (
  `goalID` int(11) NOT NULL AUTO_INCREMENT,
  `goalName` varchar(100) DEFAULT NULL,
  `timeunit` varchar(100) DEFAULT NULL,
  `targetValue` varchar(11) DEFAULT NULL,
  `metric` varchar(50) DEFAULT NULL,
  `conditions` text,
  `graphType` varchar(50) DEFAULT 'speed',
  `profileID` int(11) DEFAULT NULL,
  `inverse` int(1) DEFAULT NULL,
  `kpi` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`goalID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_logaholic_Profiles`
--

CREATE TABLE `[[dbprefix]]_logaholic_Profiles` (
  `profileid` int(11) NOT NULL AUTO_INCREMENT,
  `profilename` varchar(255) DEFAULT NULL,
  `confdomain` varchar(255) DEFAULT NULL,
  `equivdomains` text,
  `tablename` varchar(64) DEFAULT NULL,
  `defaultfile` varchar(128) DEFAULT NULL,
  `logfilefullpath` text,
  `splitlogs` tinyint(4) DEFAULT '0',
  `splitfilter` varchar(100) DEFAULT NULL,
  `trackermode` tinyint(4) DEFAULT '0',
  `visitoridentmethod` tinyint(4) DEFAULT NULL,
  `skipips` text,
  `skipfiles` text,
  `targetfiles` mediumtext,
  `othersettings` text,
  `structure_version` float DEFAULT NULL,
  `animate` int(1) DEFAULT '1',
  `timezonecorrection` varchar(5) DEFAULT '0',
  `recursive` int(1) DEFAULT '0',
  `ftpserver` varchar(150) DEFAULT NULL,
  `ftpuser` varchar(50) DEFAULT NULL,
  `ftppasswd` varchar(50) DEFAULT NULL,
  `ftpfullpath` text,
  `visittimeout` int(2) DEFAULT '20',
  `urlparamfilter` varchar(255) DEFAULT '',
  `urlparamfiltermode` varchar(20) DEFAULT 'Exclude',
  `splitfilternegative` varchar(100) DEFAULT NULL,
  `feedurl` varchar(100) DEFAULT '',
  `feedburneruri` varchar(100) DEFAULT '',
  `timezone` varchar(50) DEFAULT '',
  `googleparams` varchar(255) DEFAULT 'q, start, gclid, as_q, as_epq, as_oq, as _eq, as_sitesearch, as_rq, as_lq',
  `lastused` int(11) DEFAULT '0',
  `sessioncounter` int(11) NOT NULL DEFAULT '0',
  `stats` text,
  `update_status` char(7) NOT NULL DEFAULT 'ready',
  `dashboards` longtext,
  `other_settings` longtext,
  `filehistory` longtext,
  `activated` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`profileid`),
  UNIQUE KEY `_logaholic_Profiles_profilename` (`profilename`),
  UNIQUE KEY `_logaholic_Profiles_tablename` (`tablename`),
  KEY `lastused` (`lastused`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_logaholic_Profile_URL_Params`
--

CREATE TABLE `[[dbprefix]]_logaholic_Profile_URL_Params` (
  `paramid` int(11) NOT NULL AUTO_INCREMENT,
  `profileid` int(11) NOT NULL,
  `filename` varchar(128) NOT NULL,
  `nameisregex` tinyint(1) DEFAULT '0',
  `importantparams` text,
  PRIMARY KEY (`paramid`),
  KEY `profileid` (`profileid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_logaholic_Traffic_Sources`
--

CREATE TABLE `[[dbprefix]]_logaholic_Traffic_Sources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profileid` int(11) NOT NULL,
  `sourcename` varchar(128) NOT NULL,
  `sourcecondition` text,
  `category` varchar(255) DEFAULT NULL,
  `userid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `_logaholic_Traffic_Sources_sourcename` (`sourcename`),
  KEY `_logaholic_Traffic_Sources_profileid` (`profileid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_logaholic_users`
--

CREATE TABLE `[[dbprefix]]_logaholic_users` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `profiles` text,
  `foreignkey` varchar(100) DEFAULT NULL,
  `created` int(11) NOT NULL,
  `isAdmin` int(4) NOT NULL DEFAULT '0',
  `active` tinyint(1) DEFAULT '1',
  `accessUpdateLogs` tinyint(4) NOT NULL DEFAULT '1',
  `accessAddProfile` tinyint(4) NOT NULL DEFAULT '1',
  `usersessionid` varchar(32) DEFAULT NULL,
  `lastlogin` int(11) NOT NULL DEFAULT '0',
  `accessEditProfile` tinyint(4) NOT NULL DEFAULT '1',
  `expires` int(11) NOT NULL DEFAULT '0',
  `metadata` text,
  `subscriptionid` int(11) DEFAULT NULL,
  PRIMARY KEY (`userid`),
  UNIQUE KEY `_logaholic_users_username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_logaholic_users`
--

INSERT INTO `[[dbprefix]]_logaholic_users` VALUES
(1, '[[admin_username]]', '[[admin_realname]]', '[[admin_pass]]', '[[admin_email]]', NULL, NULL, [[timestamp]], 1, 1, 1, 1, NULL, 0, 1, 0, '{}', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_report_usage`
--

CREATE TABLE `[[dbprefix]]_report_usage` (
  `profilename` varchar(255) NOT NULL,
  `reporturl` text NOT NULL,
  `hits` int(11) NOT NULL,
  `month` int(6) NOT NULL,
  `reporturl_hash` varchar(32) DEFAULT NULL,
  UNIQUE KEY `usagekey` (`profilename`,`month`,`reporturl_hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DELIMITER $$
--
-- Functions
--
CREATE FUNCTION `lg_getparam`(param varchar(55), url varchar(2048)) RETURNS varchar(2048) CHARSET utf8 COLLATE utf8_unicode_ci
BEGIN 
			declare val varchar(2048);
			declare _param varchar(60) DEFAULT CONCAT(param,'=');
			 
			select SUBSTRING_INDEX(SUBSTRING_INDEX(url,_param,-1), '&', 1)
			into val;
			 
			RETURN val;

			END$$

DELIMITER ;


/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
