<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays a table with most viewed videos of your selected youtube channel.
*/

$reports["_YOUTUBE_CHANNEL"] = Array(
    "ClassName" => "YoutubeChannel", 
    "Category" => "_POPULAR_CONTENT", 
    "icon" => "images/icons/32x32/youtube_channel.png",
	"Options" => "limit,columnSelector",
	"Filename" => "youtube_channel",
	"Distribution" => "Premium",
	"Order" => 10,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false,
	"canAggregate" => false
);

class YoutubeChannel extends Report {

	function Settings() {
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.":<ul>". _YOUTUBE_CHANNEL_DESC ."</ul>";

		$this->columnDefinitions[] = array("Label" => "_NAME");
		$this->columnDefinitions[] = array("Label" => "_VIEWS","bchart" => true, "dataType" => "String");
		$this->columnDefinitions[] = array("Label" => "_COMMENTS","bchart" => false, "dataType" => "String");

		if(empty($this->smode) || $this->smode == 'video' ){
			$this->columnDefinitions[] = array("Label" => "_LIKES","bchart" => false, "dataType" => "String");
			$this->columnDefinitions[] = array("Label" => "_DISLIKES","bchart" => false, "dataType" => "String");
		} else {
			$this->columnDefinitions[] = array("Label" => "_SUBSCRIBERS","bchart" => false, "dataType" => "String");
			$this->columnDefinitions[] = array("Label" => "_VIDEOS","bchart" => false, "dataType" => "String");
		}

		if(!isset($this->ytsearch)){
			$this->ytsearch = "";
		}

		if(empty($this->smode)){
			$this->smode = 'video';
		}

		if(!empty($this->ytsearch)){
			$this->addlabel = $this->smode.": ".$this->ytsearch;
		}
	}
    
	function DisplayCustomForm(){	
		$form = $this->createForm();
		return $form;
	}

	function createForm(){
		if ($this->smode=='video') {
			$sel = "selected";
		} else {
			$sel ="";
		}
		$form = "
		<div class='form-group'>
			<label for='ytsearch'>". _SEARCH .":</label>
			<select class='report_option_field form-control' name='smode' id='smode'>
				<option value='channel'>". _AUTHOR ."</option>
				<option value='video' $sel>". _KEYWORD ."</option>
			</select>
		</div>
		<div class='form-group'>
			<label for='ytsearch'>". _KEYWORD .":</label>
			<input type='text' id='ytsearch' name='ytsearch' value='$this->ytsearch' class='report_option_field form-control' />
		</div>
		";		
		return $form;
	}

	function GetReportData(){
		$base = "https://www.googleapis.com/youtube/v3/";
		$key = "AIzaSyDtr5WOqezd7TAEAlNDvXQvMEx73sCXVk8";
		$search = $this->ytsearch;
		
		$ids = array();
		$data = array();

		$search_request  = $base . "search?part=snippet";
		$search_request .= "&order=viewCount";
		$search_request .= "&maxResults=50";
		$search_request .= "&type=" . $this->smode;
		$search_request .= "&q=" . urlencode($search);
		$search_request .= "&key=" . $key;

		$search_result = file_get_contents($search_request);
		$search_result = json_decode($search_result,true);

		if(empty($search_result['items'])){
			return array();
		}


		foreach ($search_result['items'] as $k => $v) {
			if($this->smode == "video"){
				$ids[] = $v['id']['videoId'];
			} else {
				$ids[] = $v['id']['channelId'];
			}
		}

		if($this->smode == "video"){
			$data_request = $base . "videos?part=snippet%2Cstatistics&id=". urlencode(implode(",", $ids)) ."&maxResults=50&key=" . $key;
		} else {
			$data_request = $base . "channels?part=snippet%2Cstatistics&id=". urlencode(implode(",", $ids)) ."&maxResults=50&key=" . $key;
		}



		$data_result = file_get_contents($data_request);
		$data_result = json_decode($data_result,true);

		if(empty($data_result['items'])){
			return array();
		}

		$i = 0;
		foreach ($data_result['items'] as $k => $v) {
			$link = "https://www.youtube.com/watch?v={$v["id"]}";
			if($this->smode != "video"){
				$link = "https://www.youtube.com/{$v['snippet']['title']}";
			}

			if($i < $this->limit){
				$data[$i][0] = "<a style='line-height:24px;' href='{$link}' target='_blank'><img style='width:36px; float:left; margin-right:5px;' src='{$v['snippet']['thumbnails']['default']['url']}' alt='thumbnail'/>{$v['snippet']['title']}</a>";
				$data[$i][1] = (empty($v['statistics']['viewCount'])) ? 0 : $v['statistics']['viewCount'];
				$data[$i][2] = (empty($v['statistics']['commentCount'])) ? 0 : $v['statistics']['commentCount'];
				
				if($this->smode == "video"){
					$data[$i][3] = (empty($v['statistics']['likeCount'])) ? 0 : $v['statistics']['likeCount'];
					$data[$i][4] = (empty($v['statistics']['dislikeCount'])) ? 0 : $v['statistics']['dislikeCount'];
				} else {
					$data[$i][3] = (empty($v['statistics']['subscriberCount'])) ? 0 : $v['statistics']['subscriberCount'];
					$data[$i][4] = (empty($v['statistics']['videoCount'])) ? 0 : $v['statistics']['videoCount'];				
				}

				$i ++;
			}
		}

		return $data;
	}

	function DisplayReport(){
		$this->ReportHeader();

		if(!extension_loaded("openssl")){
			echoNotice("In order to use this report you need the openssl extension loaded in your php.ini (extension=php_openssl.dll)", "margin:10px;");
			return false;
		}

		$data = $this->GetReportData();
		$this->Table($data);
	}
}
?>