<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 

$reports["_TOP_PAGES_LAST_HOUR"] = Array(
	"ClassName" => "TopPagesLastHour", 
	"Category" => "_POPULAR_CONTENT", 
	"icon" => "images/icons/32x32/toppages.png",
	"Options" => "displaymode,limit,profileselector,columnSelector",
	"Filename" => "top_pages_last_hour",
	"Distribution" => "Premium",
	"Order" => 9,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false,
	"canAggregate" => false
);

class TopPagesLastHour extends Report {
	
	function Settings() {
		$this->datafiles = false;
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,bubble,pie";
		$this->bubblefields = _VISITS.','._PAGES_PER_VISIT.','._PAGEVIEWS.','._PAGE;
		
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT", "totalRow" => "avg");
		$this->actionmenu_type = 'page';
		$time = $this->profile->max_db_timestamp - (60*60);
		$this->addlabel = date(implode($this->profile->dateFormat)." H:i", $time) . " - ".date(implode($this->profile->dateFormat)." H:i", $this->profile->max_db_timestamp);
		
	}
	

	function DefineQuery() {
		global $nc, $db;
		
		$this->to = $this->profile->max_db_timestamp;
		$this->from = $this->to - (60*60);
		$subquery = "select url,count(distinct visitorid) as visitors,count(*) as hits from {$this->profile->tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." group by url order by visitors desc limit $this->limit";
        $query = "select IF(r.title = '',r.url,CONCAT(r.url,'##',r.title)) as urlinfo, sq.visitors, sq.hits, (sq.hits/sq.visitors) as pv from ($subquery) as sq, {$this->profile->tablename_urls} as r where sq.url=r.id";

		return $query;
	}

	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}

}
?>
