<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report shows details about the top keywords
*/
$reports["_TOP_KEYWORDS_DETAILS"] = Array(
	"ClassName" => "TopKeywordsDetails", 
	"Category" => "_TRAFFIC_SOURCES", 
	"icon" => "images/icons/32x32/topkeywordsdetails.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector,human",
	"Filename" => "top_keywords_details",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"canAggregate" => false
);

class TopKeywordsDetails extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "_KEYWORDS","actionmenu" => 'keyword');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_HITS");
		$this->columnDefinitions[] = array("Label" => "_REFERRER","actionmenu" => 'referrer');
		$this->actionmenu_type = 'keyword';
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
		$this->key_col = 5;
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._KEYWORDS_DEFINITION.'</li><li>'._VISITS_DEFINITION.'</li><li>'._HITS_KEYWORDS_DEFINITION.'</li><li>'._REFERRER_DEFINITION.'</li></ul>';
	}
	
	function DefineQuery() {
		global $nc,$db;
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}
		
		$emptykeyword = getID('','keyword');
		//$notprovided = getID('(not provided)','keyword');
		
		$subquery = subsetDataToSourceID("select {$nc} keywords,referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$tablename} where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and keywords != ". $db->Quote($emptykeyword) ." group by keywords,referrer order by visits desc", $this->trafficsource);
		$this->applytrafficsource = false;
		
		$query  = "select k.keywords, sq.visits, sq.hits, r.referrer, sq.visitors, MD5(CONCAT(sq.keywords,sq.referrer)) as grouper FROM ({$subquery}) as sq, {$this->profile->tablename_referrers} as r, {$this->profile->tablename_keywords} as k WHERE sq.referrer= r.id and sq.keywords= k.id";
		
		return $query;
	}
	function UpdateStats($from = '', $to = '',$print = 2) {
		# not important enough to auto create datafiles
		return false;		
	}
}
?>
