<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/
$reports["_TOP_COUNTRIES_CITIES"] = Array(
	"ClassName" => "TopCountriesCities", 
	"Category" => "_LOCATIONS", 
	"icon" => "images/icons/32x32/topcountriescities.png",
	"Options" => "daterangeField,displaymode,country,profileselector,trafficsource,limit,columnSelector,human",
	"Filename" => "top_countries_cities",
	"Distribution" => "Premium",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class TopCountriesCities extends Report {
	function Settings() {
		$this->DisplayModes = "map,table";
		$this->DefaultDisplay = "map";

		$this->columnDefinitions[] = array("Label" => "_COUNTRIES", "actionmenu" => 'country');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT", "totalRow" => "avg");
		
		$this->paginationDisplayLength = 10;
		if($this->limit < 100){ $this->limit = 100; } # fix the bug in the dashboard first that shows 100 instead of doing pagination
		$this->paginationPanel = true;
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;

		if (isset($this->country)) {
			$this->search = $this->country;
			$this->searchmode = "equals";
		}

		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._COUNTRY_DEFINITION.'<li>'._VISITS_DEFINITION.'<li>'._PAGEVIEWS_DEFINITION.'<li>'._AVERAGE_PAGES_PER_USER_DEFINITION.'</ul><div class=\'indentbody\'>'._INSTALL_UPDATE_GEO.'</div>';
	}

	function DefineQuery() {
		global $db;
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}
		$query  = "select country, count(distinct sessionid) as ips,count(*) as hits from {$tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and country!='' group by country order by ips desc";
		
		return $query;
	}

	function GetReportData(){
		$data = parent::GetReportData();
		
		# add the pages per visit column
		foreach($data as $k => $v){
			if(isset($data[$k][1]) && !empty($data[$k][1])){
				$data[$k][3] = number_format(($data[$k][2] / $data[$k][1]),2); 
			}
		}
		return $data;
		
	}
	function DisplayReport(){
		global $cnames, $reports;

		$data = $this->GetReportData();
		
		if ($this->displaymode=="map") {		
		
			$this->reportHeader();
			$this->WorldMapGraph($data);			
					
			$this->displayHeader = false;
			$this->Table($data);
		} else {
			$this->Table($data);			
		}
	}
	
}
?>