<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays a overview of your recent visitors
*/
$reports["_RECENT_VISITORS"] = Array(
	"ClassName" => "RecentVisitors", 
	"Category" => "_VISITOR_DETAILS", 
	"icon" => "images/icons/32x32/recentvisitors.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector,human",
	"Filename" => "recent_visitors",
	"Distribution" => "Premium",
	"Order" => 4,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"Update" => false
);

class RecentVisitors extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table";
		$this->datafiles = false;
		$this->columnDefinitions[] = array("Label" => "_IP_NUMBER","actionmenu" => 'ip');
		$this->columnDefinitions[] = array("Label" => "_REQUESTS");
		$this->columnDefinitions[] = array("Label" => "_LAST_REQUESTS");
		$this->columnDefinitions[] = array("Label" => "_COUNTRY");

		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul>'.'<li>'._IP_NUMBER_DEFINITION.'</li><li>'._REQUESTS_DEFINITION.'</li><li>'._LAST_REQUEST_DEFINITION.'</li><li>'._COUNTRY_DEFINITION.'</li></ul>';
	}
	
	function DefineQuery() {
		global $db;

		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

        if (!empty($this->search)){
            $searchst = $this->MakeSearchString($this->search,"v.ipnumber",$this->searchmode);  
        } else {
			$searchst = "";
		}

        $subquery  = "select visitorid,count(*) as hits,max(timestamp) as time,country from {$tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." group by visitorid order by time desc ";
        $subquery = subsetDataToSourceID($subquery, $this->trafficsource);
        $this->applytrafficsource = false;
		
        $query = "SELECT concat(v.ipnumber,'##',v.visitorid,'##',v.customlabel), hits, FROM_UNIXTIME(time,'%d-%b-%Y %a %H:%i:%s'), country, a.visitorid FROM ({$subquery}) as a, {$this->profile->tablename_visitorids} as v where a.visitorid=v.id ";
		if(!empty($searchst)){
			$query .= $searchst;
		}
		$query .= "limit ". $this->limit;
		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long and it makes no sense to keep this shit
		return false;		
	}
}
?>
