<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report lets you make split test of your pages and gives you an overview of wich one works the best.
*/
$reports["_OPENCART_SALES_PER_COUNTRY"] = Array(
	"ClassName" => "OpenCartSalesPerCountry",
	"Category" => "_OPENCART",
	"icon" => "images/icons/32x32/opencart.png",
	"Options" => "daterangeField,displaymode,limit",
	"Filename" => "oc_sales_per_country",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class OpenCartSalesPerCountry extends Report {
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => _COUNTRY);
		$this->columnDefinitions[] = array("Label" => _TOTAL_REVENUE);
		$this->columnDefinitions[] = array("Label" => _ORDERS);
		$this->columnDefinitions[] = array("Label" => _REVENUE_PER_SALE);
		$this->columnDefinitions[] = array("Label" => _TOTAL_PRODUCTS);
		
		if(empty($this->order_status)) { $this->order_status = '0'; }
		if(empty($this->oc_store)) { $this->oc_store = '0'; }
		if(empty($this->order_status_name)) { $this->order_status_name = _ALL_STATUSSES; }
		$this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.openCartConnect", "");
	}
	
	function DefineQuery() {
		global $db;
		if ($this->order_status != '0') {
			$sql = " AND o.order_status_id = ". $db->Quote($this->order_status);
		} else {
			$sql = " AND o.order_status_id > '0'";
		}
		
		if (!empty($this->from)) {
			$sql .= " AND DATE(o.date_added) >= '" . date('Y-m-d', $this->from) . "'";
		}

		if (!empty($this->to)) {
			$sql .= " AND DATE(o.date_added) <= '" . date('Y-m-d', $this->to) . "'";
		}
			
		$query = "SELECT o.payment_country AS countrie, sum(total) as totRevenue, count(order_id) as orders, FORMAT(sum(total) / count(order_id),2) as rps, SUM((SELECT count(op.product_id) FROM order_product as op WHERE o.order_id = op.order_id )) as ppo, (SELECT `code` from {$this->tableprefix}currency WHERE `value` = 1) as currency
		FROM `{$this->tableprefix}order` as o WHERE store_id = ". $db->Quote($this->oc_store) ." {$sql} GROUP BY o.payment_country ORDER BY sum(total) DESC LIMIT {$this->limit};";
		return $query;
	}
	
	function GetReportData() {
		global $cnames;
		
		$countrynames = array_flip($cnames);
		
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection == false){ echoNotice($this->SettingsButton()._CONNECTION_TO_DATABASE_FAILED);exit();  }
		
		$query = $this->DefineQuery();
		$currency = "";
		$result = mysql_query($query, $connection);
		$data = array();
		while($row = mysql_fetch_array($result)) {
			if(!empty($row['currency'])) {
				$currency = $row["currency"];
			}
			if(isset($countrynames[$row[0]])){
			$row[0] = $countrynames[$row[0]];
			}
			$data[] = $row;
		}
		
		$this->addlabel .= _ORDER_STATUS.": {$this->order_status_name}";	
		$this->addlabel .= " | ". _CURRENCY .": {$currency}";	
		
		return $data;
	}
	
	function DisplayCustomForm() {
		global $session;
		
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection != false){	
			#GET STORES
			$query = "SELECT `store_id`,`name` FROM store";
			$result = mysql_query($query, $connection);
			
			echo "<div class='form-group'><label for='oc_store'>".'Store'."</label>";
			
			echo "<select id='oc_store' name='oc_store' class='form-control'>";
			
			echo "<option value='0'>".'Default Store'."</option>";
			while($row = mysql_fetch_assoc($result)) {
				if($row['store_id'] == $this->oc_store) {
					$selected = ' selected ';
				} else {
					$selected = '';
				}
				echo "<option value='{$row["store_id"]}' {$selected}>{$row["name"]}</option>";
			}
			echo "</select>";
			if($session->canEditProfiles()) {
				echo "<a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a>";
			}
			echo "</div>";
			
			# GET ORDER STATUS
			$query = "SELECT DISTINCT(order_status_id) AS status_id, `name` AS status_name FROM `{$this->tableprefix}order_status` ORDER BY `name` ASC";
			
			$result = mysql_query($query, $connection);
			
			if(empty($this->order_status)) { $this->order_status = '0'; }
			if(empty($this->order_status_name)) { $this->order_status_name = _ALL_STATUSSES; }

			echo "<div class='form-group'>";			
				echo "<label for='order_status'>"._ORDER_STATUS."</label>";
				echo "<input type='hidden' id='order_status_name' name='order_status_name' value='{$this->order_status_name}'>";
				
				echo "<select id='order_status' name='order_status' class='form-control'>";
					echo "<option value='0'>"._ALL_STATUSSES."</option>";
				while($row = mysql_fetch_assoc($result)) {
					if($row['status_id'] == $this->order_status) {
						$selected = ' selected ';
					} else {
						$selected = '';
					}
					echo "<option {$selected} value='{$row['status_id']}'>{$row['status_name']}</option>";
				}
				echo "</select>";
			echo "</div>";
			
			echo "<script type='text/javascript'>";
				echo "$('#order_status').change(function() {
					$('#order_status_name').attr('value', $(this).find('option[value=\"' + $(this).val() + '\"]').html());
				});";
			echo "</script>";
		} else if($session->canEditProfiles()){
			echo "<div class='form-group'><a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>View Open Cart Configuration.</a></div>";
		}
	}
	function DefineReport(){
		$this->externDbConnectForm("openCartConnect");	
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}