<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
define("_MINI_PAGES_PER_USER",_PAGES_PER_USER );

$reports["_MINI_PAGES_PER_USER"] = Array(
	"ClassName" => "MiniPagesPerUser", 
	"Category" => "_KEY_METRIC", 
	"icon" => "images/icons/32x32/visitorsperday.png",
	"Options" => "daterangeField,profileselector",
	"Filename" => "metric_pages_per_user",
	"Distribution" => "Standard",
	"Order" => 4,
	"ReportVersion" => 6.0,
	"MinimumVersion" => 6.0,
	"Update" => false
);

class MiniPagesPerUser extends Report {
	
	function GetReportData(){
		global $reports;

		$r = new $reports['_VISITORS_PER_DAY']['ClassName']();
		$r->IgnReIm = 1;
		$r->from = $this->from;
		$r->to = $this->to;
		$data = $r->GetReportData();

		$ppu = 0;
		$i = 0;
		foreach ($data as $row => $col) {
			$ppu += $col[3];
			$i ++;
		}

		$daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(implode($this->profile->dateFormat), $this->to);

		if ($i == 0) {
			$n =0;
		} else {
			$n = $ppu / $i;
		}
		return array( 
			_PAGES_PER_USER 		# Label
			,number_format($n, 2)# Number to display
			,'_VISITORS_PER_DAY'	# Report label to load
			,'ion-ios-eye'		# Background icon Class
			,'bg-green'
			,"<strong>". $daterange . "</strong><br/>" . _MINI_PAGES_PER_USER_DESC
			,'&displaymode=table&showColumn0=true&showColumn1=true&showColumn0=true&showColumn1=true&showColumn2=true&showColumn3=true'			
		);
	}
}
?>