<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
 
$reports["_INTERCOM_CONVERSATIONS_STATUS"] = Array(
 	
  "ClassName" => "IntercomConversationsStatus", 
  "Category" => "_INTERCOM", 
  "Options" => "displaymode",
  "Distribution" => "Premium",
  "EmailAlerts" => false,
  "Update" => false,
  "Filename" => "intercom_conversations_status"
 
); 

 
class IntercomConversationsStatus extends Report {

    function Settings() {
        $this->DisplayModes = "table,pie";
        $this->DefaultDisplay = "pie";
        $this->columnDefinitions[] = array("Label" => "Conversation");
        $this->columnDefinitions[] = array("Label" => "Amount", "totalRow" => "none");
        $this->help = "This will show the status of the conversations for intercom.";
        $old_api_id = $this->profile->GetOtherSettings("IntercomApiId", "");
        $old_api_key = $this->profile->GetOtherSettings("IntercomApiKey", "");
        if(isset($this->ApiKey) && $this->ApiKey != $old_api_key) {
           $this->profile->SetOtherSettings("IntercomApiKey", $this->ApiKey);
        } else {
            $this->ApiKey = $old_api_key;
            
        }
        if(isset($this->ApiID) && $this->ApiID != $old_api_id){
            $this->profile->SetOtherSettings("IntercomApiId", $this->ApiID);
        } else {
            $this->ApiID = $old_api_id;
        }

    }
    function curl_download($Url){
 
        // OK cool - then let's create a new cURL resource handle
        $ch = curl_init();
     
        // Now set some options (most are optional)
     
        // Set URL to download
        curl_setopt($ch, CURLOPT_URL, $Url);
     

        curl_setopt($ch, CURLOPT_USERPWD, $this->ApiID . ":" . $this->ApiKey);
        // Include header in result? (0 = yes, 1 = no)
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Accept: application/json',
            ));
     
        // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
     
        // Timeout in seconds
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
     
        // Download the given URL, and return output_add_rewrite_var(name, value)
        $output = curl_exec($ch);
     
        // Close the cURL resource, and free system resources
        curl_close($ch);


        return($output);

    }   
    function DisplayCustomForm(){
        $form = "<div class='form-group'>" .
                "<label for='author'>API Key:</label>
                <input type='text' name='ApiKey'
                value='".@$this->ApiKey."' class='report_option_field form-control' /> " .
                "</div>" .
                "<div class='form-group'>" .
                "<label for='author'>API ID:</label>
                <input type='text' name='ApiID'
                value='".@$this->ApiID."' class='report_option_field form-control' />" .
                "</div>"; 
                 
        return $form;
    } 
    function GetReportData(){


        $r = $this->curl_download("https://api.intercom.io/counts?type=conversation");
        $result = json_decode($r, true);


        if($result['type'] == 'error.list'){
            foreach($result['errors'] as $k => $v) {
                echoWarning("Intercom Error ({$v['code']}) : {$v['message']}");
            }
            return array();
        }

        if(empty($result)){
            return array();
        }

        $data = array();
        $i= 0;
        foreach($result['conversation'] as $key => $amount) {
                $data[$i][0] = $key;
                $data[$i][1] = $amount;
                $i++;
        }
        return $data;
        
    }
    function DisplayReport(){
        // is cURL installed yet?
        if (!function_exists('curl_init')){
            echoWarning('Sorry cURL is not installed!');
            return false;
        }

        if (empty($this->ApiID) || empty($this->ApiKey)) {
            echoNotice($this->SettingsButton(). "The ID field or the Key field is empty. <br><br> for more information: check <a href='https://developers.intercom.io/page/getting-started' target='_blank'>the documentation</a>. ");
            return false;
        }else{
                parent::DisplayReport();
        }    
    }     
}
?>