<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the google rankings
*/
$reports["_GOOGLE_RANKINGS"] = Array(
	"ClassName" => "GoogleRankings", 
	"Category" => "_TRAFFIC_SOURCES", 
	"icon" => "images/icons/32x32/google.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector",
	"Filename" => "google_rankings",
	"Distribution" => "Premium",
	"Order" => 10,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"canAggregate" => false
);

class GoogleRankings extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->actionmenu_type = 'keyword';
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
		
		$this->columnDefinitions[] = array("Label" => "_KEYWORDS","actionmenu" => 'keyword');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_SEARCH_RESULT_PAGE","dataType" => "String");
	}
	
	function DefineQuery() {
		global $db;
	
		$query  = "select k.keywords,count(distinct sessionid) as visits,(SUBSTR(rp.params,(LOCATE('start',rp.params)+6),2))/10+1 as pagenum, count(distinct visitorid) as visitors FROM {$this->profile->tablename} as a,{$this->profile->tablename_keywords} as k,{$this->profile->tablename_urls} as u,{$this->profile->tablename_urlparams} as up,{$this->profile->tablename_refparams} as rp, {$this->profile->tablename_referrers} as r where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and a.keywords=k.id and a.url=u.id and a.params=up.id and a.refparams=rp.id and a.referrer=r.id and k.keywords!='' and up.params not like '?gclid%' and r.referrer like 'http://www.google.%' group by a.keywords,pagenum order by visits desc";

		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
