<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays all traffic by day
*/
$reports["_ALL_TRAFFIC_BY_DAY"] = Array(
	"ClassName" => "AllTrafficByDay", 
	"Category" => "_TRAFFIC", 
	"icon" => "images/icons/32x32/alltrafficbyday.png",
	"Options" => "daterangeField,displaymode,profileselector,trafficsource,columnSelector",
	"Filename" => "all_traffic_by_day",
	"Distribution" => "Standard",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class AllTrafficByDay extends Report {
	
	function Settings() {
		$this->DisplayModes = "table,linechart,areachart";
		$this->DefaultDisplay = "linechart";

		$this->chartoptions = array("stacked_graph_style" => "stack", "stacked_showcontrols" => true, "showlegend" => true);

		$this->columnDefinitions[] = array("Label" => "_DATE");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS", "line_order" => 3);
		$this->columnDefinitions[] = array("Label" => "_TOTAL_PAGES", "line_order" => 0);
		$this->columnDefinitions[] = array("Label" => "_VIEWED_PAGES", "bchart" => false, "line_order" => 1);
		$this->columnDefinitions[] = array("Label" => "_CRAWLED_PERC","disable_line" => "true", "line_order" => 4);
		$this->columnDefinitions[] = array("Label" => "_VISITS", "bchart" => false, "line_order" => 2);
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT","disable_line" => "true", "line_order" => 5);
		
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._UNIQUE_VISITORS_DEFINITION.'<li>'._TOTAL_PAGES_DEFINITION.'<li>'._VIEWED_PAGES_DEFINITION.'<li>'._CRAWLED_PERC_DEFINITION.'<li>'._VISITS_DEFINITION.'<li>'._AVERAGE_PAGES_PER_VISIT_DEFINITION.'</ul><div class=\'indentbody\'>'._ALL_TRAFFIC_BY_DAY_NOTE.'</div>';
		$this->sort = false;
		
	}
	function GetReportData(){
		$d = parent::GetReportData();	
		$data = array();
		$i = 0;

		foreach($d as $val){
			$data[$i][0]  = $val[0];
			$data[$i][1]  = $val[5];
			$data[$i][2]  = $val[2];
			$data[$i][3]  = $val[3];
			if($val[2] == 0){
				$data[$i][4]  = 0;
			} else {
				$data[$i][4]  = number_format(($val[4] / $val[2]) * 100, 2);
			}
			
			$data[$i][5]  = $val[1];

			if($val[1] == 0){ 
				$data[$i][6]  = 0;
			}else {
				$data[$i][6]  = number_format($val[2] / $val[1],2);
			}	

			$i ++;
		}		
		return $data;
	}
	function DefineQuery() {
		global $db;
		$query = "SELECT FROM_UNIXTIME(timestamp, '%d-%b-%Y %a') AS days, COUNT(distinct sessionid) as visits, COUNT(*) as requests, (COUNT(*) - SUM(IF(crawl='0','0',1))) AS viewed, SUM(IF(crawl='0','0',1)) AS crawled, COUNT(distinct visitorid) as visitors FROM ".$this->profile->tablename_merge." WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." GROUP BY days ORDER BY timestamp";

		return $query;
	}
}
?>