<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
$reports["_AD_BLOCKERS"] = Array(
	"ClassName" => "AdBlockers", 
	"Category" => "_ADVERTISING", 	
	"Options" => "daterangeField,profileselector,columnSelector,trafficsource,displaymode",
	"Filename" => "ad_blockers",
	"Distribution" => "Standard",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
);

class AdBlockers extends Report {
	
	function Settings(){
		
		$this->DefaultDisplay = "pie";
		$this->DisplayModes = "table,linechart,pie,areachart";
		$this->allowDateFormat = false;
		$this->columnDefinitions[] = array("Label" => "_DATE");		
		$this->columnDefinitions[] = array("Label" => "_AD_BLOCKERS_ACTIVE", "bchart" => true);
		$this->columnDefinitions[] = array("Label" => "_NOT_ACTIVE", "bchart" => false);
		$this->sort = false;

		global $profile;
		include "includes/codespace.php";
		$this->help = _AD_BLOCKERS_DESC.'<br><br>'._GIFDATA_REPORT_DESC."<br><br>"._REPORT_NEEDS_GIFDATA." "._TAG_LOGFILES."<br><br>".$codespace2;

		$this->gifid = getID("/logaholic.gif","urls");

		if ($this->gifid == false) { $this->gifid = 'false'; return false; }

	}

	function DefineQuery() {
		global $db;
		// get logaholic.gif id
		if ($this->gifid == 'false') { return false; }
		
		$q = subsetDataToSourceID("select distinct visitorid, timestamp, lg_getparam('adblock',u.params) as adblock from {$this->profile->tablename_gifdata} as a, {$this->profile->tablename_urlparams} as u where a.params=u.id and a.url={$this->gifid} and a.timestamp >= ". $db->quote($this->from) ." AND a.timestamp <= ". $db->quote($this->to)." and u.params like '%adblock=%'", $this->trafficsource);

		$q = "select FROM_UNIXTIME(timestamp, '%d-%b-%Y %a') AS days, SUM(IF(adblock='Yes',1,0)) as blocked, count(*)-SUM(IF(adblock='Yes',1,0)) as noblock from ($q) as a group by days order by timestamp";

		$this->applytrafficsource = false;
		return $q;
	}	
	
	function GetReportData() {
		$data = parent::GetReportData();

		if (empty($data)) {			
			return $data;
		}
		
		if ($this->displaymode=="pie") {
			$newdata = array();
			$newdata[0][0] = _AD_BLOCKERS_ACTIVE;
			$newdata[1][0] = _NOT_ACTIVE;
			$newdata[0][1] = 0;
			$newdata[1][1] = 0;			
			foreach($data as $k => $v) {				
				$newdata[0][1] += $v[1];
				$newdata[1][1] += $v[2];
			}			
			return $newdata;

		}
		return $data;
	}
	
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>