<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
// PHPLOCKITOPT NOENCODE
@ignore_user_abort(TRUE); 
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 

if (!isset($_GET['debug'])) {
    error_reporting(0);
} else {
    error_reporting(E_ALL);
}

if (!isset($_GET['conf'])) {
    exit();
} else {
    $confname=$_GET['conf'];   
}

$trackermode=1;

require_once("files/global.php");
require_once("includes/table_definitions.php");
require_once("components/adodb/adodb.inc.php");

if (function_exists("mysqli_connect")) {
	$db = ADONewConnection("mysqli");
} else {
	$db = ADONewConnection("mysql");
}
$db->Connect($mysqlserver,$mysqluname,$mysqlpw, $DatabaseName);

if (isset($mysqlprefix) && !empty($mysqlprefix)) {
	$check = str_replace($mysqlprefix, "", $confname);	
} else {
	$check = $confname;
}

if (substr($check, 0, 1) == "p" && is_numeric(substr($check, 1))) {
	$tn = $mysqlprefix."p".(intval(substr($check, 1)));
} else {
	$q = "select tablename from ".TBL_PROFILES." where profilename = ? ";
	$a = $db->Execute($q, array($confname));
	if ($r = $a->fetchRow()) {
		$tn = $r[0];
	} else {
		die(); # no tablename, die here
	}
}

# set up our tablenames
$tablename=$tn."_trackerlog";

if ($trackermode==1) {
    
	$ipnumber = $db->escape($_SERVER["REMOTE_ADDR"]);
	$dateline=date("d/M/Y:H:i:s",time());	
	
	# make the file name we want to log a request for (the referrer of trackpage is the page it was called from, so that is the url we want)
	if(!empty($_SERVER["HTTP_REFERER"])) {
		$path = $_SERVER["HTTP_REFERER"];
	} else {
		$path = "";
	}
    $path = explode ("//", $path);
    $path = @$path[1];
    $url = strstr($path, "/");
    if (empty($url)) {
        $url="/";
    }
		
	$url = $db->escape(strip_tags($url));    
       
	$referrer="-";
    	
	$useragent= $db->escape($_SERVER['HTTP_USER_AGENT']);
	
	$Logaholic_VID = "";
		
	$docTitle="";    
    
	//construct a log line
    $logline="$ipnumber - - [$dateline +0200] \"GET $url HTTP/1.1\" 200 0 \"$referrer\" \"$useragent\" \"$Logaholic_VID docTitle=$docTitle;\"";
    $q = "insert into `$tablename` (logline) values ( ? )";
	$db->Execute($q, array($logline));
    if (isset($_GET['debug'])) {
        echo mysql_error();
        echo "insert into $tablename (logline) values (\"$logline\")";
    }
    // echo transparent pixel
    header("Content-type: image/png");
    echo base64_decode("iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAACXBIWXMAAAsTAAALEwEAmpwYAAAABGdBTUEAALGOfPtRkwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAAAEElEQVR42mL4//8/A0CAAQAI/AL+26JNFgAAAABJRU5ErkJggg==");
}
?>