<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
$dont_close_session = true;
include_once "../common.inc.php";
AccessCheck();

# check if we can enrich our data based on what we got from stripe
if (empty($session->userinfo["name"])) {
	$q = "UPDATE ".TBL_USERS." SET name = ? WHERE username = ?";
	$db->Execute($q, array($_POST['name'], $session->username));	
}
if (empty($session->userinfo["email"])) {
	$q = "UPDATE ".TBL_USERS." SET email = ? WHERE username = ?";
	$db->Execute($q, array($_POST['email'], $session->username));	
}
//$_POST['current_period_end'] = time();

# store the charge details
if ($session->isAdmin()) {
	// we're gonna make a license file for all users and profiles
	setGlobalSetting("SoftwareSubscription", json_encode($_POST));
	echo "Congratulations, this installation is now subscribed to:<h3>".$_POST['plan']."</h3>";
	echo "<div style='float:left;width:150px'><i class='fa fa-check'></i> Current period end:</div>".date("Y-m-d",$_POST['current_period_end'])."<br>";
	echo "<div style='float:left;width:150px'><i class='fa fa-check'></i> Pageviews:</div>".$_POST['pageviews']."<br>";
	//echo "Pageviews:".$_POST['pageviews']."<br>";
	echo "<br>All Logaholic reports and features have now been enabled for all your users and profiles";
} else {
	//we're gonna store this in the users info
	$session->metadata["user_ss"] = $_POST;
	//mb_convert_encoding($string,'UTF-8','UTF-8');
	foreach($session->metadata["user_ss"] as $k =>$v) {
		if (function_exists('mb_convert_encoding')) {
			$session->metadata["user_ss"][$k]=mb_convert_encoding($session->metadata["user_ss"][$k],'UTF-8','UTF-8');
		}
	}	
	$metadata = json_encode($session->metadata);
	$q = "UPDATE ".TBL_USERS." SET metadata = ? WHERE username = ?";
	$db->Execute($q, array($metadata, $session->username));
	
	echo "Congratulations, user <strong>{$session->username}</strong> is now subscribed to:<h3>".$_POST['plan']."</h3>";
	echo "<div style='float:left;width:150px'><i class='fa fa-check'></i> Current period end:</div>".date("Y-m-d",$_POST['current_period_end'])."<br>";
	echo "<div style='float:left;width:150px'><i class='fa fa-check'></i> Pageviews:</div>".$_POST['pageviews']."<br>";
	//echo "Pageviews:".$_POST['pageviews']."<br>";
	echo "<br>All Logaholic reports and features have now been enabled in your profiles";
}

unset($_SESSION['userinfo']);
session_write_close();
?>