<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
$accessControl = array("Admin" => true);
require_once '../../AccessControl.php';

# check if subscription component is being used by checking if the table exists.
@$results = $db->Execute("SELECT * FROM ".TBL_SUBSCRIPTIONS."");
$subscriptions = array();
if($results != false){
    while($row = $results->fetchRow()){
        $vals = json_decode($row["value"],true);

        $subscriptions[$row["id"]]['name'] = $row["name"];
        $subscriptions[$row["id"]]['price'] = 0;
        if(!empty($vals["Price"])){
            $subscriptions[$row["id"]]['price'] = $vals["Price"]['value'];  
        }
    }
}
?>
						<div class="response">

							<div class="callout-danger-template callout callout-danger" style="display:none;">								
								<h4></h4>								
							</div>

							<div class="callout-success-template callout callout-success" style="display:none;">								
								<h4></h4>								
							</div>

						</div>

                        <div class="box box-solid box-primary signup">
                            <div class="box-header">
                                <h3 class="box-title"><?php echo _SIGNUP_PAGE; ?></h3>
                                
                            </div><!-- /.box-header -->

                            <div class="box-body table-responsive">

                                
                                <div class="btn-group toggle">                                  
                                    <button class="btn btn-default disable_this" type="submit"><?php echo _DISABLE; ?></button>
                                    <button class="btn btn-default enable_this" type="submit"><?php echo _ENABLE; ?></button>
                                </div>
                                

                                <div style="clear:both">
                                    &nbsp;<br />&nbsp;
                                </div>

                                <div class="alert alert-info enable" style="display:none;">
                                    <i class="fa fa-info"></i> 
                                    <?php echo _ENABLE_SIGNUP_PAGE; ?>                                 
                                   
                                </div>
                                
                                <div class="alert alert-info disable" style="display:none;">
                                    <i class="fa fa-info"></i>
                                    <?php echo str_replace("%X%", "<br/><a href='signup.php'>", _DISABLE_SIGNUP_PAGE)  ."</a>"; ?>
                                </div>

                            </div><!-- /.box-body -->
                        </div><!-- /.box -->   

                        <div class="box box-solid box-primary signupsettings">
                            <div class="box-header">
                                <h3 class="box-title"><?php echo _DEFAULT_PERMISSIONS; ?></h3>                                
                            </div><!-- /.box-header -->
                            <div class="box-body table-responsive">
                                <form id="signupSettingsForm">
                                    <div class="form-group">
                                        <label><?php echo _PROFILE_LIMIT . " (0 - ". _LIMIT_PROFILES ." )"; ?></label>
                                        <input class="form-control" size="40" type="text" name="profileLimit" />
                                    </div>

                                    <?php                   
                                    # check if there actually are subscriptions in the table. If so then add the subscription option to the form.
                                    if(!empty($subscriptions)){ 
                                        echo  "<div class='form-group' data-help='". _SUBSCRIPTION_EXPLAIN ."' >";
                                            echo "<label>". _SUBSCRIPTION ."</label>";
                                            # add dropdown option for selecting a subscription.
                                            echo "<select class=\"form-control\"  name='userSubscription'>";
                                            echo "<option value=''>-----". _NONE ."-----</option>";
                                            foreach($subscriptions as $subid => $sub){
                                                $selected = "";
                                                if($userdata["subscriptionid"] == $subid){
                                                    $selected = "selected='selected'";
                                                }
                                                echo "<option $selected value='{$subid}'>{$sub['name']}</option>";
                                            }
                                            echo "</select>";
                                        echo "</div>";
                                    }       
                                    ?>

                                    <div class="form-group">
                                        <label><?php echo _PERMISSIONS; ?></label>
                                        <div class="permissions-box">
                                            <div class="checkbox" data-help="<?php echo _CAN_UPDATE_LOGS_EXPLAIN; ?>" >
                                                <label><input value="1" type="checkbox" name="accessUpdateLogs" ><?php echo _CAN_UPDATE_LOGS; ?></label>
                                            </div>

                                            <div class="checkbox" data-help="<?php echo _CAN_ADD_PROFILES; ?>" >
                                                <label><input value="1" type="checkbox" name="accessAddProfile" ><?php echo _CAN_ADD_PROFILES; ?></label>
                                            </div>

                                            <div class="checkbox" data-help="<?php echo _CAN_EDIT_PROFILES_EXPLAIN; ?>" >
                                                <label><input value="1" type="checkbox" name="accessEditProfile" ><?php echo _CAN_EDIT_PROFILES; ?></label>
                                            </div>
                                            
                                            <div class="checkbox" data-help="<?php echo _CAN_CHANGE_ACCOUNT_INFO_EXPLAIN; ?>" >
                                                <label><input value="1" type="checkbox" name="changeAccountInfo" ><?php echo _CAN_CHANGE_ACCOUNT_INFO; ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo _DATA_COLLECTION_METHOD; ?></label>
                                        <div class="permissions-box">
                                            <div class="checkbox">
                                                <label><input value="1" type="checkbox" name="trackermode_0" ><?php echo _LOG_ANALYSIS_LOCAL; ?></label>
                                            </div>
                                            <div class="checkbox">
                                                <label><input value="1" type="checkbox" name="trackermode_1" ><?php echo _JS_BASED_TRACKING; ?></label>
                                            </div>
                                            <div class="checkbox">
                                                <label><input value="1" type="checkbox" name="trackermode_2" ><?php echo _LOG_ANALYSIS_FTP; ?></label>
                                            </div>
                                            <div class="checkbox">
                                                <label><input value="1" type="checkbox" name="trackermode_3" ><?php echo _UPLOAD_FILES; ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    <button class='btn btn-primary save-signupsettings'><?php echo _SAVE; ?></button>
                                </form>


                                <div style="clear:both;"><br/></div>
                                <div class="alert alert-info" ><i class="fa fa-info"></i><?php echo _DEFAULT_PERMISSIONS_INFO; ?></div>
                            </div>
                        </div>	