<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
$accessControl = array("Admin" => true);
require_once '../../AccessControl.php';

$apipath = getGlobalSetting("CloudManagerAPI","");
$apicall = getGlobalSetting("CloudManagerCall","");


function CheckifInstalled() {
	global $apipath;

	

	if (empty($apipath)) {
		return false;
	}
	
	if(!CheckIfTableExists("_cloud_servers")){
		return false;
	}

	if(!CheckIfTableExists("_cloud_users")){
		return false;
	}

	if(!CheckIfTableExists("_cloud_profiles")){
		return false;
	}

	if(!CheckIfTableExists("_cloud_subscriptions")){
		return false;
	}

	if(!CheckIfTableExists(TBL__SUBSCRIPTIONS_USERLOG)){
		return false;
	}
	return true;
}


if (isset($_REQUEST['checkapipath'])) {
	if(file_exists($_REQUEST['checkapipath'] . "/cinstall.php")) {
		echo '{ "Status": "Success", "Message": "'. _CLUSTER_MANAGER_FOUND .'", "Installed": "'.CheckifInstalled().'" }';
	} else {
		echo '{ "Status": "Error", "Message": "'. _CLUSTER_MANAGER_NOT_FOUND .'" }';	
	}
}

if(!empty($_POST["uninstall"])){
	# uninstall !!
	setGlobalSetting("CloudManagerAPI","");
	setGlobalSetting("CloudManagerCall","");
	echo '{ "Status": "Success", "Message": "'. _CLUSTER_MANAGER_DEACTIVATED .'" }';
}

if(!empty($_POST["cloudapipath"])){
	$apipath = $_POST["cloudapipath"];
	// not sure oif this one is needed, but just setting it to the apipath for now
	$apicall = $_POST["cloudapipath"];
	
	# user has set an path lets check if the path is correct
	if(file_exists($apipath . "/cinstall.php")){
		# Correct path lets install
		setGlobalSetting("CloudManagerAPI",$apipath);
		setGlobalSetting("CloudManagerCall",$apicall);
		include_once $apipath . "/cinstall.php";		
		
	} else {
		# ask again.. path incorrect
		echo '{ "Status": "Error", "Message": "'. _CLUSTER_MANAGER_NOT_FOUND .'" }';		
	}
}
