/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 

var plots = [];//new Array();
function plotGraph (graphcontainer, graphdata, actionmenu_type, graphOptions, legendOrientation, legendDisplay) {
	/**
		This function will create a window for reports with all needed attributes.
		
		Arguments:
		- graphcontainer
			The ID of the container of the graph we're about to create.
		- graphdata
			The data we use to plot our graph.
			
		Additional Info:
			Here'll be a list of built-in JQplot Events:
			jqplotClick
			jqplotDblClick
			jqplotMouseDown
			jqplotMouseUp
			jqplotMouseMove
			jqplotMouseEnter
			jqplotMouseLeave
			
			Add the event like this:
			$.jqplot.eventListenerHooks.push(['jqplotClick', FUNCTION);
			
			Please note that this event has to be initialized BEFORE the graph.
	**/
	
	plots; // This is a global variable, initialized at the top of this file.
	
	var seriedata = []; // This array will contain all data about the series/plots, such as lines, bars, etc.
	var graphtype = []; // For each dataset, we'll have an individual type.
	var graphlabel = []; // For each dataset, we'll have an individual label.
	var plotdata = []; // This will contain all the data we need to plot a graph.
	var new_xaxis_labels = []; // This array will contain the X axis labels to be used in the graph.
	graphdata[0].shift();
	var xaxis_labels = graphdata[0]; // This array will contain the X axis labels to be used in the graph, before they are converted correctly.
	var yaxis_labels = []; // This array will contain the Y axis labels to be used in the graph.
	
	if(legendOrientation == undefined) {
		legendOrientation = 'south_legend'; // can be either 'south_legend', 'east_legend' or 'west_legend'
	}
	if(legendDisplay == undefined) {
		legendDisplay = 'block'; // can be either 'block', 'inline' or 'none'
	}
	
	/* This barf is to create padding between the X axis (and allies) labels. */
	for(var i = 0; i < xaxis_labels.length; i++) {
		new_xaxis_labels.push(xaxis_labels[i]);
	}
	
	var barcount = 0;
	var linecount = 0;
	var maxNumbers = [];
	var graphtrend = {};
	
	for(i = 1; i < graphdata.length; i++) {
		graphlabel[i] = graphdata[i][0];
		
		if(graphlabel[i].split("|")[2] != undefined) {
			graphtrend[i] = true;
		} else {
			graphtrend[i] = false;
		}
		graphtype[i] = graphlabel[i].split("|")[1];
		graphlabel[i] = graphlabel[i].split("|")[0];
		graphdata[i].shift();
		
		for(var array_entry in graphdata[i]) {
			if(is_numeric(graphdata[i][array_entry])) {
				if(graphdata[i][array_entry] == " ") {
					graphdata[i][array_entry] = 0;
				} else {
					graphdata[i][array_entry] = parseFloat(graphdata[i][array_entry]);
				}
			}
		}
		
		/* We'll count the graphtype and prepare our datasets. */
		if(graphtype[i] == 'bar') {
			barcount++;
			seriedata.push({
				label: graphlabel[i], // This is the type of data (Visitors, for example).
				renderer: $.jqplot.BarRenderer,
				trendline: { show: graphtrend[i] }
			});
		} else if(graphtype[i] == 'line') {
			linecount++;
			seriedata.push({
				label: graphlabel[i], // This is the type of data (Visitors, for example).
				renderer: $.jqplot.LineRenderer
			});
		} else if(graphtype[i] == 'stackedbar') {
			barcount++;
			seriedata.push({
				label: graphlabel[i], // This is the type of data (Visitors, for example).
				renderer: $.jqplot.BarRenderer,
				trendline: { show: graphtrend[i] }
			});
		} else {
			seriedata.push({
				label: graphlabel[i], // This is the type of data (Visitors, for example).
			});
		}
		
		maxNumbers.push(maxInArray(graphdata[i]));
		plotdata.push(graphdata[i]);
	}
	
	// We don't want values like 32752.43 in our Y axis, so we'll calculate our own Y axis.
	yaxis_labels = [];
	for(var c = 0; c <= 5; c++) {
		var maxNum = maxInArray(maxNumbers);
		
		var num = (maxNum * (c / 4.9));
		if(maxNum < 10) {
			num = parseFloat(num.toFixed(2));
		}
		yaxis_labels.push(num);
	}
	
	for(var serie_id in seriedata) {
		if(graphOptions.series[serie_id] != undefined) {
			for(var serie_key in seriedata[serie_id]) {
				if(graphOptions.series[serie_id][serie_key] == undefined) {
					graphOptions.series[serie_id][serie_key] = seriedata[serie_id][serie_key];
				}
			}
		} else {
			graphOptions.series[serie_id] = seriedata[serie_id];
		}
	}
	
	if(graphOptions.axes.xaxis.ticks.length == 0) {
		graphOptions.axes.xaxis.ticks = new_xaxis_labels;
	}
	
	if(graphOptions.axes.yaxis.ticks) {
		//graphOptions.axes.yaxis.ticks = yaxis_labels;
	} else {
		graphOptions.axes.yaxis.ticks = yaxis_labels;
	}
	
	applyGraphTooltip(graphcontainer);
	
	if(barcount == 0 && linecount > 0) {
		var graphplotted = 'line';
		plots[graphcontainer] = graph.lineChart(graphcontainer, plotdata, graphOptions);
	} else if(linecount == 0 && barcount > 0) {
		var graphplotted = 'bar';
		
		plots[graphcontainer] = graph.barChart(graphcontainer, plotdata, graphOptions);
	} else if(barcount > 0 && linecount > 0) {
		var graphplotted = 'barline';
		if(graphOptions.stackSeries == true) {
			var yaxis_base = 0;
			for (var i = 0; i < maxNumbers.length; i++) {
					
				if(graphOptions.series[i]['disableStack']==true) { continue; } 
				yaxis_base = yaxis_base + maxNumbers[i];
			}
			
			yaxis_labels = [];
			for(var c = 0; c <= 5; c++) {
				var num = (yaxis_base * (c / 4.9));
				if(yaxis_base < 10) {
					num = parseFloat(num.toFixed(2));
				}
				yaxis_labels.push(num);
			}
		
			if(graphOptions.axes.yaxis.ticks) {
				graphOptions.axes.yaxis.ticks = yaxis_labels;
			}
			if(graphOptions.axes.y2axis) {
				graphOptions.axes.y2axis.ticks = yaxis_labels;
			}
		}			
		plots[graphcontainer] = graph.barLineChart(graphcontainer, plotdata, graphOptions);
	} else {
		var graphplotted = 'area';
		 
		var yaxis_base = 0;
		for (var i = 0; i < maxNumbers.length; i++) {
			yaxis_base = yaxis_base + maxNumbers[i];
		}
		
		yaxis_labels = [];
		for(var c = 0; c <= 5; c++) {
			var num = (yaxis_base * (c / 4.9));
			if(yaxis_base < 10) {
				num = parseFloat(num.toFixed(2));
			}
			yaxis_labels.push(num);
		}
	
		if(graphOptions.axes.yaxis.ticks) {
			graphOptions.axes.yaxis.ticks = yaxis_labels;
		} 
		plots[graphcontainer] = graph.areaChart(graphcontainer, plotdata, graphOptions);
	}
	
	if($("#" + graphcontainer).find(".jqplot-axis.jqplot-xaxis").find(".jqplot-xaxis-tick").length > 20) {
		var i = 0;
		$("#" + graphcontainer).find(".jqplot-axis.jqplot-xaxis").find(".jqplot-xaxis-tick").each(function() {
			
			if((i % Math.ceil($("#" + graphcontainer).find(".jqplot-axis.jqplot-xaxis").find(".jqplot-xaxis-tick").length / 10)) != 0) {
				$(this).css('display', 'none');
			}
			
			i++;
		});
	}
	
	$("#" + graphcontainer).closest(".graph_area").append("<div class='graph_tooltip'></div>");
}

/** Here we'll define all types of JQplot graphs available in Logaholic; Area, Line, Bar, Bar & Line **/
graph = {

	areaChart: function (graphContainer, data, graphOptions) {
		graphOptions.seriesDefaults.renderer = $.jqplot.LineRenderer;
		graphOptions.seriesDefaults.markerRenderer = $.jqplot.MarkerRenderer;
		graphOptions.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
		graphOptions.axes.xaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.labelRenderer = $.jqplot.CanvasAxisLabelRenderer;
		
		return $.jqplot(graphContainer, data, graphOptions);
	},
	
	barChart: function (graphContainer, data, graphOptions) {
		graphOptions.seriesDefaults.renderer = $.jqplot.BarRenderer;
		graphOptions.seriesDefaults.markerRenderer = $.jqplot.MarkerRenderer;
		graphOptions.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
		graphOptions.axes.xaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.labelRenderer = $.jqplot.CanvasAxisLabelRenderer;
		
		return $.jqplot(graphContainer, data, graphOptions);
	},
	
	barLineChart: function (graphContainer, data, graphOptions) {
		graphOptions.seriesDefaults.markerRenderer = $.jqplot.MarkerRenderer;
		graphOptions.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
		graphOptions.axes.xaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.labelRenderer = $.jqplot.CanvasAxisLabelRenderer;
		
		return $.jqplot(graphContainer, data, graphOptions);
	},
	
	lineChart: function (graphContainer, data, graphOptions) {
		graphOptions.seriesDefaults.renderer = $.jqplot.LineRenderer;
		graphOptions.seriesDefaults.markerRenderer = $.jqplot.MarkerRenderer;
		graphOptions.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
		graphOptions.axes.xaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		graphOptions.axes.yaxis.labelRenderer = $.jqplot.CanvasAxisLabelRenderer;
		graphOptions.axes.yaxis.tickRenderer = $.jqplot.CanvasAxisTickRenderer;
		
		return $.jqplot(graphContainer, data, graphOptions);
	}
};

