<?php
function new_section($body,$prop=[]) {
	if (!$body) {
		return;
	}
	global $jml_sections;
	if (!$prop['platforms']) {
		$prop['platforms'] = ['web','app'];
	}
	if (!is_array($jml_sections)) {
		$jml_sections = [];
	}
	if ((is_app() && in_array('app',$prop['platforms']) ) || (!is_app() && in_array('web',$prop['platforms']) ) ) {
		$jml_sections[] = array_merge(['body'=>$body,'title'=>$prop['title'], 'key'=>md5(serialize($body)) ],$prop);
	}
}

function new_header($body,$prop=[]) {
	if (!$body) {
		return;
	}
	global $jml_header_items;
	if (!$prop['platforms']) {
		$prop['platforms'] = ['web','app'];
	}
	if (!is_array($jml_header_items)) {
		$jml_header_items = [];
	}
	if ((is_app() && in_array('app',$prop['platforms']) ) || (!is_app() && in_array('web',$prop['platforms']) ) ) {
		$jml_header_items[] = array_merge(['body'=>$body],$prop);
	}
}


function render($prop=[]) {
	global $jml_sections, $jml_header_items;
	if (!is_array($jml_sections)) {
		$jml_sections = [['body'=>text('none') ]];
	}
	if (!is_array($jml_header_items)) {
		$jml_header_items = [];
	}
	/*
	if (is_map($sections)) {
		$sections = [$sections];
	}
	*/
	if (is_app()) {
		//echo json_encode(['status'=>'ok', 'jml'=>$sections[0],'prop'=>$prop]);exit; 
		if ($_GET['preview']) {
			print_r(['status'=>'ok', 'header'=>$jml_header_items, 'prop'=>$prop, 'sections'=>$jml_sections]);exit;
		}
		echo json_encode(['status'=>'ok', 'header'=>$jml_header_items,'prop'=>$prop, 'sections'=>$jml_sections]);
		exit;
	}
	else {
		if ($_GET['preview']) {
			print_r($jml_sections);exit;
		}
		load_tpl();
	}
}

function render_err($msg) {
	render(center(text($msg)));
}

function status_form($page=[]) {
	if (is_app()) {
		return false;
		//return ['type'=>'status_form'];
	}
	return stream_form($page);
}

function center($child) {
	if (is_app()) {
		return ['type'=>'center', 'child'=>$child];
	}
	return '<div style="display:flex;align-items:center;justify-content:center">'.$child.'</div>';
}

function profile_header($owner) {
	if (is_app()) {
		return ['type'=>'profile_header', 'owner'=>$owner];
	}
}

function user_link($user, $prop=[]) {
	$size = $prop['size'] ? $prop['size'] : null;
	return clickable(
		row_center([
			avatar($user, $size),
			Text($user['fullname'])
		]),
		['uri'=>'u/'.$user['username'], 'title'=>$user['fullname']]
	);
}
function page_link($page) {
	return clickable(
		row_center([
			avatar($page),
			Text($page['name'])
		]),
		['uri'=>$page['type'].'/'.$page['uri'], 'title'=>$page['name']]
	);
}

function avatar($prop,$size=null) {
	// page_name,page_uri,page_logo
	if (!$prop['src']) {
		if ($prop['avatar']) {
			$prop['src'] = $prop['avatar'];
		}
		elseif ($prop['logo']) {
			$prop['src'] = $prop['logo'];
		}
		elseif ($prop['page_logo']) {
			$prop['src'] = $prop['logo'];
		}
	}
	$prop['src'] = correct_avatar_path($prop['src']);
	if (!$prop['name']) {
		if ($prop['fullname']) {
			$prop['name'] = $prop['fullname'];
		}
		else if ($prop['page_name']) {
			$prop['name'] = $prop['page_name'];
		}
	}
	if ($size) {
		$prop['size'] = $size;
	}
	if (is_app()) {
		if ($prop['size'] && !is_numeric($prop['size'])) {
			if ($prop['size'] == 'small') {
				$prop['size'] = 35;
			}
			elseif ($prop['size'] == 'large') {
				$prop['size'] = 100;
			}
			else {
				$prop['size'] = 50;
			}
		}
		return ['type'=>'avatar', 'prop'=>$prop];
	}
	return avatar_html(['src'=>$prop['src'], 'name'=>$prop['name'],'size'=>$prop['size'] ]);
}

function tab_menu($tabs) {
	if (is_app()) {
		return ['type'=>'tabs','tabs'=>$tabs];
	}
}
function line_break() {
	if (is_app()) {
		return ['type'=>'line_break'];
	}
	return '<div style="background:#eee;height:1px;margin:10px"></div>';
}

function form($children=[], $prop=[]) {
	if (is_app()) {
		return ['type'=>'form','children'=>$children, 'prop'=>$prop];
	}
	return '<form action="'.$prop['action'].'" class="ajaxform" method="post">'.implode($children).'</form>';
}


function input($prop=[]) {
	if (!$prop['type']) {
		$prop['type'] = 'text';
	}
	if (is_app()) {
		return ['type'=>'input', 'prop'=>$prop];
	}
	$placeholder = $prop['placeholder'] ? 'placeholder="'.h($prop['placeholder']).'"' : '';
	if ($prop['type'] == 'submit') {
		return '<div class="form-group">
	    <input type="submit" class="btn btn-primary" value="'.h($prop['title']).'" />
	  	</div>';
	}
	elseif ($prop['type'] == 'select') {
		$output = '<div class="form-group">
			<label>'.h($prop['label']).'</label>
			<div>
			<select name="'.$prop['name'].'" class="form-control">
			';
			foreach ($prop['options'] as $option) {
				if ($option['value'] == $prop['value']) {
					$selected = 'selected';
				}
				else {
					$selected = '';
				}
				$output .= '<option value="'.h($option['value']).'" '.$selected.'>'.h($option['label']).'</option> ';
			}
		$output .= '</select></div><span>'.h($prop['placeholder']).'</span></div>';
		return $output;
	}
	elseif ($prop['type'] == 'radio') {
		$output = '<div class="form-group">
			<label>'.h($prop['label']).'</label>
			';
			foreach ($prop['options'] as $option) {
				if ($prop['value'] == $option['value']) {
					$checked = 'checked';
				}
				else {
					$checked = '';
				}
				$output .= '<div class="form-check"><label><input type="radio" name="'.$prop['name'].'" value="'.h($option['value']).'" '.$checked.'> '.h($option['label']).'</label></div>';
			}
		$output .= '<span>'.h($prop['placeholder']).'</span>
		</div>';
		return $output;
	}
	elseif ($prop['type'] == 'textarea') {
		return '<div class="form-group"><label>'.h(($prop['label']? $prop['label']:$prop['placeholder'] )).'</label>
		    <textarea rows="7" class="form-control" name="'.$prop['name'].'" '.$placeholder.'>'.h($prop['value']).'</textarea>
		  	</div>';
	}
	elseif ($prop['type'] == 'richtextarea') {
		return '<div class="form-group"><label>'.h(($prop['label']? $prop['label']:$prop['placeholder'] )).'</label>
		    <div  class="richtextarea" >'.$prop['value'].'</div>
		    
		  	</div>';
	}
	elseif ($prop['type'] == 'checkbox') {
		$checkbox_checked = $prop['checked'] ? 'checked':'';
		return '<label><input type="checkbox" name="'.$prop['name'].'" value="'.h($prop['value']).'" '.$checkbox_checked.' /> '.h($prop['label']).'</label>';
	}
	elseif ($prop['type'] == 'image') {
		$photos = '';
		if (is_array($prop['photos']) && count($prop['photos']) ) {
			foreach ($prop['photos'] as $p) {
				$p['thumb'] = media_path($p['thumb']);
				$photos .= '<div class="img_pre" token="'.$p['uid'].'_'.$p['id'].'"><img src="'.$p['thumb'].'" /><a href=\"#\" class="img_pre_remove"><i class="fa fa-remove"></i> Remove</a></div>';
			}
		}
		$maxnum = $prop['max'] ? $prop['max'] : 10;
		return '<div class="jcow_share_box" style="margin-bottom:10px;padding:5px;border:#ccc 1px solid;display:flex;align-items:center">
		<div style="padding:5px">'.h($prop['label']).'</div>
			<div class="img_preview">'.$photos.'</div>
			<div style="display:none"><input type="file" class="jcow_sf_img" accept="image/*" multiple  /></div>
			<a href="#" class="jcow_sf_img_btn att_btn" maxnum='.$maxnum.'><i class="fa fa-camera fa-lg"></i> '.t('Image').'</a>
			</div>';
	}
	elseif ($prop['type'] == 'hidden') {
		return '<input  name="'.$prop['name'].'" type="hidden" value="'.h($prop['value']).'" />';
	}
	else { // 'text'
		if ($prop['type'] == 'email') {
			$prop['type'] = '';
		}
		if ($prop['focus']) {
			$focus_js = '<script>
			$(function() {
				$("input[name=\''.$prop['name'].'\']").focus();
				})
			</script>';
		}
		$description = $prop['description'] ? '<div class="sub">'.$prop['description'].'</div>' : '';
		return '<div class="form-group"><label>'.h(($prop['label']? $prop['label']:$prop['placeholder'] )).'</label>
	    <input class="form-control" name="'.$prop['name'].'" value="'.h($prop['value']).'" type="'.$prop['type'].'" '.$placeholder.' />'.$description.$focus_js.'
	  	</div>';
	  }
}

function status($text,$timeline = 0) {
	if (is_app()) {
		//return ['type'=>'text','child'=>$text];
		return text($text,['style'=>style(['font-size'=>'18px'])]);
	}
	//if ($timeline > 1603440800) {
		$text = parseurl(h($text));
		preg_match_all("/@([0-9a-z_]+)/s",$text,$out);
		if(count($out[1])>0) {
			$from = $to = array();
			foreach ($out[1] as $username) {
				if (strlen($username)>3 && strlen($username)<30 && !in_array('@'.$username,$from)) { // && $row['id'] != $uid
					$from[] = '@'.$username;
					$to[] = '<a href="'.url('u/'.$username).'" rel="nofollow">@'.$username.'</a>';
				}
			}
			if (count($from)>0) {
				$text = str_replace($from,$to,$text);
			}
		}
		$text = parse_tags($text);
	//}
	return '<span>'.nl2br($text).'</span>';
}

function markdown($text, $prop=[]) {
	if (is_app()) {
		return ['type'=>'markdown','child'=>$text];
	}
	return Parsedown::instance()->setBreaksEnabled(true)->setMarkupEscaped(true)->text($text);
}

function text($text, $prop=[]) {
	if ($prop['is_sub']) {
		$prop['style'] = style(['font-size'=>'12px','color'=>'#999999']);
	}
	if (is_app()) {
		return ['type'=>'text','child'=>$text, 'prop'=>$prop];
	}
	$classes = [];
	if ($prop['size']) {
		$classes[] = 'jcow-text-'.$prop['size'];
	}
	if ($prop['type']) {
		$classes[] = 'jcow-text-'.$prop['type'];
	}
	if ($prop['style']) {

	}
	$style_sheet = $prop['style'] ? 'style="'.$prop['style'].'"':'';
	return '<div '.$style_sheet.' class="jcow-text '.implode(' ',$classes).'">'.parseurl(h($text))."</div>\n";
}

function text_link($text, $prop) {
	if (!$prop['color']) {
		$prop['color'] = '#276aa8';
	}
	return clickable(
		text($text, ['style'=>
			style(['color'=>$prop['color'],'text-decoration'=>'underline'])
		]),
		['uri'=>$prop['uri']]
	);
}

function clickable($children, $prop=[]) {
	if (is_app()) {
		$prop['clickable'] = true;
		return ['type'=>'link', 'children'=>$children, 'prop'=>$prop];
	}
	else {
		$attrs = [];
		if (is_array($prop['attr'])) {
			foreach ($prop['attr'] as $k=>$v) {
				$attrs[] = $k.'="'.$v.'"';
			}
		}
		return '<a href="'.uri($prop['uri'],$prop['q']).'" '.implode(' ',$attrs).'>'.$children.'</a>';
	}
}

function button($prop=[]) {
	global $ubase;
	if (!is_array($prop)) $prop = [];
	if ($prop['post_title']) {
		$prop['postTitle'] = $prop['post_title'];
	}
	if (is_app()) {
		return ['type'=>'button','prop'=>$prop];
	}
	if ($prop['icon_name']) {
		$icon = '<i class="fa fa-'.$prop['icon_name'].'"></i>&nbsp;';
	}
	
	$post_class = $prop['disabled'] ? 'jcow-btn-disabled' : 'jcow-btn-post';
	switch($prop['color_type']) {
		case 'plain':
			$color_type = 'jcow-btn-plain';
			break;
		case 'dark':
			$color_type = 'jcow-btn-dark';
			break;
		default:
			$color_type = 'jcow-btn-default';
	}

	$title = h($prop['title']);
	switch($prop['type']) {
		case 'link':
			$prop['uri'] = uri($prop['uri'],$prop['q']);
			return '<a class="jcow-btn '.$color_type.'" href="'.$prop['uri'].'">'.$icon.$title.'</a>';
			break;
		case 'dropdown':
			return '<div >
						<a href="#" class="jcow-btn '.$color_type.'" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false" >'.$icon.$title.'</a>
						<div class="dropdown-menu dropdown-menu-right">
						'.$prop['dropdown_body'].'
						</div>
					</div>
					';
			break;
		default: // post
			$prop['uri'] = uri($prop['uri']);
			if ($prop['q']) {
				$prop_q = ' q="'.htmlspecialchars(json_encode($prop['q'])).'"';
			}
			if ($prop['confirm_msg']) {
				$confirm_prop = 'confirm_msg="'.h($prop['confirm_msg']).'"';
			}
			return '<a '.$confirm_prop.' class="jcow-btn '.$post_class.' '.$color_type.'" href="#" action="'.$prop['uri'].'" post_title="'.h($prop['post_title']).'"'.$prop_q.'>'.$icon.$title.'</a>';
	}
}

/*
function dropdown($child, $prop=[]) {
	if (!is_map($child)) {
		$child = column($child);
	}
	if (is_app()) {
		return ['type'=>'dropdown','child'=>$child, 'prop'=>$prop];
	}
	if (is_array($children)) {
		$children = column($children);
	}
	return '<div class="dropdown ">
	<a href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" >'.$prop['button'].'</a>
	<div class="dropdown-menu dropdown-menu-right" aria-labelledby="dLabel">
	'.$children.'
	</div>
	</div>';
}
*/

function Image($prop=[]) {
	global $ubase;
	if (is_app()) {
		$image =  ['type'=>'image','src'=>full_url($prop['src']) ];
		if ($prop['style']) {
			$image['style'] = $prop['style'];
		}
		return $image;
	}
}

function gallery($photos=[],$prop=['type'=>'gallery']) {
	if (is_map($photos)) {
		$photos = [$photos];
	}
	if (!$photos[0]['thumb'] && !$photos[0]['uri']) {
		return ;
	}
	if (is_app()) {
		return ['type'=>'gallery', 'children'=>$photos,'prop'=>$prop];
	}
	$num = count($photos);
	if (!$num) return '';
	$n = $num >=3 ? 3: $num;
	$out = '<div class="story_img_gallery ">';
	if ($prop['type'] == 'comment') {
		$out .= '<a href="'.$photos[0]['uri'].'" style="display:block;height:150px;width:150px;background:url('.$photos[0]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>';
	}
	else {
		if ($num == 1) {
			$out .= '<a href="'.$photos[0]['uri'].'"><div style="max-height:800px;overflow:hidden"><img src="'.$photos[0]['uri'].'" style="max-width:99%;height:auto" /></div></a>';
		}
		elseif ($num == 2) {
			$out .= '<div style="display:flex"><a href="'.$photos[0]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[0]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[1]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[1]['thumb'].') no-repeat;background-position: center;margin:2px"> </a></div>';
		}
		elseif ($num == 3) {
			$out .= '<div style="display:flex"><a href="'.$photos[0]['uri'].'" style="display:block;height:150px;width:33%;background:url('.$photos[0]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[1]['uri'].'" style="display:block;height:150px;width:33%;background:url('.$photos[1]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[2]['uri'].'" style="display:block;height:150px;width:33%;background:url('.$photos[2]['thumb'].') no-repeat;background-position: center;margin:2px"> </a></div>';
		}
		elseif ($num == 4) {
			$out .= '<div style="display:flex"><a href="'.$photos[0]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[0]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[1]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[1]['thumb'].') no-repeat;background-position: center;margin:2px"> </a></div>

			<div style="display:flex"><a href="'.$photos[2]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[2]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[3]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[3]['thumb'].') no-repeat;background-position: center;margin:2px"> </a></div>';

		}
		elseif ($num > 4) {
			$out .= '<div style="display:flex"><a href="'.$photos[0]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[0]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[1]['uri'].'" style="display:block;height:200px;width:50%;background:url('.$photos[1]['thumb'].') no-repeat;background-position: center;margin:2px"> </a></div>

			<div  style="display:flex"><a href="'.$photos[2]['uri'].'" style="display:block;height:150px;width:33%;background:url('.$photos[2]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[3]['uri'].'" style="display:block;height:150px;width:33%;background:url('.$photos[3]['thumb'].') no-repeat;background-position: center;margin:2px"> </a>
			<a href="'.$photos[4]['uri'].'" style="display:block;height:150px;width:33%;background:url('.$photos[4]['thumb'].') no-repeat;background-position: center;margin:2px"> </a></div>';
		}
	}
	$out .= '</div>';
	return $out;
}

function icon($name,$prop=[]) {
	if (is_array($name)) {
		$prop = $name;
		$name = $prop['name'];
	}
	else {
		$prop['name'] = $name;
	}
	if (preg_match("/^mi\-/",$name)) {
		$name = $prop['name'] = str_replace('mi-','',$name);
		$prop['lib'] = 'material';
	}
	if (is_app()) {
		return ['type'=>'icon', 'prop'=>$prop];
	}
	
	if ($prop['lib'] == 'material') {
		return '<span class="material-icons-outlined">'.$name.'</span>';
	}
	else {
		return '<i class="fa fa-'.$name.'"></i>';
	}
}

function row($children, $prop=[]) {
	//$prop['type'] = 'row';
	if (is_app()) {
		$prop['style'][] = ['flex-direction','row'];
	}
	else {
		$prop['style'] = 'display:flex;flex-direction:row;'.$prop['style'];
	}
	return view($children, $prop);
}

function row_center($children, $prop=[]) {
	if (is_app()) {
		$prop['style'][] = ['flex-direction','row'];
		$prop['style'][] = ['align-items','center'];
	}
	else {
		$prop['style'] = 'display:flex;flex-direction:row;align-items:center;'.$prop['style'];
	}
	return view($children, $prop);
}

function row_reverse($children, $prop=[]) {
	$prop['type'] = 'row';
	if (is_app()) {
		$prop['style'][] = ['flex-direction','row-reverse'];
	}
	else {
		$prop['style'] = 'display:flex;flex-direction:row-reverse;'.$prop['style'];
	}
	return view($children, $prop);
	return view($children, $prop);
}

function column($children, $prop = []) {
	if (is_app()) {
		$prop['style'][] = ['flex-direction','column'];
	}
	else {
		$prop['style'] = 'display:flex;flex-direction:column;'.$prop['style'];
	}
	$prop['type'] = 'column';
	return view($children, $prop);
}

function column_reverse($children, $prop = []) {
	if (is_app()) {
		$prop['style'][] = ['flex-direction','column-reverse'];
	}
	else {
		$prop['style'] = 'display:flex;flex-direction:column-reverse;'.$prop['style'];
	}
	$prop['type'] = 'column';
	return view($children, $prop);
}

function style($style=[]) {
	if (is_app()) {
		$styles = [];
		foreach ($style as $key=>$val) {
			$styles[] = [$key, $val];
		}
		return $styles;
	}
	else {
		$styles = [];
		foreach ($style as $key=>$val) {
			$styles[] = $key.':'.$val;
		}
		return implode(';',$styles);
	}
}

function view($children, $prop=[]) {
	if (is_map($children)) {
		$children = [$children];
	}
	$children = clean_array($children);
	if (is_app()) {
		return ['type'=>'view', 'children'=>$children, 'prop'=>$prop];
	}
	if ($prop['style']) {
		$style_sheet = 'style="'.$prop['style'].'"';
	}
	$id_key = $prop['id'] ? ' id="'.$prop['id'].'" ' : '';
	return '<div '.$style_sheet.$id_key.'>'.implode($children).'</div>';
}

function expanded($child) {
	if (is_app()) {
		return ['type'=>'expanded', 'child'=>$child];
	}
	return '<div class="grow">'.$child.'</div>';
}


function stream_react($stream,$prop) {
	global $client;
	if (!$client['id']) return;
	$res = sql_query("select * from jcow_liked where stream_id='{$stream['id']}' and uid='{$client['id']}'");
	if (sql_counts($res)) {
		$stream['liked'] = true;
	}
	$comments = [];
	if (is_numeric($prop['comment_num']) && $prop['comment_num'] > 0) {
		$res = sql_query("select c.*,u.username,u.fullname,u.avatar,u.disabled,p.logo as page_logo,p.type as page_type,p.uri as page_uri,p.name as page_name,p.uid as page_uid from jcow_streams as c left join jcow_accounts as u on u.id=c.uid left join jcow_pages as p on p.id=c.wall_id where c.stuff_id='{$stream['id']}' and c.hide=0 order by id desc limit {$prop['comment_num']}");
		while ($row = sql_fetch_array($res)) {
			$row['date'] = get_date($row['created']);
			$row['avatar'] = correct_avatar_path($row['avatar']);
			if ($row['pid']) {
				$res2 = sql_query("select * from jcow_story_photos where id='{$row['pid']}'");
				$row['photo'] = sql_fetch_array($res2);
			}
			array_unshift($comments,$row);
		}
	}
	if (is_app()) {
		return [
			'type'=>'stream_react', 
			'stream'=>$stream,
			'comments'=>$comments,
			'labels'=>[
				'like'=>t('Like'),
				'liked'=>t('Liked'),
				'comment'=>t('Comment'),
				'likes'=>($stream['likes'] > 1) ? t('{1} likes',$stream['likes']): t('{1} like',$stream['likes']),
				'comments'=>($stream['comments'] > 1) ? t('{1} comments',$stream['comments']): t('{1} comment',$stream['comments']),
		]];
	}
	if (!$stream['stuff_id']) {
		$comment_form = comment_form($stream['id'],'','',array('boosted'=>$stream['is_boost']));
		$story_opt = story_opt($stream['id'],'','',array('boosted'=>$stream['is_boost']));
	}
	else {
		$comment_form = reply_form($stream['id'],$stream['username']);
	}
	$comment_get = comment_get($stream['id'],$stream['show_comment_num']);
	if (!$stream['stuff_id']) {
		$comment_get = likes_get($stream).$comment_get;
	}
	return $story_opt.$comment_get.$comment_form;
}

function video($row, $prop=[]) {
	if ($row['app'] != 'videos') return '';
	if (!$row['aid']) {
		if ($row['stream_id'] && $row['id']) {
			$res = sql_query("select uri from jcow_story_photos where sid='{$row['id']}'");
		}
		else {
			return '';
		}
	}
	else {
		$res = sql_query("select uri from jcow_story_photos where sid='{$row['aid']}'");
	}
	$video = sql_fetch_array($res);
	if ($video['uri']) {
		$video['uri'] = media_path($video['uri']);
		$output = '<video class="video-js vjs-default-skin  vjs-big-play-centered vjs-16-9" controls preload="metadata"  data-setup="{}">
    <source src="'.$video['uri'].'#t=0.1" type="video/mp4">
  </video>';
	}
	else {
		if ($row['aid']>0) {
			$res = sql_query("select * from jcow_stories where id='{$row['aid']}' and app='videos'");
			$story = sql_fetch_array($res);
		}
		if (!$story['id']) {
			return '';
		}
		if (!$story['var3'] || $story['var3'] == 'youtube') {
			$output = '<div class="youtube-player youtube-btn" youtubeid="'.$story['var1'].'"><img src="https://i.ytimg.com/vi/'.$story['var1'].'/hqdefault.jpg"><div class="youtube-play"><i class="fa fa-youtube-play"></i></div></div>'.url('videos/viewstory/'.$story['id'],h($story['title']));
		}
		elseif($story['var3'] == 'vimeo') {
			$output = '
				<iframe src="//player.vimeo.com/video/'.$story['var1'].'?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff" width="500" height="350" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>'.'<br />'.url('videos/viewstory/'.$story['id'],h($story['title']));
		}
		elseif ($story['var3'] == 'upload') {
			$output ='
			<video class="video-js vjs-default-skin  vjs-big-play-centered" controls preload="metadata" width="530" height="300" data-setup="{}">
	<source src="'.$story['var4'].'#t=0.1" type="video/mp4">
	<p class="vjs-no-js">
	To view this video please enable JavaScript, and consider upgrading to a web browser that
	<a href="https://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a>
	</p>
	</video> '.h($story['title']);
		}
	}
	if (is_app()) {
		return ['type'=>'video', 'prop'=>$video];
	}
	if ($video['uri'] && $prop['is_new']) {
		return t('Video uploaded successfully!');
	}
	return $output;
}

function clean_array($arr) {
	$filtered_array = [];
	foreach($arr as $child) {
		if ($child) {
			$filtered_array[] = $child;
		}
	}
	return $filtered_array;
}