<?php
/**
 * Setup class
 *
 * This file contains setup module.
 *
 * @author Paul Bukowski <pbukowski@telaxus.com> and Arkadiusz Bisaga <abisaga@telaxus.com>
 * @copyright Copyright &copy; 2008, Janusz Tylek
 * @license MIT
 * @version 1.0
 * @package epesi-base
 * @subpackage setup
 */
defined("_VALID_ACCESS") || die('Direct access forbidden');

/**
 * This class provides for administration of modules.
 */
class Base_Setup extends Module {
	public function admin($store=false) {
		$this->body($store);
	}
	
	public function body($store=false) {
		if($this->is_back() && $this->parent) {
			$this->parent->reset();
			return;
		}

		$post_install = & $this->get_module_variable('post-install');

		if(is_array($post_install)) {
			foreach($post_install as $i=>$v) {
				ModuleManager::include_install($i);
				$f = array($i.'Install','post_install');
				$fs = array($i.'Install','post_install_process');
				if(!is_callable($f) || !is_callable($fs)) {
					unset($post_install[$i]);
					continue;
				}
				$ret = call_user_func($f);
				$form = $this->init_module(Libs_QuickForm::module_name(),null,$i);
				$form->addElement('header',null,'Post installation of '.str_replace('_','/',$i));
				$form->add_array($ret);
				$form->addElement('submit',null,'OK');
				if($form->validate()) {
					$form->process($fs);
					unset($post_install[$i]);
				} else {
					$form->display();
					break;
				}
			}
			if(empty($post_install))
				$this->unset_module_variable('post-install');
		}

		$post_install = & $this->get_module_variable('post-install');
		if(is_array($post_install)) 
			return;

		$simple = Base_SetupCommon::is_simple_setup();

		Base_ActionBarCommon::add('scan',__('Rebuild modules database'),$this->create_confirm_callback_href(__('Parsing for additional modules may take up to several minutes, do you wish to continue?'),array('Base_Setup','parse_modules_folder_refresh')));
		if (!$store) Base_ActionBarCommon::add('back', __('Back'), $this->create_back_href());
		
		if ($simple)
			$this->simple_setup();
		else
			$this->advanced_setup($store);
	}

	public function get_module_dirs() {
		//show uninstalled & installed modules
		$ret = DB::Execute('SELECT * FROM available_modules');
		$module_dirs = array();
		while ($row = $ret->FetchRow()) {
			if (ModuleManager::exists($row['name'])) {
				$module_dirs[$row['name']][$row['vkey']] = $row['version'];
				ModuleManager::include_install($row['name']);
			} else {
				DB::Execute('DELETE FROM available_modules WHERE name=%s and vkey=%d',array($row['name'],$row['vkey']));
			}
		}
		if (empty($module_dirs))
			$module_dirs = Base_SetupCommon::refresh_available_modules();
		return $module_dirs;
	}

	public function advanced_setup($store=false) {
		//create default module form
		$form = $this->init_module(Libs_QuickForm::module_name(),'Processing modules','setup');
		
		//install module header
		$form -> addElement('header','mod_header','<b>' . __('Please select modules to be installed/uninstalled.') . '<br>' . __('For module details please click on "i" icon.'));

		$module_dirs = $this->get_module_dirs();

		$structure = array();
		$def = array();
		$is_required = ModuleManager::required_modules(true);

		// transform is_required array to javascript
		eval_js('var deps = new Array('.sizeof($is_required).');');
		foreach($is_required as $k => $mod) {
			eval_js('deps["'.$k.'"] = new Array('.sizeof($mod).');');
			$i = 0;
			foreach($mod as $dep_mod) eval_js('deps["'.$k.'"]['.$i++.'] = "'.$dep_mod.'";');
		}
		// javascript to show warning only once and cascade uninstall
		load_js('modules/Base/Setup/js/main.js');
		eval_js('var showed = false;');
		eval_js_once('var original_select = new Array('.sizeof($is_required).');');
		eval_js_once('base_setup__reinstall_warning = \''.__('Warning!\nAll data in reinstalled modules will be lost.').'\'');
		eval_js_once('base_setup__uninstall_warning = \''.__('Warning! The following modules will be uninstalled. Are you sure you want to continue?').'\'');

		foreach($module_dirs as $entry=>$versions) {
			$installed = ModuleManager::is_installed($entry);

			$module_install_class = $entry.'Install';

			$func_info = array($module_install_class,'info');
			$info = '';
			if(is_callable($func_info)) {
				$module_info = call_user_func($func_info);
				if($module_info) {
					$info = ' <a '.Libs_LeightboxCommon::get_open_href($entry).'><img style="vertical-align: middle; cursor: pointer;" border="0" width="14" height="14" src='.Base_ThemeCommon::get_template_file('Base_Setup', 'info.png').'></a>';
					$iii = '<h1>'.str_replace('_','/',$entry).'</h1><table>';
					foreach($module_info as $k=>$v)
						$iii .= '<tr><td>'.$k.'</td><td>'.$v.'</td></tr>';
					$iii .= '</table>';
					Libs_LeightboxCommon::display($entry,$iii,'Additional info');
				}
			}

			// Show Tooltip if module is required
			$tooltip = null;
			if(isset($is_required[$entry])) {
				$tooltip = __('Required by:').'<ul>';
				foreach($is_required[$entry] as $mod_name) {
					$tooltip .= '<li>'.$mod_name.'</li>';
				}
				$tooltip .= '</ul>';
			}


			$versions[-1]='not installed';
			ksort($versions);
			if($installed!=-1 && !isset($is_required[$entry])) $versions[-2] = 'reinstall';

			$path = explode('_',$entry);
			$c = & $structure;
			for($i=0, $path_count = count($path)-1;$i<$path_count;$i++){
				if(!array_key_exists($path[$i], $c)) {
					$c[$path[$i]] = array();
					$c[$path[$i]]['name'] = $path[$i];
					$c[$path[$i]]['sub'] = array();
				}
				$c = & $c[$path[$i]]['sub'];
			}
			$params_arr = array('onChange'=>"show_alert(this,'$entry');", 'style'=>'width: 100px');
			$ele = $form->createElement('select', 'installed['.$entry.']', $path[count($path)-1], $versions, $params_arr);
			$ele->setValue($installed);
			eval_js("original_select[\"$entry\"] = $installed");

			$c[$path[count($path)-1]] = array();
			$c[$path[count($path)-1]]['name'] = '<table width="400px"><tr><td align=left>' . $info . ' ' . $path[count($path)-1] . '</td><td width="100px" align=right '.($tooltip?Utils_TooltipCommon::open_tag_attrs($tooltip,false):'').'>' . $ele->toHtml() . '</td></tr></table>';
			$c[$path[count($path)-1]]['sub'] = array();
			array_push($def, array('installed['.$entry.']'=>$installed));
		}

		$tree = $this->init_module(Utils_Tree::module_name());
		$tree->set_structure($structure);
		$tree->set_inline_display();
		//$form->addElement('html', '<tr><td colspan=2>'.$tree->toHtml().'</td></tr>');
		$form->addElement('html', '<tr><td colspan=2>'.$this->get_html_of_module($tree).'</td></tr>');

		$form->setDefaults($def);

		//validation or display
		if ($form->exportValue('submited') && $form->validate()) {
			ob_start();
			if (!$this->validate($form->getSubmitValues())) {
                print ob_get_clean();
                print('<hr class="line"><center><a class="button"' . $this->create_href(array()) . '>Back</a></center>');
            } else {
                ob_end_clean();
                location(array());
            }
            return;
		}
		$form->display();
		Base_ActionBarCommon::add('save', __('Save'), $form->get_submit_form_href());
		if (!$store) Base_ActionBarCommon::add('settings', __('Simple view'),$this->create_callback_href(array($this,'switch_simple'),true));
	}

	public function simple_setup() {
		Base_ActionBarCommon::add('settings', __('Advanced view'),$this->create_confirm_callback_href(__('Switch to advanced view?'),array($this,'switch_simple'),false));

		$module_dirs = $this->get_module_dirs();
		$is_required = ModuleManager::required_modules(true);

		$structure = array();

		foreach($module_dirs as $entry=>$versions) {
			$installed = ModuleManager::is_installed($entry);

			$module_install_class = $entry.'Install';
			$func_simple = array($module_install_class,'simple_setup');
			if (is_callable($func_simple))
				$simple_module = call_user_func($func_simple);
			else
				$simple_module = false;

			if ($simple_module===false) continue;
			if ($simple_module===true) $simple_module = array('package'=>__('Uncategorized'), 'option'=>$entry);
			if (is_string($simple_module)) $simple_module = array('package'=>$simple_module);
			if (!isset($simple_module['option'])) $simple_module['option'] = null;
			$simple_module['module'] = $entry;
			$simple_module['installed'] = ($installed>=0);
			$simple_module['key'] = $simple_module['package'].($simple_module['option']?'|'.$simple_module['option']:'');
			$structure[$entry] = $simple_module;
		}

		$packages = array();
		foreach ($structure as $s) {
			if (!isset($packages[$s['key']])) $packages[$s['key']] = array('also_uninstall'=>array(), 'modules'=>array(), 'is_required'=>array(), 'installed'=>null, 'icon'=>false, 'version'=>null, 'url'=>null, 'core'=>0);
			$package = & $packages[$s['key']];
			$package['modules'][] = $s['module'];
			$package['name'] = $s['package'];
			$package['option'] = $s['option'];
			if (isset($s['core'])) $package['core'] = $s['core'];
			if ($package['installed']===null) {
				$package['installed'] = $s['installed'];
			} else {
				if (($s['installed'] && !$package['installed']) || (!$s['installed'] && $package['installed'])) {
					$package['installed'] = 'partial';
				}
			}
			if (!isset($is_required[$s['module']])) $is_required[$s['module']] = array();
			foreach ($is_required[$s['module']] as $r) {
				if (!isset($structure[$r])) {
					$package['also_uninstall'][] = $r;
					continue;
				}
				if ($structure[$r]['package']==$s['package']) continue;
				$package['is_required'][$structure[$r]['key']] = $structure[$r]['key'];
			}
			if (isset($s['icon']))
				$package['icon'] = Base_ThemeCommon::get_template_file($s['module'], 'package-icon.png');
			if (isset($s['version']))
				$package['version'] = $s['version'];
			if (isset($s['url']))
				$package['url'] = $s['url'];
		}
		
		$sorted = array();
		foreach ($packages as $key=>$p) {
			if ($key===0) continue;
			$name = $p['name'];
			$option = $p['option'];
			if (!isset($sorted[$name])) {
				$sorted[$name] = array();
				$sorted[$name]['name'] = $name;
				$sorted[$name]['modules'] = array();
				$sorted[$name]['buttons'] = array();
				$sorted[$name]['options'] = array();
				$sorted[$name]['status'] = __('Options only');
				$sorted[$name]['filter'] = array('available');
				$sorted[$name]['style'] = 'disabled';
				$sorted[$name]['installed'] = null;
				$sorted[$name]['instalable'] = 0;
				$sorted[$name]['uninstalable'] = 0;
				$sorted[$name]['core'] = 0;
			}
			$sorted[$name]['core'] |= $p['core'];

			$buttons = array();
			$status = '';
			if ($p['installed']===true || $p['installed']==='partial') {
				if (!$p['core'] && empty($p['is_required'])) {
					$mods = $p['modules'];
					foreach ($p['also_uninstall'] as $pp)
						$mods[] = $pp;
					if ($p['option']===null) { // also add all options as available for uninstall
						foreach ($packages as $pp)
							if ($pp['name']===$p['name']) {
								$mods = array_merge($mods,$pp['modules']);
							}
					}
					$buttons[] = array('label'=>__('Uninstall'),'style'=>'uninstall','href'=>$this->create_confirm_callback_href(__('Are you sure you want to uninstall this package and remove all associated data?'),array($this, 'simple_uninstall'), array($mods)));
				} else {
					if ($p['core']) $message = __('EPESI Core can not be uninstalled');
					elseif (empty($p['is_required'])) $message = __('This package can not be uninstalled');
					else {
						$required = array();
						foreach ($p['is_required'] as $v) $required[] = str_replace('|',' / ', $v);
						$message = __('This package is required by the following packages: %s',array('<br>'.implode('<br>', $required)));
					}
					$buttons[] = array('label'=>__('Uninstall'),'style'=>'disabled','href'=>Utils_TooltipCommon::open_tag_attrs($message, false));
				}
			}
			if ($p['installed']===false || $p['installed']==='partial') {
				$buttons[] = array('label'=>__('Install'),'style'=>'install','href'=>$this->create_callback_href(array($this, 'simple_install'), array($p['modules'])));
			}
			switch (true) {
				case $p['installed']===false:
					$style = 'available';
					$filter = array('available');
					$status = __('Available'); 
					break;
				case $p['installed']===true:
					$style = 'install';
					$filter = array('installed');
					$status = __('Installed');
					break;
				case $p['installed']==='partial':
					$style = 'partial-install';
					$filter = array('installed');
					$status = __('Partially');
					break;
			}

			if ($option===null) {
				$sorted[$name]['modules'] = $p['modules'];
				$sorted[$name]['buttons'] = $buttons;
				$sorted[$name]['status'] = $status;
				$sorted[$name]['style'] = $style;
				$sorted[$name]['installed'] = $p['installed'];
				$sorted[$name]['instalable'] = 1;
				$sorted[$name]['uninstalable'] = empty($p['is_required']);
				$sorted[$name]['filter'] = $filter;
				$sorted[$name]['icon'] = $p['icon'];
				$sorted[$name]['version'] = $p['version'];
				$sorted[$name]['url'] = $p['url'];
			} else {
				$sorted[$name]['options'][$option] = array(
				'name' => $option,
				'buttons' => $buttons,
				'status' => $status,
				'style' => $style);
			}
		}
		$filters = array(
			__('All') => array('arg'=>''),
			__('Installed') => array('arg'=>'installed'),
			__('Available') => array('arg'=>'available')
		);
		if (ModuleManager::is_installed('Base_EpesiStore')>=0) {
            $store_visible = Base_SetupCommon::is_store_visible();
            if ($store_visible)
                $this->add_store_products($sorted, $filters);
            $icon = $store_visible ? 'delete' : 'add';
            $text = $store_visible ? __('Disable EPESI Store') : __('Enable EPESI Store');
            $href = $this->create_callback_href(array('Base_SetupCommon', 'set_store_visibility'), array(!$store_visible));
            $desc = $store_visible ? __('Disabling communication with EPESI Store will improve processing speed, but will not update the list of additional modules in the store.') : '';
            Base_ActionBarCommon::add($icon, $text, $href, $desc);
		}

		foreach ($sorted as $name=>$v) {
			ksort($sorted[$name]['options']);
            $buttons_tooltip = & $sorted[$name]['buttons_tooltip'];
            $buttons_tooltip = $buttons_tooltip ? Utils_TooltipCommon::open_tag_attrs($buttons_tooltip, false) : '';
        }
		
		uasort($sorted, array($this, 'simple_setup_sort'));
		
		$t = $this->init_module(Base_Theme::module_name());
		$t->assign('packages', $sorted);
		$t->assign('filters', $filters);
		$t->assign('version_label', __('Ver. '));
		$t->assign('labels', array('options'=>__('Optional')));
		
		$t->display();
	}
    
    public static function response_callback($action, $ret) {
		if ($ret!==true) {
			$msg = __( 'Error');
			if (is_string($ret) && $ret) $msg .= ': '.$ret;
			Base_StatusBarCommon::message($msg, 'error');
		} else {
            $msg = __('Action successful');
			switch ($action) {
				case Base_EpesiStoreCommon::ACTION_BUY:
					$msg = __( 'Purchase successful');
					break;
				case Base_EpesiStoreCommon::ACTION_DOWNLOAD:
				case Base_EpesiStoreCommon::ACTION_UPDATE:
					Base_SetupCommon::refresh_available_modules();
					Base_BoxCommon::update_version_check_indicator(true);
					$msg = __( 'Download successful');
					break;
				case Base_EpesiStoreCommon::ACTION_INSTALL:
					$msg = __( 'Install successful');
					break;
                case Base_EpesiStoreCommon::ACTION_RESTORE:
                    $msg = __('Restore successful');
                    break;
			}
			Base_StatusBarCommon::message($msg);
		}
    }
	
	public function jump_to_epesi_registration() {
		Base_BoxCommon::push_module('Base_EssClient');
		return false;
	}

	public function add_store_products(& $sorted, & $filters) {
		$registered = Base_EssClientCommon::has_license_key();
		$filters_attrs = '';
		if (!$registered) {
			if (TRIAL_MODE) {
				$msg = __('EPESI Store is not accessible during the trial.');
				$filters_attrs = 'href="javascript:void(0);" onclick="alert(\''.$msg.'\');"';
			} else {
				$msg = __('To access EPESI Store it is necessary that you register your EPESI installation. Would you like to do this now?');
				$filters_attrs = $this->create_confirm_callback_href($msg, array($this, 'jump_to_epesi_registration'));
			}
		}
		$filters[__('Updates')] = array('arg'=>'updates', 'attrs'=>$filters_attrs);
		$filters[__('My Purchases')] = array('arg'=>'purchases', 'attrs'=>$filters_attrs);
		$filters[__('Store')] = array('arg'=>'store', 'attrs'=>$filters_attrs);
		if (!$registered) 
			return;
		
		$store = Base_EpesiStoreCommon::get_modules_all_available();
        print Base_EssClientCommon::client_messages_frame();
        if(!$store)
            return;
		foreach ($store as $s) {
			$name = htmlspecialchars_decode($s['name']); // Module name is translated on the server

            $label = $s['action'];
            $downloaded = ($label != Base_EpesiStoreCommon::ACTION_BUY
                           && $label != Base_EpesiStoreCommon::ACTION_DOWNLOAD);
            if (!isset($s['total_price'])) $s['total_price'] = $s['price'];
			if ($label==Base_EpesiStoreCommon::ACTION_BUY && $s['total_price']===0) {
				$s['total_price'] = __('Free');
				$label = 'obtain license';
			}
			$b_label = _V(ucfirst($label)); // ****** EpesiStoreCommon - translations added in comments
            $button = array(
                'label' => $b_label,
                'style' => 'install',
                'href'  => Base_EpesiStoreCommon::action_href($s, $s['action'], array('Base_Setup', 'response_callback')));
            if (isset($sorted[$name]) && $downloaded) {
				$sorted[$name]['filter'][] = 'purchases';
                if ($label == Base_EpesiStoreCommon::ACTION_UPDATE) {
                    $sorted[$name]['buttons'][] = $button;
                    $sorted[$name]['filter'][] = 'updates';
                    $sorted[$name]['style'] = 'problem';
                }
                if ($label == Base_EpesiStoreCommon::ACTION_RESTORE) {
                    $button['style'] = 'problem';
                    $sorted[$name]['buttons'][] = $button;
                    $sorted[$name]['style'] = 'disabled';
                    $sorted[$name]['status'] = __('Files modified');
                }
                $sorted[$name]['url'] = $s['description_url'];
				$sorted[$name]['icon'] = $s['icon_url'];
				continue;
			}
			$sorted[$name] = array();
            $sorted[$name]['core'] = 0;
			$sorted[$name]['url'] = $s['description_url'];
			$sorted[$name]['icon'] = $s['icon_url'];
			$sorted[$name]['name'] = $name; // ****** FIXME - modules names from the store
			$sorted[$name]['modules'] = array();
			$sorted[$name]['options'] = array();
			if (isset($s['paid']) && $s['paid']) {
                $status = __('Purchased');
                $style = 'problem';
                switch ($label) {
                    case Base_EpesiStoreCommon::ACTION_RESTORE:
                        $status = __('Files modified');
                        $button['style'] = 'uninstall';
                        $style = 'disabled';
                        break;
                    case Base_EpesiStoreCommon::ACTION_INSTALL:
                        $status = __('Ready to use');
                        $style = 'disabled';
                        break;
                    case Base_EpesiStoreCommon::ACTION_UPDATE:
                        $status = __('To update');
                        break;
                }
				$sorted[$name]['status'] = $status;
				$sorted[$name]['style'] = $style;
				$sorted[$name]['filter'] = array('purchases');
			} else {
				$sorted[$name]['status'] = __('Price: %s', array($s['total_price']));
				$sorted[$name]['style'] = 'store';
				$sorted[$name]['filter'] = array('store');
                $sorted[$name]['buttons_tooltip'] = $this->included_modules_text($s);
			}
            if ($label != Base_EpesiStoreCommon::ACTION_INSTALL) {
                $sorted[$name]['buttons'] = array($button);
            }
			$sorted[$name]['version'] = $s['version'];
            if ($label == Base_EpesiStoreCommon::ACTION_UPDATE) {
                $sorted[$name]['filter'][] = 'updates';
            }
			$sorted[$name]['installed'] = null;
			$sorted[$name]['instalable'] = 0;
			$sorted[$name]['uninstalable'] = 0;
		}
	}

    private function included_modules_text($module) {
        $text = '';
        if ($module['needed_modules']) {
            $text .= __('With this module you also need some other modules.').'<br>'.__('Here is the list of what you will buy:');
            $arr = array($module['name'] => $module['price']);
			if (!is_array($module['required_modules'])) $module['required_modules'] = explode(', ',$module['required_modules']);
            foreach ($module['needed_modules'] as $rm_id) {
                $mod = Base_EpesiStoreCommon::get_module_info_cached($rm_id);
                $arr[$mod['name']] = $mod['price'];
            }
            $text .= "<table class=\"price_summary\">";
            foreach($arr as $name => $price)
                $text .= "<tr><td>$name</td><td>$price</td></tr>";
            $text .= "</table>";
        }
        return $text;
    }
    
	public function simple_setup_sort($a, $b) {
		if ($a['core'] === 1) return -1;
		if ($b['core'] === 1) return 1;
		$cmp = strcasecmp($a['name'], $b['name']);
		$cmp = $cmp<0? -1:1;
		if ($a['installed'] === $b['installed']) return $cmp;
		if ($a['installed'] === true) return -1;
		if ($b['installed'] === true) return 1;
		if ($a['installed'] === 'partial') return -1;
		if ($b['installed'] === 'partial') return 1;
		if ($a['installed'] === false) return -1;
		if ($b['installed'] === false) return 1;
		return $cmp;
	}
	
	public function simple_uninstall($modules) {
		if(DEMO_MODE) {
			Base_StatusBarCommon::message('Feature unavailable in DEMO','warning');
			return;
		}
		ob_start();
		$modules_prio_rev = array();
		foreach (ModuleManager::$modules as $k => $v)
			$modules_prio_rev[] = $k;
		$modules_prio_rev = array_reverse($modules_prio_rev);

		foreach ($modules_prio_rev as $k)
			if(in_array($k, $modules))
				if (!ModuleManager::uninstall($k)) {
					ob_end_clean();
					Base_StatusBarCommon::message('Couldn\'t uninstall the package.','error');
					return false;
				}
		ob_end_clean();
		Base_StatusBarCommon::message('Package uninstalled.');
		return false;
	}
	
	public function simple_install($modules) {
		if(DEMO_MODE) {
			Base_StatusBarCommon::message('Feature unavailable in DEMO','warning');
			return;
		}
		$module_dirs = $this->get_module_dirs();
		foreach ($modules as $k) {
            ob_start();
			$versions = array_keys($module_dirs[$k]);
			if (!ModuleManager::install($k, max($versions))) {
				$content = "<div class=\"important_notice\">" . ob_get_clean() . '</div>';
                print $content;
                $msg = __('Couldn\'t install the package.') . '<br>'
                       . __('Review error at the top of the page');
                Base_StatusBarCommon::message($msg,'error');
				return false;
			} else {
                ob_end_clean();
            }
		}
		Base_StatusBarCommon::message('Package installed.');
		
		$processed = ModuleManager::get_processed_modules();
		$this->set_module_variable('post-install',$processed['install']);
		
		return false;
	}
	
	public function store() {
	    $this->pack_module('Base_EpesiStore',array(),'admin');
	}
	
	public function switch_simple($value) {
        Base_SetupCommon::set_simple_setup($value);
        location(array());
    }

	public static function parse_modules_folder_refresh(){
		Base_SetupCommon::refresh_available_modules();
		//location(array());
		return false;
	}

	public function validate($data) {
		if(DEMO_MODE) {
			print('You cannot modify installed modules in demo');
	    		return false;
		}

		@set_time_limit(0);
		
		$installed = array ();
		$install = array ();
		$uninstall = array();
		$anonymous_setup = false;

		foreach ($data as $k => $v)
			${ $k } = $v;

		foreach ($installed as $name => $new_version) {
			$old_version = ModuleManager::is_installed($name);
			if($old_version==$new_version) continue;
			if($old_version==-1 && $new_version>=0) {
				$install[$name]=$new_version;
				continue;
			}
            if($new_version==-2) {
                $uninstall[$name]=1;
                $install[$name]=$old_version;
                continue;
            }
			if($old_version>=0 && $new_version==-1) {
				$uninstall[$name]=1;
				continue;
			}
			if($old_version<$new_version) {
				if(!ModuleManager::upgrade($name, $new_version))
					return false;
				continue;
			}
			if($old_version>$new_version) {
				if(!ModuleManager::downgrade($name, $new_version))
					return false;
				continue;
			}
		}

		//uninstall
		$modules_prio_rev = array();
		foreach (ModuleManager::$modules as $k => $v)
			$modules_prio_rev[] = $k;
		$modules_prio_rev = array_reverse($modules_prio_rev);

		foreach ($modules_prio_rev as $k)
			if(array_key_exists($k, $uninstall)) {
				if (!ModuleManager::uninstall($k)) {
					return false;
				}
				if(count(ModuleManager::$modules)==0)
					print('No modules installed');
			}

        //install
		foreach($install as $i=>$v) {
			$post_install[$i] = $v;
            if(isset($uninstall[$i])) {
                if (!ModuleManager::install($i,$v,true,false))
                    return false;
            } else {
                if (!ModuleManager::install($i,$v))
                    return false;
            }
		}
		$processed = ModuleManager::get_processed_modules();
		$this->set_module_variable('post-install',$processed['install']);

        Base_ThemeCommon::create_cache();

		if(empty($post_install))
			Epesi::redirect();

		return true;
	}
}
?>
