
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `elgg2317`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_collections`
--

CREATE TABLE `[[dbprefix]]access_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `owner_guid` (`owner_guid`),
  KEY `site_guid` (`site_guid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_collection_membership`
--

CREATE TABLE `[[dbprefix]]access_collection_membership` (
  `user_guid` bigint(20) unsigned NOT NULL,
  `access_collection_id` int(11) NOT NULL,
  PRIMARY KEY (`user_guid`,`access_collection_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]annotations`
--

CREATE TABLE `[[dbprefix]]annotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_guid` bigint(20) unsigned NOT NULL,
  `name_id` int(11) NOT NULL,
  `value_id` int(11) NOT NULL,
  `value_type` enum('integer','text') NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name_id` (`name_id`),
  KEY `value_id` (`value_id`),
  KEY `owner_guid` (`owner_guid`),
  KEY `access_id` (`access_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_users`
--

CREATE TABLE `[[dbprefix]]api_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_guid` bigint(20) unsigned DEFAULT NULL,
  `api_key` varchar(40) DEFAULT NULL,
  `secret` varchar(40) NOT NULL,
  `active` int(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_key` (`api_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`name`,`site_guid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('view', 's:7:"default";', 1),
('language', 's:2:"en";', 1),
('default_access', 's:1:"2";', 1),
('allow_registration', 'b:1;', 1),
('walled_garden', 'b:0;', 1),
('allow_user_default_access', 's:0:"";', 1),
('default_limit', 'i:10;', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]datalists`
--

CREATE TABLE `[[dbprefix]]datalists` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]datalists`
--

INSERT INTO `[[dbprefix]]datalists` VALUES
('installed', '[[timestamp]]'),
('dataroot', '[[softdatadir]]/'),
('default_site', '1'),
('version', '2016092300'),
('simplecache_enabled', '1'),
('system_cache_enabled', '1'),
('simplecache_lastupdate', '[[timestamp]]'),
('processed_upgrades', 'a:3:{i:0;s:56:"2015062900-1.11.2-discussion_plugin-e28c7afa4f5f24ec.php";i:1;s:57:"2016090100-2.2.0-wider_subtype_class-40b951c36343280b.php";i:2;s:59:"2016092300-2.2.0-database-guid-columns-5a57ba1bfdd8d925.php";}'),
('admin_registered', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entities`
--

CREATE TABLE `[[dbprefix]]entities` (
  `guid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('object','user','group','site') NOT NULL,
  `subtype` int(11) DEFAULT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL,
  `container_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `time_updated` int(11) NOT NULL,
  `last_action` int(11) NOT NULL DEFAULT '0',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`guid`),
  KEY `type` (`type`),
  KEY `subtype` (`subtype`),
  KEY `owner_guid` (`owner_guid`),
  KEY `site_guid` (`site_guid`),
  KEY `container_guid` (`container_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `time_updated` (`time_updated`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=42 ;

--
-- Dumping data for table `[[dbprefix]]entities`
--

INSERT INTO `[[dbprefix]]entities` VALUES
(1, 'site', 0, 0, 1, 0, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(2, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(3, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(4, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(5, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(6, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(7, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(8, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(9, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(10, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(11, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(12, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(13, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(14, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(15, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(16, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(17, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(18, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(19, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(20, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(21, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(22, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(23, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(24, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(25, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(26, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(27, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(28, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(29, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(30, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(31, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(32, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(33, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(34, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(35, 'object', 1, 1, 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(36, 'user', 0, 0, 1, 0, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(37, 'object', 3, 36, 1, 36, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(38, 'object', 3, 36, 1, 36, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(39, 'object', 3, 36, 1, 36, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(40, 'object', 3, 36, 1, 36, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(41, 'object', 3, 36, 1, 36, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entity_relationships`
--

CREATE TABLE `[[dbprefix]]entity_relationships` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid_one` bigint(20) unsigned NOT NULL,
  `relationship` varchar(50) NOT NULL,
  `guid_two` bigint(20) unsigned NOT NULL,
  `time_created` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guid_one` (`guid_one`,`relationship`,`guid_two`),
  KEY `relationship` (`relationship`),
  KEY `guid_two` (`guid_two`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]entity_relationships`
--

INSERT INTO `[[dbprefix]]entity_relationships` VALUES
(1, 2, 'active_plugin', 1, [[timestamp]]),
(2, 3, 'active_plugin', 1, [[timestamp]]),
(3, 4, 'active_plugin', 1, [[timestamp]]),
(4, 5, 'active_plugin', 1, [[timestamp]]),
(5, 10, 'active_plugin', 1, [[timestamp]]),
(6, 13, 'active_plugin', 1, [[timestamp]]),
(7, 14, 'active_plugin', 1, [[timestamp]]),
(8, 15, 'active_plugin', 1, [[timestamp]]),
(9, 16, 'active_plugin', 1, [[timestamp]]),
(10, 17, 'active_plugin', 1, [[timestamp]]),
(11, 19, 'active_plugin', 1, [[timestamp]]),
(12, 20, 'active_plugin', 1, [[timestamp]]),
(13, 21, 'active_plugin', 1, [[timestamp]]),
(14, 22, 'active_plugin', 1, [[timestamp]]),
(15, 23, 'active_plugin', 1, [[timestamp]]),
(16, 24, 'active_plugin', 1, [[timestamp]]),
(17, 25, 'active_plugin', 1, [[timestamp]]),
(18, 26, 'active_plugin', 1, [[timestamp]]),
(19, 27, 'active_plugin', 1, [[timestamp]]),
(20, 28, 'active_plugin', 1, [[timestamp]]),
(21, 29, 'active_plugin', 1, [[timestamp]]),
(22, 32, 'active_plugin', 1, [[timestamp]]),
(23, 34, 'active_plugin', 1, [[timestamp]]),
(24, 36, 'member_of_site', 1, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entity_subtypes`
--

CREATE TABLE `[[dbprefix]]entity_subtypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('object','user','group','site') NOT NULL,
  `subtype` varchar(50) NOT NULL,
  `class` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`subtype`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]entity_subtypes`
--

INSERT INTO `[[dbprefix]]entity_subtypes` VALUES
(1, 'object', 'plugin', 'ElggPlugin'),
(2, 'object', 'file', 'ElggFile'),
(3, 'object', 'widget', 'ElggWidget'),
(4, 'object', 'comment', 'ElggComment'),
(5, 'object', 'elgg_upgrade', 'ElggUpgrade'),
(6, 'object', 'blog', 'ElggBlog'),
(7, 'object', 'discussion_reply', 'ElggDiscussionReply'),
(8, 'object', 'thewire', 'ElggWire');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]geocode_cache`
--

CREATE TABLE `[[dbprefix]]geocode_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(128) DEFAULT NULL,
  `lat` varchar(20) DEFAULT NULL,
  `long` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `location` (`location`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_entity`
--

CREATE TABLE `[[dbprefix]]groups_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`guid`),
  KEY `name` (`name`(50)),
  KEY `description` (`description`(50)),
  FULLTEXT KEY `name_2` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hmac_cache`
--

CREATE TABLE `[[dbprefix]]hmac_cache` (
  `hmac` varchar(255) NOT NULL,
  `ts` int(11) NOT NULL,
  PRIMARY KEY (`hmac`),
  KEY `ts` (`ts`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]metadata`
--

CREATE TABLE `[[dbprefix]]metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_guid` bigint(20) unsigned NOT NULL,
  `name_id` int(11) NOT NULL,
  `value_id` int(11) NOT NULL,
  `value_type` enum('integer','text') NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name_id` (`name_id`),
  KEY `value_id` (`value_id`),
  KEY `owner_guid` (`owner_guid`),
  KEY `access_id` (`access_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]metadata`
--

INSERT INTO `[[dbprefix]]metadata` VALUES
(1, 1, 1, 2, 'text', 0, 2, [[timestamp]], 'yes'),
(2, 36, 3, 4, 'integer', 0, 2, [[timestamp]], 'yes'),
(3, 36, 5, 4, 'text', 0, 2, [[timestamp]], 'yes'),
(4, 36, 6, 7, 'text', 0, 2, [[timestamp]], 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]metastrings`
--

CREATE TABLE `[[dbprefix]]metastrings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `string` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string` (`string`(50))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]metastrings`
--

INSERT INTO `[[dbprefix]]metastrings` VALUES
(1, 'email'),
(2, '[[site_email]]'),
(3, 'notification:method:email'),
(4, '1'),
(5, 'validated'),
(6, 'validated_method'),
(7, 'admin_user');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]objects_entity`
--

CREATE TABLE `[[dbprefix]]objects_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`guid`),
  FULLTEXT KEY `title` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]objects_entity`
--

INSERT INTO `[[dbprefix]]objects_entity` VALUES
(2, 'aalborg_theme', ''),
(3, 'blog', ''),
(4, 'bookmarks', ''),
(5, 'ckeditor', ''),
(6, 'custom_index', ''),
(7, 'dashboard', ''),
(8, 'developers', ''),
(9, 'diagnostics', ''),
(10, 'discussions', ''),
(11, 'embed', ''),
(12, 'externalpages', ''),
(13, 'file', ''),
(14, 'garbagecollector', ''),
(15, 'groups', ''),
(16, 'htmlawed', ''),
(17, 'invitefriends', ''),
(18, 'legacy_urls', ''),
(19, 'likes', ''),
(20, 'logbrowser', ''),
(21, 'logrotate', ''),
(22, 'members', ''),
(23, 'messageboard', ''),
(24, 'messages', ''),
(25, 'notifications', ''),
(26, 'pages', ''),
(27, 'profile', ''),
(28, 'reportedcontent', ''),
(29, 'search', ''),
(30, 'site_notifications', ''),
(31, 'tagcloud', ''),
(32, 'thewire', ''),
(33, 'twitter_api', ''),
(34, 'uservalidationbyemail', ''),
(35, 'web_services', ''),
(37, '', ''),
(38, '', ''),
(39, '', ''),
(40, '', ''),
(41, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]private_settings`
--

CREATE TABLE `[[dbprefix]]private_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_guid` bigint(20) unsigned NOT NULL,
  `name` varchar(128) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `entity_guid` (`entity_guid`,`name`),
  KEY `name` (`name`),
  KEY `value` (`value`(50))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=56 ;

--
-- Dumping data for table `[[dbprefix]]private_settings`
--

INSERT INTO `[[dbprefix]]private_settings` VALUES
(1, 2, 'elgg:internal:priority', '34'),
(2, 3, 'elgg:internal:priority', '1'),
(3, 4, 'elgg:internal:priority', '2'),
(4, 5, 'elgg:internal:priority', '3'),
(5, 6, 'elgg:internal:priority', '4'),
(6, 7, 'elgg:internal:priority', '5'),
(7, 8, 'elgg:internal:priority', '6'),
(8, 9, 'elgg:internal:priority', '7'),
(9, 10, 'elgg:internal:priority', '8'),
(10, 11, 'elgg:internal:priority', '9'),
(11, 12, 'elgg:internal:priority', '10'),
(12, 13, 'elgg:internal:priority', '11'),
(13, 14, 'elgg:internal:priority', '12'),
(14, 15, 'elgg:internal:priority', '13'),
(15, 16, 'elgg:internal:priority', '14'),
(16, 17, 'elgg:internal:priority', '15'),
(17, 18, 'elgg:internal:priority', '16'),
(18, 19, 'elgg:internal:priority', '17'),
(19, 20, 'elgg:internal:priority', '18'),
(20, 21, 'elgg:internal:priority', '19'),
(21, 22, 'elgg:internal:priority', '20'),
(22, 23, 'elgg:internal:priority', '21'),
(23, 24, 'elgg:internal:priority', '22'),
(24, 25, 'elgg:internal:priority', '23'),
(25, 26, 'elgg:internal:priority', '24'),
(26, 27, 'elgg:internal:priority', '25'),
(27, 28, 'elgg:internal:priority', '26'),
(28, 29, 'elgg:internal:priority', '27'),
(29, 30, 'elgg:internal:priority', '28'),
(30, 31, 'elgg:internal:priority', '29'),
(31, 32, 'elgg:internal:priority', '30'),
(32, 33, 'elgg:internal:priority', '31'),
(33, 34, 'elgg:internal:priority', '32'),
(34, 35, 'elgg:internal:priority', '33'),
(35, 32, 'limit', '140'),
(36, 37, 'handler', 'control_panel'),
(37, 37, 'context', 'admin'),
(38, 37, 'column', '1'),
(39, 37, 'order', '0'),
(40, 38, 'handler', 'admin_welcome'),
(41, 38, 'context', 'admin'),
(42, 38, 'order', '10'),
(43, 38, 'column', '1'),
(44, 39, 'handler', 'online_users'),
(45, 39, 'context', 'admin'),
(46, 39, 'column', '2'),
(47, 39, 'order', '0'),
(48, 40, 'handler', 'new_users'),
(49, 40, 'context', 'admin'),
(50, 40, 'order', '10'),
(51, 40, 'column', '2'),
(52, 41, 'handler', 'content_stats'),
(53, 41, 'context', 'admin'),
(54, 41, 'order', '20'),
(55, 41, 'column', '2');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue`
--

CREATE TABLE `[[dbprefix]]queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `data` mediumblob NOT NULL,
  `timestamp` int(11) NOT NULL,
  `worker` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `retrieve` (`timestamp`,`worker`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]river`
--

CREATE TABLE `[[dbprefix]]river` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(8) NOT NULL,
  `subtype` varchar(32) NOT NULL,
  `action_type` varchar(32) NOT NULL,
  `access_id` int(11) NOT NULL,
  `view` text NOT NULL,
  `subject_guid` bigint(20) unsigned NOT NULL,
  `object_guid` bigint(20) unsigned NOT NULL,
  `target_guid` bigint(20) unsigned NOT NULL,
  `annotation_id` int(11) NOT NULL,
  `posted` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `action_type` (`action_type`),
  KEY `access_id` (`access_id`),
  KEY `subject_guid` (`subject_guid`),
  KEY `object_guid` (`object_guid`),
  KEY `target_guid` (`target_guid`),
  KEY `annotation_id` (`annotation_id`),
  KEY `posted` (`posted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sites_entity`
--

CREATE TABLE `[[dbprefix]]sites_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `url` varchar(255) NOT NULL,
  PRIMARY KEY (`guid`),
  UNIQUE KEY `url` (`url`),
  FULLTEXT KEY `name` (`name`,`description`,`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]sites_entity`
--

INSERT INTO `[[dbprefix]]sites_entity` VALUES
(1, '[[site_name]]', '[[site_desc]]', '[[softurl]]/');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_log`
--

CREATE TABLE `[[dbprefix]]system_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL,
  `object_class` varchar(50) NOT NULL,
  `object_type` varchar(50) NOT NULL,
  `object_subtype` varchar(50) NOT NULL,
  `event` varchar(50) NOT NULL,
  `performed_by_guid` bigint(20) unsigned NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  `time_created` int(11) NOT NULL,
  `ip_address` varchar(46) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `object_class` (`object_class`),
  KEY `object_type` (`object_type`),
  KEY `object_subtype` (`object_subtype`),
  KEY `event` (`event`),
  KEY `performed_by_guid` (`performed_by_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `river_key` (`object_type`,`object_subtype`,`event`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=50 ;

--
-- Dumping data for table `[[dbprefix]]system_log`
--

INSERT INTO `[[dbprefix]]system_log` VALUES
(1, 2, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(2, 3, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(3, 4, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(4, 5, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(5, 6, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(6, 7, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(7, 8, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(8, 9, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(9, 10, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(10, 11, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(11, 12, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(12, 13, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(13, 14, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(14, 15, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(15, 16, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(16, 17, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(17, 18, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(18, 19, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(19, 20, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(20, 21, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(21, 22, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(22, 23, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(23, 24, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(24, 25, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(25, 26, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(26, 27, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(27, 28, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(28, 29, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(29, 30, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(30, 31, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(31, 32, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(32, 33, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(33, 34, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(34, 35, 'ElggPlugin', 'object', 'plugin', 'create', 0, 1, 2, 'yes', [[timestamp]], '[[clientip]]'),
(35, 1, 'ElggRelationship', 'relationship', 'active_plugin', 'create', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(36, 36, 'ElggUser', 'user', '', 'create', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(37, 24, 'ElggRelationship', 'relationship', 'member_of_site', 'create', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(38, 2, 'ElggMetadata', 'metadata', 'notification:method:email', 'create', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(39, 36, 'ElggUser', 'user', '', 'make_admin', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(40, 37, 'ElggWidget', 'object', 'widget', 'create', 0, 36, 2, 'yes', [[timestamp]], '[[clientip]]'),
(41, 38, 'ElggWidget', 'object', 'widget', 'create', 0, 36, 2, 'yes', [[timestamp]], '[[clientip]]'),
(42, 39, 'ElggWidget', 'object', 'widget', 'create', 0, 36, 2, 'yes', [[timestamp]], '[[clientip]]'),
(43, 40, 'ElggWidget', 'object', 'widget', 'create', 0, 36, 2, 'yes', [[timestamp]], '[[clientip]]'),
(44, 41, 'ElggWidget', 'object', 'widget', 'create', 0, 36, 2, 'yes', [[timestamp]], '[[clientip]]'),
(45, 3, 'ElggMetadata', 'metadata', 'validated', 'create', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(46, 4, 'ElggMetadata', 'metadata', 'validated_method', 'create', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(47, 36, 'ElggUser', 'user', '', 'login:before', 0, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(48, 36, 'ElggUser', 'user', '', 'login', 36, 0, 2, 'yes', [[timestamp]], '[[clientip]]'),
(49, 36, 'ElggUser', 'user', '', 'login:after', 36, 0, 2, 'yes', [[timestamp]], '[[clientip]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_apisessions`
--

CREATE TABLE `[[dbprefix]]users_apisessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_guid` bigint(20) unsigned NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL,
  `token` varchar(40) DEFAULT NULL,
  `expires` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_guid` (`user_guid`,`site_guid`),
  KEY `token` (`token`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_entity`
--

CREATE TABLE `[[dbprefix]]users_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `username` varchar(128) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT 'Legacy password hashes',
  `salt` varchar(8) NOT NULL DEFAULT '' COMMENT 'Legacy password salts',
  `password_hash` varchar(255) NOT NULL DEFAULT '',
  `email` text NOT NULL,
  `language` varchar(6) NOT NULL DEFAULT '',
  `banned` enum('yes','no') NOT NULL DEFAULT 'no',
  `admin` enum('yes','no') NOT NULL DEFAULT 'no',
  `last_action` int(11) NOT NULL DEFAULT '0',
  `prev_last_action` int(11) NOT NULL DEFAULT '0',
  `last_login` int(11) NOT NULL DEFAULT '0',
  `prev_last_login` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`guid`),
  UNIQUE KEY `username` (`username`),
  KEY `password` (`password`),
  KEY `email` (`email`(50)),
  KEY `last_action` (`last_action`),
  KEY `last_login` (`last_login`),
  KEY `admin` (`admin`),
  FULLTEXT KEY `name` (`name`),
  FULLTEXT KEY `name_2` (`name`,`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]users_entity`
--

INSERT INTO `[[dbprefix]]users_entity` VALUES
(36, '[[admin_realname]]', '[[admin_username]]', '', '', '[[admin_pass]]', '[[admin_email]]', 'en', 'no', 'yes', 0, 0, [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_remember_me_cookies`
--

CREATE TABLE `[[dbprefix]]users_remember_me_cookies` (
  `code` varchar(32) NOT NULL,
  `guid` bigint(20) unsigned NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`code`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_sessions`
--

CREATE TABLE `[[dbprefix]]users_sessions` (
  `session` varchar(255) NOT NULL,
  `ts` int(11) unsigned NOT NULL DEFAULT '0',
  `data` mediumblob,
  PRIMARY KEY (`session`),
  KEY `ts` (`ts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]users_sessions`
--


/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
