<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

class ControllerCheckoutReward extends Controller {
    public function index() {
        $points = $this->customer->getRewardPoints();

        $points_total = 0;

        foreach ($this->cart->getProducts() as $product) {
            if ($product['points']) {
                $points_total += $product['points'];
            }
        }

        if ($points && $points_total && $this->config->get('reward_status')) {
            $this->load->language('checkout/reward');

            $data['heading_title'] = sprintf($this->language->get('heading_title'), $points);

            $data['text_loading'] = $this->language->get('text_loading');

            $data['entry_reward'] = sprintf($this->language->get('entry_reward'), $points_total);

            $data['button_reward'] = $this->language->get('button_reward');

            if (isset($this->session->data['reward'])) {
                $data['reward'] = $this->session->data['reward'];
            } else {
                $data['reward'] = '';
            }

            if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/checkout/reward.tpl')) {
                return $this->load->view($this->config->get('config_template') . '/template/checkout/reward.tpl', $data);
            } else {
                return $this->load->view('default/template/checkout/reward.tpl', $data);
            }
        }
    }

    public function reward() {
        $this->load->language('checkout/reward');

        $json = array();

        $points = $this->customer->getRewardPoints();

        $points_total = 0;

        foreach ($this->cart->getProducts() as $product) {
            if ($product['points']) {
                $points_total += $product['points'];
            }
        }

        if (empty($this->request->post['reward'])) {
            $json['error'] = $this->language->get('error_reward');
        }

        if ($this->request->post['reward'] > $points) {
            $json['error'] = sprintf($this->language->get('error_points'), $this->request->post['reward']);
        }

        if ($this->request->post['reward'] > $points_total) {
            $json['error'] = sprintf($this->language->get('error_maximum'), $points_total);
        }

        if (!$json) {
            $this->session->data['reward'] = abs($this->request->post['reward']);

            $this->session->data['success'] = $this->language->get('text_success');

            if (isset($this->request->post['redirect'])) {
                $json['redirect'] = $this->url->link($this->request->post['redirect']);
            } else {
                $json['redirect'] = $this->url->link('checkout/cart');    
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}
