<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="submit" onclick="save('save')" form="form-custom-field" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-success" data-original-title="Save"><i class="fa fa-check"></i></button>
                <button type="submit" form="form-custom-field" data-toggle="tooltip" title="<?php echo $button_saveclose; ?>" class="btn btn-default" data-original-title="Save & Close"><i class="fa fa-save text-success"></i></button>
                <button type="submit" onclick="save('new')" form="form-custom-field" data-toggle="tooltip" title="<?php echo $button_savenew; ?>" class="btn btn-default" data-original-title="Save & New"><i class="fa fa-plus text-success"></i></button>
                <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-times-circle text-danger"></i></a>
            </div>
            <h1><?php echo $heading_title; ?></h1>
        </div>
    </div>
    <div class="container-fluid">
        <?php if ($error_warning) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <?php if ($success) { ?>
        <div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-custom-field" class="form-horizontal">
            <div class="row">
                <div class="left-col col-sm-8">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <div class="general">
                                <ul class="nav nav-tabs" id="language">
                                    <?php foreach ($languages as $language) { ?>
                                    <li><a href="#language<?php echo $language['language_id']; ?>" data-toggle="tab"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /> <?php echo $language['name']; ?></a></li>
                                    <?php } ?>
                                </ul>
                                <div class="tab-content">
                                    <?php foreach ($languages as $language) { ?>
                                    <div class="tab-pane" id="language<?php echo $language['language_id']; ?>">
                                        <div class="form-group required">
                                            <label class="col-sm-12" for="input-name<?php echo $language['language_id']; ?>"><?php echo $entry_name; ?></label>
                                            <div class="col-sm-12">
                                                <input type="text" name="custom_field_description[<?php echo $language['language_id']; ?>][name]" value="<?php echo isset($custom_field_description[$language['language_id']]) ? $custom_field_description[$language['language_id']]['name'] : ''; ?>" placeholder="<?php echo $entry_name; ?>" class="form-control" />                                 <?php if (isset($error_name[$language['language_id']])) { ?>
                                                <div class="text-danger"><?php echo $error_name[$language['language_id']]; ?></div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo $tab_data; ?></h3>
                            <div class="pull-right">
                                <div class="panel-chevron"><i class="fa fa-chevron-up rotate-reset"></i></div>
                            </div>
                        </div>
                        <div class="panel-body">
                            <div class="data">
                                <div class="form-group">
                                    <label class="col-sm-12" for="input-location"><?php echo $entry_location; ?></label>
                                    <div class="col-sm-12">
                                        <select name="location" id="input-location" class="form-control">
                                            <?php if ($location == 'account') { ?>
                                            <option value="account" selected="selected"><?php echo $text_account; ?></option>
                                            <?php } else { ?>
                                            <option value="account"><?php echo $text_account; ?></option>
                                            <?php } ?>
                                            <?php if ($location == 'address') { ?>
                                            <option value="address" selected="selected"><?php echo $text_address; ?></option>
                                            <?php } else { ?>
                                            <option value="address"><?php echo $text_address; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-12" for="input-type"><?php echo $entry_type; ?></label>
                                    <div class="col-sm-12">
                                        <select name="type" id="input-type" class="form-control">
                                            <optgroup label="<?php echo $text_choose; ?>">
                                                <?php if ($type == 'select') { ?>
                                                <option value="select" selected="selected"><?php echo $text_select; ?></option>
                                                <?php } else { ?>
                                                <option value="select"><?php echo $text_select; ?></option>
                                                <?php } ?>
                                                <?php if ($type == 'radio') { ?>
                                                <option value="radio" selected="selected"><?php echo $text_radio; ?></option>
                                                <?php } else { ?>
                                                <option value="radio"><?php echo $text_radio; ?></option>
                                                <?php } ?>
                                                <?php if ($type == 'checkbox') { ?>
                                                <option value="checkbox" selected="selected"><?php echo $text_checkbox; ?></option>
                                                <?php } else { ?>
                                                <option value="checkbox"><?php echo $text_checkbox; ?></option>
                                                <?php } ?>
                                            </optgroup>
                                            <optgroup label="<?php echo $text_input; ?>">
                                                <?php if ($type == 'text') { ?>
                                                <option value="text" selected="selected"><?php echo $text_text; ?></option>
                                                <?php } else { ?>
                                                <option value="text"><?php echo $text_text; ?></option>
                                                <?php } ?>
                                                <?php if ($type == 'textarea') { ?>
                                                <option value="textarea" selected="selected"><?php echo $text_textarea; ?></option>
                                                <?php } else { ?>
                                                <option value="textarea"><?php echo $text_textarea; ?></option>
                                                <?php } ?>
                                            </optgroup>
                                            <optgroup label="<?php echo $text_file; ?>">
                                                <?php if ($type == 'file') { ?>
                                                <option value="file" selected="selected"><?php echo $text_file; ?></option>
                                                <?php } else { ?>
                                                <option value="file"><?php echo $text_file; ?></option>
                                                <?php } ?>
                                            </optgroup>
                                            <optgroup label="<?php echo $text_date; ?>">
                                                <?php if ($type == 'date') { ?>
                                                <option value="date" selected="selected"><?php echo $text_date; ?></option>
                                                <?php } else { ?>
                                                <option value="date"><?php echo $text_date; ?></option>
                                                <?php } ?>
                                                <?php if ($type == 'time') { ?>
                                                <option value="time" selected="selected"><?php echo $text_time; ?></option>
                                                <?php } else { ?>
                                                <option value="time"><?php echo $text_time; ?></option>
                                                <?php } ?>
                                                <?php if ($type == 'datetime') { ?>
                                                <option value="datetime" selected="selected"><?php echo $text_datetime; ?></option>
                                                <?php } else { ?>
                                                <option value="datetime"><?php echo $text_datetime; ?></option>
                                                <?php } ?>
                                            </optgroup>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group" id="display-value">
                                    <label class="col-sm-12" for="input-value"><?php echo $entry_value; ?></label>
                                    <div class="col-sm-12">
                                        <input type="text" name="value" value="<?php echo $value; ?>" placeholder="<?php echo $entry_value; ?>" id="input-value" class="form-control" />
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-12"><?php echo $entry_customer_group; ?></label>
                                    <div class="col-sm-12">
                                        <?php $customer_group_row = 0; ?>
                                        <?php foreach ($customer_groups as $customer_group) { ?>
                                        <div class="checkbox">
                                            <label>
                                                <?php if (in_array($customer_group['customer_group_id'], $custom_field_customer_group)) { ?>
                                                <input type="checkbox" name="custom_field_customer_group[<?php echo $customer_group_row; ?>][customer_group_id]" value="<?php echo $customer_group['customer_group_id']; ?>" checked="checked" />
                                                <?php echo $customer_group['name']; ?>
                                                <?php } else { ?>
                                                <input type="checkbox" name="custom_field_customer_group[<?php echo $customer_group_row; ?>][customer_group_id]" value="<?php echo $customer_group['customer_group_id']; ?>" />
                                                <?php echo $customer_group['name']; ?>
                                                <?php } ?>
                                            </label>
                                        </div>
                                        <?php $customer_group_row++; ?>
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-12"><?php echo $entry_required; ?></label>
                                    <div class="col-sm-12">
                                        <?php $customer_group_row = 0; ?>
                                        <?php foreach ($customer_groups as $customer_group) { ?>
                                        <div class="checkbox">
                                            <label>
                                                <?php if (in_array($customer_group['customer_group_id'], $custom_field_required)) { ?>
                                                <input type="checkbox" name="custom_field_customer_group[<?php echo $customer_group_row; ?>][required]" value="<?php echo $customer_group['customer_group_id']; ?>" checked="checked" />
                                                <?php echo $customer_group['name']; ?>
                                                <?php } else { ?>
                                                <input type="checkbox" name="custom_field_customer_group[<?php echo $customer_group_row; ?>][required]" value="<?php echo $customer_group['customer_group_id']; ?>" />
                                                <?php echo $customer_group['name']; ?>
                                                <?php } ?>
                                            </label>
                                        </div>
                                        <?php $customer_group_row++; ?>
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-12" for="input-sort-order"><span data-toggle="tooltip" title="<?php echo $help_sort_order; ?>"><?php echo $entry_sort_order; ?></span></label>
                                    <div class="col-sm-12">
                                        <input type="text" name="sort_order" value="<?php echo $sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
                                    </div>
                                </div>
                                <table id="custom-field-value" class="table table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <td class="text-left required"><?php echo $entry_custom_value; ?></td>
                                        <td class="text-right"><?php echo $entry_sort_order; ?></td>
                                        <td></td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $custom_field_value_row = 0; ?>
                                    <?php foreach ($custom_field_values as $custom_field_value) { ?>
                                    <tr id="custom-field-value-row<?php echo $custom_field_value_row; ?>">
                                        <td class="text-left" style="width: 70%;"><input type="hidden" name="custom_field_value[<?php echo $custom_field_value_row; ?>][custom_field_value_id]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" />
                                            <?php foreach ($languages as $language) { ?>
                                            <div class="input-group"> <span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
                                                <input type="text" name="custom_field_value[<?php echo $custom_field_value_row; ?>][custom_field_value_description][<?php echo $language['language_id']; ?>][name]" value="<?php echo isset($custom_field_value['custom_field_value_description'][$language['language_id']]) ? $custom_field_value['custom_field_value_description'][$language['language_id']]['name'] : ''; ?>" placeholder="<?php echo $entry_custom_value; ?>" class="form-control" />
                                            </div>
                                            <?php if (isset($error_custom_field_value[$custom_field_value_row][$language['language_id']])) { ?>
                                            <div class="text-danger"><?php echo $error_custom_field_value[$custom_field_value_row][$language['language_id']]; ?></div>
                                            <?php } ?>
                                            <?php } ?></td>
                                        <td class="text-right hidden"><input type="text" name="custom_field_value[<?php echo $custom_field_value_row; ?>][sort_order]" value="<?php echo $custom_field_value['sort_order']; ?>" placeholder="<?php echo $entry_sort_order; ?>" class="form-control" /></td>
                                        <td class="text-left"><a onclick="$('#custom-field-value-row<?php echo $custom_field_value_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger btn-sm btn-basic-list"><i class="fa fa-minus-circle"></i></a></td>
                                    </tr>
                                    <?php $custom_field_value_row++; ?>
                                    <?php } ?>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="1"></td>
                                        <td class="text-left"><a onclick="addCustomFieldValue();" data-toggle="tooltip" title="<?php echo $button_custom_field_value_add; ?>" class="btn btn-primary btn-sm btn-basic-list"><i class="fa fa-plus-circle"></i></a></td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="right-col col-sm-4">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo $text_publish; ?></h3>
                            <div class="pull-right">
                                <div class="panel-chevron"><i class="fa fa-chevron-up rotate-reset"></i></div>
                            </div>
                        </div>
                        <div class="panel-body">
                            <div class="publish">
                                <div class="form-group">
                                    <label class="col-sm-12"><?php echo $text_enabled; ?></label>
                                    <div class="col-sm-12">
                                        <label class="radio-inline">
                                            <?php if ($status) { ?>
                                            <input type="radio" name="status" value="1" checked="checked" />
                                            <?php echo $text_enabled; ?>
                                            <?php } else { ?>
                                            <input type="radio" name="status" value="1" />
                                            <?php echo $text_enabled; ?>
                                            <?php } ?>
                                        </label>
                                        <label class="radio-inline">
                                            <?php if (!$status) { ?>
                                            <input type="radio" name="status" value="0" checked="checked" />
                                            <?php echo $text_disabled; ?>
                                            <?php } else { ?>
                                            <input type="radio" name="status" value="0" />
                                            <?php echo $text_disabled; ?>
                                            <?php } ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script type="text/javascript"><!--
    $('select[name=\'type\']').on('change', function() {
        if (this.value == 'select' || this.value == 'radio' || this.value == 'checkbox') {
            $('#custom-field-value').show();
            $('#display-value').hide();
        } else {
            $('#custom-field-value').hide();
            $('#display-value').show();
        }

        if (this.value == 'date') {
            $('#display-value > div').html('<div class="input-group date"><input type="text" name="value" value="' + $('#input-value').val() + '" placeholder="<?php echo $entry_value; ?>" data-date-format="YYYY-MM-DD" id="input-value" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div>');
        } else if (this.value == 'time') {
            $('#display-value > div').html('<div class="input-group time"><input type="text" name="value" value="' + $('#input-value').val() + '" placeholder="<?php echo $entry_value; ?>" data-date-format="HH:mm" id="input-value" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div>');
        } else if (this.value == 'datetime') {
            $('#display-value > div').html('<div class="input-group datetime"><input type="text" name="value" value="' + $('#input-value').val() + '" placeholder="<?php echo $entry_value; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-value" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div>');
        } else if (this.value == 'textarea') {
            $('#display-value > div').html('<textarea name="value" placeholder="<?php echo $entry_value; ?>" id="input-value" class="form-control">' + $('#input-value').val() + '</textarea>');
        } else {
            $('#display-value > div').html('<input type="text" name="value" value="' + $('#input-value').val() + '" placeholder="<?php echo $entry_value; ?>" id="input-value" class="form-control" />');
        }

        $('.date').datetimepicker({
            pickTime: false
        });

        $('.time').datetimepicker({
            pickDate: false
        });

        $('.datetime').datetimepicker({
            pickDate: true,
            pickTime: true
        });
    });

    $('select[name=\'type\']').trigger('change');

    var custom_field_value_row = <?php echo $custom_field_value_row; ?>;

    function addCustomFieldValue() {
        html  = '<tr id="custom-field-value-row' + custom_field_value_row + '">';
        html += '  <td class="text-left" style="width: 70%;"><input type="hidden" name="custom_field_value[' + custom_field_value_row + '][custom_field_value_id]" value="" />';
        <?php foreach ($languages as $language) { ?>
        html += '    <div class="input-group">';
        html += '      <span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span><input type="text" name="custom_field_value[' + custom_field_value_row + '][custom_field_value_description][<?php echo $language['language_id']; ?>][name]" value="" placeholder="<?php echo $entry_custom_value; ?>" class="form-control" />';
        html += '    </div>';
        <?php } ?>
        html += '  </td>';
        html += '  <td class="text-right hidden"><input type="text" name="custom_field_value[' + custom_field_value_row + '][sort_order]" value="" placeholder="<?php echo $entry_sort_order; ?>" class="form-control" /></td>';
        html += '  <td class="text-left"><a onclick="$(\'#custom-field-value-row' + custom_field_value_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger btn-sm btn-basic-list"><i class="fa fa-minus-circle"></i></a></td>';
        html += '</tr>';

        $('#custom-field-value tbody').append(html);

        custom_field_value_row++;
    }
    //--></script></div>
<script type="text/javascript"><!--
$('#language a:first').tab('show');
//--></script>
<?php echo $footer; ?>
