<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

class ControllerReportAffiliate extends Controller {
    public function index() {
        $this->load->language('report/affiliate');

        $this->document->setTitle($this->language->get('heading_title'));

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = '';
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_start'])) {
            $url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
        }

        if (isset($this->request->get['filter_date_end'])) {
            $url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('report/affiliate', 'token=' . $this->session->data['token'] . $url, 'SSL')
        );

        $this->load->model('report/affiliate');

        $data['affiliates'] = array();

        $filter_data = array(
            'filter_date_start'    => $filter_date_start,
            'filter_date_end'    => $filter_date_end,
            'start'             => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'             => $this->config->get('config_limit_admin')
        );

        $affiliate_total = $this->model_report_affiliate->getTotalCommission($filter_data);

        $results = $this->model_report_affiliate->getCommission($filter_data);

        foreach ($results as $result) {
            $data['affiliates'][] = array(
                'affiliate'  => $result['affiliate'],
                'email'      => $result['email'],
                'status'     => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
                'commission' => $this->currency->format($result['commission'], $this->config->get('config_currency')),
                'orders'     => $result['orders'],
                'total'      => $this->currency->format($result['total'], $this->config->get('config_currency')),
                'edit'       => $this->url->link('marketing/affiliate/edit', 'token=' . $this->session->data['token'] . '&affiliate_id=' . $result['affiliate_id'] . $url, 'SSL')
            );
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_filter'] = $this->language->get('text_filter');

        $data['column_affiliate'] = $this->language->get('column_affiliate');
        $data['column_email'] = $this->language->get('column_email');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_commission'] = $this->language->get('column_commission');
        $data['column_orders'] = $this->language->get('column_orders');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_action'] = $this->language->get('column_action');

        $data['entry_date_start'] = $this->language->get('entry_date_start');
        $data['entry_date_end'] = $this->language->get('entry_date_end');

        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_output'] = $this->language->get('button_output');
        $data['button_export'] = $this->language->get('button_export');
        $data['button_show_filter'] = $this->language->get('button_show_filter');
        $data['button_hide_filter'] = $this->language->get('button_hide_filter');

        $data['token'] = $this->session->data['token'];

        $url = '';

        if (isset($this->request->get['filter_date_start'])) {
            $url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
        }

        if (isset($this->request->get['filter_date_end'])) {
            $url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
        }

        $pagination = new Pagination();
        $pagination->total = $affiliate_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('report/affiliate', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($affiliate_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($affiliate_total - $this->config->get('config_limit_admin'))) ? $affiliate_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $affiliate_total, ceil($affiliate_total / $this->config->get('config_limit_admin')));

        $data['filter_date_start'] = $filter_date_start;
        $data['filter_date_end'] = $filter_date_end;

        $graph = array(
            'sales' => array(
                'model'            => 'affiliate',
                'function'         => 'commission',
                'title'            => $this->language->get('text_sale'),
                'link'             => str_replace('&amp;', '&', $this->url->link('report/graph/graph', 'title=affiliate&range=special&token=' . $this->session->data['token'] . '&' . http_build_query($filter_data) . '&page=' . $page, 'SSL')),
                'color'            => '#008db9',
                'background-color' => '#FFFFFF',
                'total'            => 'total',
                'price'            => true
            ),
            'orders'   => array(
                'model'            => 'affiliate',
                'function'         => 'commission',
                'title'            => $this->language->get('text_order'),
                'link'             => str_replace('&amp;', '&', $this->url->link('report/graph/graph', 'title=affiliate&range=special&token=' . $this->session->data['token'] . '&' . http_build_query($filter_data) . '&page=' . $page, 'SSL')),
                'color'            => '#5cb85c',
                'background-color' => '#FFFFFF',
                'total'            => 'orders',
                'price'            => false
            ),
            'commission' => array(
                'model'            => 'affiliate',
                'function'         => 'commission',
                'title'            => $this->language->get('text_commission'),
                'link'             => str_replace('&amp;', '&', $this->url->link('report/graph/graph', 'title=affiliate&range=special&token=' . $this->session->data['token'] . '&' . http_build_query($filter_data) . '&page=' . $page, 'SSL')),
                'color'            => '#d9534f',
                'background-color' => '#FFFFFF',
                'total'            => 'commission',
                'price'            => true
            )
        );

        $data['graph'] = $this->load->controller('report/graph', $graph);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('report/affiliate.tpl', $data));
    }
}
