<?php
/**
 * ShipmentResultsPackageResults
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentResultsPackageResults Class Doc Comment
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentResultsPackageResults implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipmentResults_PackageResults';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'tracking_number' => 'string',
        'rate_modifier' => '\UPS\Shipping\Shipping\PackageResultsRateModifier[]',
        'base_service_charge' => '\UPS\Shipping\Shipping\PackageResultsBaseServiceCharge',
        'service_options_charges' => '\UPS\Shipping\Shipping\PackageResultsServiceOptionsCharges',
        'shipping_label' => '\UPS\Shipping\Shipping\PackageResultsShippingLabel',
        'shipping_receipt' => '\UPS\Shipping\Shipping\PackageResultsShippingReceipt',
        'uspspic_number' => 'string',
        'cn22_number' => 'string',
        'accessorial' => '\UPS\Shipping\Shipping\PackageResultsAccessorial[]',
        'simple_rate' => '\UPS\Shipping\Shipping\PackageResultsSimpleRate',
        'form' => '\UPS\Shipping\Shipping\PackageResultsForm',
        'itemized_charges' => '\UPS\Shipping\Shipping\PackageResultsItemizedCharges[]',
        'negotiated_charges' => '\UPS\Shipping\Shipping\PackageResultsNegotiatedCharges'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'tracking_number' => null,
        'rate_modifier' => null,
        'base_service_charge' => null,
        'service_options_charges' => null,
        'shipping_label' => null,
        'shipping_receipt' => null,
        'uspspic_number' => null,
        'cn22_number' => null,
        'accessorial' => null,
        'simple_rate' => null,
        'form' => null,
        'itemized_charges' => null,
        'negotiated_charges' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tracking_number' => 'TrackingNumber',
        'rate_modifier' => 'RateModifier',
        'base_service_charge' => 'BaseServiceCharge',
        'service_options_charges' => 'ServiceOptionsCharges',
        'shipping_label' => 'ShippingLabel',
        'shipping_receipt' => 'ShippingReceipt',
        'uspspic_number' => 'USPSPICNumber',
        'cn22_number' => 'CN22Number',
        'accessorial' => 'Accessorial',
        'simple_rate' => 'SimpleRate',
        'form' => 'Form',
        'itemized_charges' => 'ItemizedCharges',
        'negotiated_charges' => 'NegotiatedCharges'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tracking_number' => 'setTrackingNumber',
        'rate_modifier' => 'setRateModifier',
        'base_service_charge' => 'setBaseServiceCharge',
        'service_options_charges' => 'setServiceOptionsCharges',
        'shipping_label' => 'setShippingLabel',
        'shipping_receipt' => 'setShippingReceipt',
        'uspspic_number' => 'setUspspicNumber',
        'cn22_number' => 'setCn22Number',
        'accessorial' => 'setAccessorial',
        'simple_rate' => 'setSimpleRate',
        'form' => 'setForm',
        'itemized_charges' => 'setItemizedCharges',
        'negotiated_charges' => 'setNegotiatedCharges'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tracking_number' => 'getTrackingNumber',
        'rate_modifier' => 'getRateModifier',
        'base_service_charge' => 'getBaseServiceCharge',
        'service_options_charges' => 'getServiceOptionsCharges',
        'shipping_label' => 'getShippingLabel',
        'shipping_receipt' => 'getShippingReceipt',
        'uspspic_number' => 'getUspspicNumber',
        'cn22_number' => 'getCn22Number',
        'accessorial' => 'getAccessorial',
        'simple_rate' => 'getSimpleRate',
        'form' => 'getForm',
        'itemized_charges' => 'getItemizedCharges',
        'negotiated_charges' => 'getNegotiatedCharges'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tracking_number'] = isset($data['tracking_number']) ? $data['tracking_number'] : null;
        $this->container['rate_modifier'] = isset($data['rate_modifier']) ? $data['rate_modifier'] : null;
        $this->container['base_service_charge'] = isset($data['base_service_charge']) ? $data['base_service_charge'] : null;
        $this->container['service_options_charges'] = isset($data['service_options_charges']) ? $data['service_options_charges'] : null;
        $this->container['shipping_label'] = isset($data['shipping_label']) ? $data['shipping_label'] : null;
        $this->container['shipping_receipt'] = isset($data['shipping_receipt']) ? $data['shipping_receipt'] : null;
        $this->container['uspspic_number'] = isset($data['uspspic_number']) ? $data['uspspic_number'] : null;
        $this->container['cn22_number'] = isset($data['cn22_number']) ? $data['cn22_number'] : null;
        $this->container['accessorial'] = isset($data['accessorial']) ? $data['accessorial'] : null;
        $this->container['simple_rate'] = isset($data['simple_rate']) ? $data['simple_rate'] : null;
        $this->container['form'] = isset($data['form']) ? $data['form'] : null;
        $this->container['itemized_charges'] = isset($data['itemized_charges']) ? $data['itemized_charges'] : null;
        $this->container['negotiated_charges'] = isset($data['negotiated_charges']) ? $data['negotiated_charges'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['tracking_number'] === null) {
            $invalidProperties[] = "'tracking_number' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tracking_number
     *
     * @return string
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string $tracking_number Package 1Z number.   For Mail Innovations shipments, please use the USPSPICNumber when tracking packages (a non-1Z number Mail Manifest Id is returned).
     *
     * @return $this
     */
    public function setTrackingNumber($tracking_number)
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets rate_modifier
     *
     * @return \UPS\Shipping\Shipping\PackageResultsRateModifier[]
     */
    public function getRateModifier()
    {
        return $this->container['rate_modifier'];
    }

    /**
     * Sets rate_modifier
     *
     * @param \UPS\Shipping\Shipping\PackageResultsRateModifier[] $rate_modifier Returned Package Information.  **NOTE:** For versions >= v2403, this element will always be returned as an array. For requests using versions < v2403, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setRateModifier($rate_modifier)
    {
        $this->container['rate_modifier'] = $rate_modifier;

        return $this;
    }

    /**
     * Gets base_service_charge
     *
     * @return \UPS\Shipping\Shipping\PackageResultsBaseServiceCharge
     */
    public function getBaseServiceCharge()
    {
        return $this->container['base_service_charge'];
    }

    /**
     * Sets base_service_charge
     *
     * @param \UPS\Shipping\Shipping\PackageResultsBaseServiceCharge $base_service_charge base_service_charge
     *
     * @return $this
     */
    public function setBaseServiceCharge($base_service_charge)
    {
        $this->container['base_service_charge'] = $base_service_charge;

        return $this;
    }

    /**
     * Gets service_options_charges
     *
     * @return \UPS\Shipping\Shipping\PackageResultsServiceOptionsCharges
     */
    public function getServiceOptionsCharges()
    {
        return $this->container['service_options_charges'];
    }

    /**
     * Sets service_options_charges
     *
     * @param \UPS\Shipping\Shipping\PackageResultsServiceOptionsCharges $service_options_charges service_options_charges
     *
     * @return $this
     */
    public function setServiceOptionsCharges($service_options_charges)
    {
        $this->container['service_options_charges'] = $service_options_charges;

        return $this;
    }

    /**
     * Gets shipping_label
     *
     * @return \UPS\Shipping\Shipping\PackageResultsShippingLabel
     */
    public function getShippingLabel()
    {
        return $this->container['shipping_label'];
    }

    /**
     * Sets shipping_label
     *
     * @param \UPS\Shipping\Shipping\PackageResultsShippingLabel $shipping_label shipping_label
     *
     * @return $this
     */
    public function setShippingLabel($shipping_label)
    {
        $this->container['shipping_label'] = $shipping_label;

        return $this;
    }

    /**
     * Gets shipping_receipt
     *
     * @return \UPS\Shipping\Shipping\PackageResultsShippingReceipt
     */
    public function getShippingReceipt()
    {
        return $this->container['shipping_receipt'];
    }

    /**
     * Sets shipping_receipt
     *
     * @param \UPS\Shipping\Shipping\PackageResultsShippingReceipt $shipping_receipt shipping_receipt
     *
     * @return $this
     */
    public function setShippingReceipt($shipping_receipt)
    {
        $this->container['shipping_receipt'] = $shipping_receipt;

        return $this;
    }

    /**
     * Gets uspspic_number
     *
     * @return string
     */
    public function getUspspicNumber()
    {
        return $this->container['uspspic_number'];
    }

    /**
     * Sets uspspic_number
     *
     * @param string $uspspic_number USPSPICNumber is USPS Package Identification; it should be used for tracking Mail Innovations shipments.
     *
     * @return $this
     */
    public function setUspspicNumber($uspspic_number)
    {
        $this->container['uspspic_number'] = $uspspic_number;

        return $this;
    }

    /**
     * Gets cn22_number
     *
     * @return string
     */
    public function getCn22Number()
    {
        return $this->container['cn22_number'];
    }

    /**
     * Sets cn22_number
     *
     * @param string $cn22_number USPS defined CN22 ID number format varies based on destination country or territory.  Not applicable as of Jan 2015.  Mail Innovations shipments US to VI, PR, and GU are not considered international.
     *
     * @return $this
     */
    public function setCn22Number($cn22_number)
    {
        $this->container['cn22_number'] = $cn22_number;

        return $this;
    }

    /**
     * Gets accessorial
     *
     * @return \UPS\Shipping\Shipping\PackageResultsAccessorial[]
     */
    public function getAccessorial()
    {
        return $this->container['accessorial'];
    }

    /**
     * Sets accessorial
     *
     * @param \UPS\Shipping\Shipping\PackageResultsAccessorial[] $accessorial The container for Accessorial indicators. This information would be returned only for UPS Worldwide Express Freight and UPS Worldwide Express Freight Mid-day service request with Dry Ice or Oversize Pallet and SubVersion greater than or equal to 1707. This is valid only for UPS Worldwide Express Freight and UPS Worldwide Express Freight Mid-day service.  **NOTE:** For versions >= v2403, this element will always be returned as an array. For requests using versions < v2403, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setAccessorial($accessorial)
    {
        $this->container['accessorial'] = $accessorial;

        return $this;
    }

    /**
     * Gets simple_rate
     *
     * @return \UPS\Shipping\Shipping\PackageResultsSimpleRate
     */
    public function getSimpleRate()
    {
        return $this->container['simple_rate'];
    }

    /**
     * Sets simple_rate
     *
     * @param \UPS\Shipping\Shipping\PackageResultsSimpleRate $simple_rate simple_rate
     *
     * @return $this
     */
    public function setSimpleRate($simple_rate)
    {
        $this->container['simple_rate'] = $simple_rate;

        return $this;
    }

    /**
     * Gets form
     *
     * @return \UPS\Shipping\Shipping\PackageResultsForm
     */
    public function getForm()
    {
        return $this->container['form'];
    }

    /**
     * Sets form
     *
     * @param \UPS\Shipping\Shipping\PackageResultsForm $form form
     *
     * @return $this
     */
    public function setForm($form)
    {
        $this->container['form'] = $form;

        return $this;
    }

    /**
     * Gets itemized_charges
     *
     * @return \UPS\Shipping\Shipping\PackageResultsItemizedCharges[]
     */
    public function getItemizedCharges()
    {
        return $this->container['itemized_charges'];
    }

    /**
     * Sets itemized_charges
     *
     * @param \UPS\Shipping\Shipping\PackageResultsItemizedCharges[] $itemized_charges Itemized Charges are returned only when the subversion element is present and greater than or equal to 1607. Package level itemized charges are only returned for US domestic movements.  **NOTE:** For versions >= v2403, this element will always be returned as an array. For requests using versions < v2403, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setItemizedCharges($itemized_charges)
    {
        $this->container['itemized_charges'] = $itemized_charges;

        return $this;
    }

    /**
     * Gets negotiated_charges
     *
     * @return \UPS\Shipping\Shipping\PackageResultsNegotiatedCharges
     */
    public function getNegotiatedCharges()
    {
        return $this->container['negotiated_charges'];
    }

    /**
     * Sets negotiated_charges
     *
     * @param \UPS\Shipping\Shipping\PackageResultsNegotiatedCharges $negotiated_charges negotiated_charges
     *
     * @return $this
     */
    public function setNegotiatedCharges($negotiated_charges)
    {
        $this->container['negotiated_charges'] = $negotiated_charges;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
