<?php
/**
 * ShipmentRequestLabelSpecification
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentRequestLabelSpecification Class Doc Comment
 *
 * @category Class
 * @description Container used to define the properties required by the user to print and/or display the UPS shipping label.  Required for shipment without return service or shipments with PRL return service. Required for Electronic Return Label or Electronic Import Control Label shipments with SubVersion greater than or equal to 1707.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentRequestLabelSpecification implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipmentRequest_LabelSpecification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'label_image_format' => '\UPS\Shipping\Shipping\LabelSpecificationLabelImageFormat',
        'http_user_agent' => 'string',
        'label_stock_size' => '\UPS\Shipping\Shipping\LabelSpecificationLabelStockSize',
        'instruction' => '\UPS\Shipping\Shipping\LabelSpecificationInstruction[]',
        'character_set' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'label_image_format' => null,
        'http_user_agent' => null,
        'label_stock_size' => null,
        'instruction' => null,
        'character_set' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'label_image_format' => 'LabelImageFormat',
        'http_user_agent' => 'HTTPUserAgent',
        'label_stock_size' => 'LabelStockSize',
        'instruction' => 'Instruction',
        'character_set' => 'CharacterSet'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'label_image_format' => 'setLabelImageFormat',
        'http_user_agent' => 'setHttpUserAgent',
        'label_stock_size' => 'setLabelStockSize',
        'instruction' => 'setInstruction',
        'character_set' => 'setCharacterSet'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'label_image_format' => 'getLabelImageFormat',
        'http_user_agent' => 'getHttpUserAgent',
        'label_stock_size' => 'getLabelStockSize',
        'instruction' => 'getInstruction',
        'character_set' => 'getCharacterSet'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label_image_format'] = isset($data['label_image_format']) ? $data['label_image_format'] : null;
        $this->container['http_user_agent'] = isset($data['http_user_agent']) ? $data['http_user_agent'] : null;
        $this->container['label_stock_size'] = isset($data['label_stock_size']) ? $data['label_stock_size'] : null;
        $this->container['instruction'] = isset($data['instruction']) ? $data['instruction'] : null;
        $this->container['character_set'] = isset($data['character_set']) ? $data['character_set'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['label_image_format'] === null) {
            $invalidProperties[] = "'label_image_format' can't be null";
        }
        if ($this->container['label_stock_size'] === null) {
            $invalidProperties[] = "'label_stock_size' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets label_image_format
     *
     * @return \UPS\Shipping\Shipping\LabelSpecificationLabelImageFormat
     */
    public function getLabelImageFormat()
    {
        return $this->container['label_image_format'];
    }

    /**
     * Sets label_image_format
     *
     * @param \UPS\Shipping\Shipping\LabelSpecificationLabelImageFormat $label_image_format label_image_format
     *
     * @return $this
     */
    public function setLabelImageFormat($label_image_format)
    {
        $this->container['label_image_format'] = $label_image_format;

        return $this;
    }

    /**
     * Gets http_user_agent
     *
     * @return string
     */
    public function getHttpUserAgent()
    {
        return $this->container['http_user_agent'];
    }

    /**
     * Sets http_user_agent
     *
     * @param string $http_user_agent Browser HTTPUserAgent String. This is the preferred way of identifying GIF image type to be generated.  Required if /ShipmentRequest/LabelSpecificationLabelSpecification/LabelImageFormat/Code = Gif. Default to Mozilla/4.5 if this field is missing or has invalid value.
     *
     * @return $this
     */
    public function setHttpUserAgent($http_user_agent)
    {
        $this->container['http_user_agent'] = $http_user_agent;

        return $this;
    }

    /**
     * Gets label_stock_size
     *
     * @return \UPS\Shipping\Shipping\LabelSpecificationLabelStockSize
     */
    public function getLabelStockSize()
    {
        return $this->container['label_stock_size'];
    }

    /**
     * Sets label_stock_size
     *
     * @param \UPS\Shipping\Shipping\LabelSpecificationLabelStockSize $label_stock_size label_stock_size
     *
     * @return $this
     */
    public function setLabelStockSize($label_stock_size)
    {
        $this->container['label_stock_size'] = $label_stock_size;

        return $this;
    }

    /**
     * Gets instruction
     *
     * @return \UPS\Shipping\Shipping\LabelSpecificationInstruction[]
     */
    public function getInstruction()
    {
        return $this->container['instruction'];
    }

    /**
     * Sets instruction
     *
     * @param \UPS\Shipping\Shipping\LabelSpecificationInstruction[] $instruction instruction
     *
     * @return $this
     */
    public function setInstruction($instruction)
    {
        $this->container['instruction'] = $instruction;

        return $this;
    }

    /**
     * Gets character_set
     *
     * @return string
     */
    public function getCharacterSet()
    {
        return $this->container['character_set'];
    }

    /**
     * Sets character_set
     *
     * @param string $character_set Language character set expected on label. Valid values: dan = Danish (Latin-1) nld = Dutch (Latin-1) fin = Finnish (Latin-1) fra = French (Latin-1) deu = German (Latin-1) itl = Italian (Latin-1) nor = Norwegian (Latin-1) pol  = Polish (Latin-2) por = Poruguese (Latin-1) spa = Spanish (Latin-1)  swe = Swedish (Latin-1)  ces = Czech (Latin-2) hun = Hungarian (Latin-2) slk = Slovak (Latin-2) rus = Russian (Cyrillic) tur = Turkish (Latin-5) ron = Romanian (Latin-2) bul = Bulgarian (Latin-2) est = Estonian (Latin-2) ell = Greek (Latin-2) lav = Latvian (Latin-2) lit = Lithuanian (Latin-2) eng = English (Latin-1)  Default is English (Latin-1).
     *
     * @return $this
     */
    public function setCharacterSet($character_set)
    {
        $this->container['character_set'] = $character_set;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
