<?php
/**
 * ShippingApi
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Request;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use UPS\Shipping\ApiException;
use UPS\Shipping\Configuration;
use UPS\Shipping\HeaderSelector;
use UPS\Shipping\ObjectSerializer;

/**
 * ShippingApi Class Doc Comment
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShippingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deprecatedShipment
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $deprecated_version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v1 - v1601 - v1607 - v1701 - v1707 - v1801 - v1807 - v2108 - v2205 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Shipping\Shipping\SHIPResponseWrapper
     */
    public function deprecatedShipment($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        list($response) = $this->deprecatedShipmentWithHttpInfo($body, $deprecated_version, $trans_id, $transaction_src, $additionaladdressvalidation);
        return $response;
    }

    /**
     * Operation deprecatedShipmentWithHttpInfo
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $deprecated_version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v1 - v1601 - v1607 - v1701 - v1707 - v1801 - v1807 - v2108 - v2205 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Shipping\Shipping\SHIPResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function deprecatedShipmentWithHttpInfo($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        $returnType = '\UPS\Shipping\Shipping\SHIPResponseWrapper';
        $request = $this->deprecatedShipmentRequest($body, $deprecated_version, $trans_id, $transaction_src, $additionaladdressvalidation);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\SHIPResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deprecatedShipmentAsync
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $deprecated_version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v1 - v1601 - v1607 - v1701 - v1707 - v1801 - v1807 - v2108 - v2205 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedShipmentAsync($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        return $this->deprecatedShipmentAsyncWithHttpInfo($body, $deprecated_version, $trans_id, $transaction_src, $additionaladdressvalidation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deprecatedShipmentAsyncWithHttpInfo
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $deprecated_version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v1 - v1601 - v1607 - v1701 - v1707 - v1801 - v1807 - v2108 - v2205 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedShipmentAsyncWithHttpInfo($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        $returnType = '\UPS\Shipping\Shipping\SHIPResponseWrapper';
        $request = $this->deprecatedShipmentRequest($body, $deprecated_version, $trans_id, $transaction_src, $additionaladdressvalidation);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deprecatedShipment'
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $deprecated_version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v1 - v1601 - v1607 - v1701 - v1707 - v1801 - v1807 - v2108 - v2205 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deprecatedShipmentRequest($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling deprecatedShipment'
            );
        }
        // verify the required parameter 'deprecated_version' is set
        if ($deprecated_version === null || (is_array($deprecated_version) && count($deprecated_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deprecated_version when calling deprecatedShipment'
            );
        }

        $resourcePath = '/shipments/{deprecatedVersion}/ship';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($additionaladdressvalidation !== null) {
            $queryParams['additionaladdressvalidation'] = ObjectSerializer::toQueryValue($additionaladdressvalidation, null);
        }
        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($deprecated_version !== null) {
            $resourcePath = str_replace(
                '{' . 'deprecatedVersion' . '}',
                ObjectSerializer::toPathValue($deprecated_version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deprecatedVoidShipment
     *
     * Void Shipment
     *
     * @param  string $deprecated_version API Version.  Valid values: - v1 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper
     */
    public function deprecatedVoidShipment($deprecated_version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        list($response) = $this->deprecatedVoidShipmentWithHttpInfo($deprecated_version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber);
        return $response;
    }

    /**
     * Operation deprecatedVoidShipmentWithHttpInfo
     *
     * Void Shipment
     *
     * @param  string $deprecated_version API Version.  Valid values: - v1 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function deprecatedVoidShipmentWithHttpInfo($deprecated_version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        $returnType = '\UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper';
        $request = $this->deprecatedVoidShipmentRequest($deprecated_version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deprecatedVoidShipmentAsync
     *
     * Void Shipment
     *
     * @param  string $deprecated_version API Version.  Valid values: - v1 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedVoidShipmentAsync($deprecated_version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        return $this->deprecatedVoidShipmentAsyncWithHttpInfo($deprecated_version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deprecatedVoidShipmentAsyncWithHttpInfo
     *
     * Void Shipment
     *
     * @param  string $deprecated_version API Version.  Valid values: - v1 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedVoidShipmentAsyncWithHttpInfo($deprecated_version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        $returnType = '\UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper';
        $request = $this->deprecatedVoidShipmentRequest($deprecated_version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deprecatedVoidShipment'
     *
     * @param  string $deprecated_version API Version.  Valid values: - v1 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deprecatedVoidShipmentRequest($deprecated_version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        // verify the required parameter 'deprecated_version' is set
        if ($deprecated_version === null || (is_array($deprecated_version) && count($deprecated_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deprecated_version when calling deprecatedVoidShipment'
            );
        }
        // verify the required parameter 'shipmentidentificationnumber' is set
        if ($shipmentidentificationnumber === null || (is_array($shipmentidentificationnumber) && count($shipmentidentificationnumber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipmentidentificationnumber when calling deprecatedVoidShipment'
            );
        }

        $resourcePath = '/shipments/{deprecatedVersion}/void/cancel/{shipmentidentificationnumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($trackingnumber !== null) {
            $queryParams['trackingnumber'] = ObjectSerializer::toQueryValue($trackingnumber, null);
        }
        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($deprecated_version !== null) {
            $resourcePath = str_replace(
                '{' . 'deprecatedVersion' . '}',
                ObjectSerializer::toPathValue($deprecated_version),
                $resourcePath
            );
        }
        // path params
        if ($shipmentidentificationnumber !== null) {
            $resourcePath = str_replace(
                '{' . 'shipmentidentificationnumber' . '}',
                ObjectSerializer::toPathValue($shipmentidentificationnumber),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation labelRecovery
     *
     * Label Recovery
     *
     * @param  \UPS\Shipping\Shipping\LABELRECOVERYRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version When UPS introduces new elements in the  response that are not associated with new  request elements, Subversion is used. This  ensures backward compatibility.  v1  original features of the application. No  support for CODTurn-inPage, HighValueReport  or InternationalForms features returned in the  response v1701  includes support for CODTurn-inPage  features returned in the response. V1903  Length 5 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Shipping\Shipping\LABELRECOVERYResponseWrapper
     */
    public function labelRecovery($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        list($response) = $this->labelRecoveryWithHttpInfo($body, $version, $trans_id, $transaction_src);
        return $response;
    }

    /**
     * Operation labelRecoveryWithHttpInfo
     *
     * Label Recovery
     *
     * @param  \UPS\Shipping\Shipping\LABELRECOVERYRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version When UPS introduces new elements in the  response that are not associated with new  request elements, Subversion is used. This  ensures backward compatibility.  v1  original features of the application. No  support for CODTurn-inPage, HighValueReport  or InternationalForms features returned in the  response v1701  includes support for CODTurn-inPage  features returned in the response. V1903  Length 5 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Shipping\Shipping\LABELRECOVERYResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function labelRecoveryWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Shipping\Shipping\LABELRECOVERYResponseWrapper';
        $request = $this->labelRecoveryRequest($body, $version, $trans_id, $transaction_src);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\LABELRECOVERYResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation labelRecoveryAsync
     *
     * Label Recovery
     *
     * @param  \UPS\Shipping\Shipping\LABELRECOVERYRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version When UPS introduces new elements in the  response that are not associated with new  request elements, Subversion is used. This  ensures backward compatibility.  v1  original features of the application. No  support for CODTurn-inPage, HighValueReport  or InternationalForms features returned in the  response v1701  includes support for CODTurn-inPage  features returned in the response. V1903  Length 5 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function labelRecoveryAsync($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        return $this->labelRecoveryAsyncWithHttpInfo($body, $version, $trans_id, $transaction_src)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation labelRecoveryAsyncWithHttpInfo
     *
     * Label Recovery
     *
     * @param  \UPS\Shipping\Shipping\LABELRECOVERYRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version When UPS introduces new elements in the  response that are not associated with new  request elements, Subversion is used. This  ensures backward compatibility.  v1  original features of the application. No  support for CODTurn-inPage, HighValueReport  or InternationalForms features returned in the  response v1701  includes support for CODTurn-inPage  features returned in the response. V1903  Length 5 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function labelRecoveryAsyncWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Shipping\Shipping\LABELRECOVERYResponseWrapper';
        $request = $this->labelRecoveryRequest($body, $version, $trans_id, $transaction_src);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'labelRecovery'
     *
     * @param  \UPS\Shipping\Shipping\LABELRECOVERYRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version When UPS introduces new elements in the  response that are not associated with new  request elements, Subversion is used. This  ensures backward compatibility.  v1  original features of the application. No  support for CODTurn-inPage, HighValueReport  or InternationalForms features returned in the  response v1701  includes support for CODTurn-inPage  features returned in the response. V1903  Length 5 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function labelRecoveryRequest($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling labelRecovery'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling labelRecovery'
            );
        }

        $resourcePath = '/labels/{version}/recovery';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation shipment
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v2409 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Shipping\Shipping\SHIPResponseWrapper
     */
    public function shipment($body, $version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        list($response) = $this->shipmentWithHttpInfo($body, $version, $trans_id, $transaction_src, $additionaladdressvalidation);
        return $response;
    }

    /**
     * Operation shipmentWithHttpInfo
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v2409 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Shipping\Shipping\SHIPResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function shipmentWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        $returnType = '\UPS\Shipping\Shipping\SHIPResponseWrapper';
        $request = $this->shipmentRequest($body, $version, $trans_id, $transaction_src, $additionaladdressvalidation);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\SHIPResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation shipmentAsync
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v2409 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function shipmentAsync($body, $version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        return $this->shipmentAsyncWithHttpInfo($body, $version, $trans_id, $transaction_src, $additionaladdressvalidation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation shipmentAsyncWithHttpInfo
     *
     * Shipment
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v2409 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function shipmentAsyncWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        $returnType = '\UPS\Shipping\Shipping\SHIPResponseWrapper';
        $request = $this->shipmentRequest($body, $version, $trans_id, $transaction_src, $additionaladdressvalidation);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'shipment'
     *
     * @param  \UPS\Shipping\Shipping\SHIPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  string $version Indicates Ship API to display the new release features in Ship API response based on Ship release.  Valid values: - v2409 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $additionaladdressvalidation Valid Values:  city &#x3D; validation will include city.Length 15 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function shipmentRequest($body, $version, $trans_id = null, $transaction_src = 'testing', $additionaladdressvalidation = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling shipment'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling shipment'
            );
        }

        $resourcePath = '/shipments/{version}/ship';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($additionaladdressvalidation !== null) {
            $queryParams['additionaladdressvalidation'] = ObjectSerializer::toQueryValue($additionaladdressvalidation, null);
        }
        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation voidShipment
     *
     * Void Shipment
     *
     * @param  string $version API Version  Valid values: - v2409 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper
     */
    public function voidShipment($version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        list($response) = $this->voidShipmentWithHttpInfo($version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber);
        return $response;
    }

    /**
     * Operation voidShipmentWithHttpInfo
     *
     * Void Shipment
     *
     * @param  string $version API Version  Valid values: - v2409 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \UPS\Shipping\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function voidShipmentWithHttpInfo($version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        $returnType = '\UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper';
        $request = $this->voidShipmentRequest($version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Shipping\Shipping\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation voidShipmentAsync
     *
     * Void Shipment
     *
     * @param  string $version API Version  Valid values: - v2409 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function voidShipmentAsync($version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        return $this->voidShipmentAsyncWithHttpInfo($version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation voidShipmentAsyncWithHttpInfo
     *
     * Void Shipment
     *
     * @param  string $version API Version  Valid values: - v2409 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function voidShipmentAsyncWithHttpInfo($version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        $returnType = '\UPS\Shipping\Shipping\VOIDSHIPMENTResponseWrapper';
        $request = $this->voidShipmentRequest($version, $shipmentidentificationnumber, $trans_id, $transaction_src, $trackingnumber);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'voidShipment'
     *
     * @param  string $version API Version  Valid values: - v2409 (required)
     * @param  string $shipmentidentificationnumber The shipment&#x27;s identification number  Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $trackingnumber The package&#x27;s tracking number. You may have  up to 20 different tracking numbers listed. If more than one tracking number, pass this  value as: trackingnumber&#x3D;  [\&quot;1ZISUS010330563105\&quot;,\&quot;1ZISUS01033056310 8\&quot;] with a coma separating each number. Alpha-numeric. Must pass 1Z rules. Must be  upper case. Length 18 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function voidShipmentRequest($version, $shipmentidentificationnumber, $trans_id = null, $transaction_src = 'testing', $trackingnumber = null)
    {
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling voidShipment'
            );
        }
        // verify the required parameter 'shipmentidentificationnumber' is set
        if ($shipmentidentificationnumber === null || (is_array($shipmentidentificationnumber) && count($shipmentidentificationnumber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipmentidentificationnumber when calling voidShipment'
            );
        }

        $resourcePath = '/shipments/{version}/void/cancel/{shipmentidentificationnumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($trackingnumber !== null) {
            $queryParams['trackingnumber'] = ObjectSerializer::toQueryValue($trackingnumber, null);
        }
        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }
        // path params
        if ($shipmentidentificationnumber !== null) {
            $resourcePath = str_replace(
                '{' . 'shipmentidentificationnumber' . '}',
                ObjectSerializer::toPathValue($shipmentidentificationnumber),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
