<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Wireless\V1\Sim;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class UsageRecordOptions
{
    /**
     * @param \DateTime $end         The end
     * @param \DateTime $start       The start
     * @param string    $granularity The granularity
     *
     * @return ReadUsageRecordOptions Options builder
     */
    public static function read($end = Values::NONE, $start = Values::NONE, $granularity = Values::NONE)
    {
        return new ReadUsageRecordOptions($end, $start, $granularity);
    }
}

class ReadUsageRecordOptions extends Options
{
    /**
     * @param \DateTime $end         The end
     * @param \DateTime $start       The start
     * @param string    $granularity The granularity
     */
    public function __construct($end = Values::NONE, $start = Values::NONE, $granularity = Values::NONE)
    {
        $this->options['end'] = $end;
        $this->options['start'] = $start;
        $this->options['granularity'] = $granularity;
    }

    /**
     * The end
     *
     * @param \DateTime $end The end
     *
     * @return $this Fluent Builder
     */
    public function setEnd($end)
    {
        $this->options['end'] = $end;
        return $this;
    }

    /**
     * The start
     *
     * @param \DateTime $start The start
     *
     * @return $this Fluent Builder
     */
    public function setStart($start)
    {
        $this->options['start'] = $start;
        return $this;
    }

    /**
     * The granularity
     *
     * @param string $granularity The granularity
     *
     * @return $this Fluent Builder
     */
    public function setGranularity($granularity)
    {
        $this->options['granularity'] = $granularity;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Wireless.V1.ReadUsageRecordOptions '.implode(' ', $options).']';
    }
}