<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Proxy\V1\Service\Session;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class InteractionOptions
{
    /**
     * @param string $inboundParticipantStatus  The Inbound Participant Status of
     *                                          this Interaction
     * @param string $outboundParticipantStatus The Outbound Participant Status of
     *                                          this Interaction
     *
     * @return ReadInteractionOptions Options builder
     */
    public static function read($inboundParticipantStatus = Values::NONE, $outboundParticipantStatus = Values::NONE)
    {
        return new ReadInteractionOptions($inboundParticipantStatus, $outboundParticipantStatus);
    }
}

class ReadInteractionOptions extends Options
{
    /**
     * @param string $inboundParticipantStatus  The Inbound Participant Status of
     *                                          this Interaction
     * @param string $outboundParticipantStatus The Outbound Participant Status of
     *                                          this Interaction
     */
    public function __construct($inboundParticipantStatus = Values::NONE, $outboundParticipantStatus = Values::NONE)
    {
        $this->options['inboundParticipantStatus'] = $inboundParticipantStatus;
        $this->options['outboundParticipantStatus'] = $outboundParticipantStatus;
    }

    /**
     * The Inbound Participant Status of this Interaction. One of `accepted`, `answered`, `busy`, `canceled`, `completed`, `deleted`, `delivered`, `delivery-unknown`, `failed`, `in-progress`, `initiated`, `no-answer`, `queued`, `received`, `receiving`, `ringing`, `scheduled`, `sending`, `sent`, `undelivered` or `unknown`.
     *
     * @param string $inboundParticipantStatus The Inbound Participant Status of
     *                                         this Interaction
     *
     * @return $this Fluent Builder
     */
    public function setInboundParticipantStatus($inboundParticipantStatus)
    {
        $this->options['inboundParticipantStatus'] = $inboundParticipantStatus;
        return $this;
    }

    /**
     * The Outbound Participant Status of this Interaction. One of `accepted`, `answered`, `busy`, `canceled`, `completed`, `deleted`, `delivered`, `delivery-unknown`, `failed`, `in-progress`, `initiated`, `no-answer`, `queued`, `received`, `receiving`, `ringing`, `scheduled`, `sending`, `sent`, `undelivered` or `unknown`.
     *
     * @param string $outboundParticipantStatus The Outbound Participant Status of
     *                                          this Interaction
     *
     * @return $this Fluent Builder
     */
    public function setOutboundParticipantStatus($outboundParticipantStatus)
    {
        $this->options['outboundParticipantStatus'] = $outboundParticipantStatus;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Proxy.V1.ReadInteractionOptions '.implode(' ', $options).']';
    }
}